/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.api.entities.IEldritchMob;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.util.IShaderRenderingCallback;
import thecodex6824.thaumicaugmentation.common.util.ShaderType;

public class TileObelisk
extends TileEntity
implements ITickable,
IShaderRenderingCallback {
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected UUID wardOwner = IWardStorageServer.NIL_UUID;

    protected int getHealCycleLength() {
        switch (this.field_145850_b.func_175659_aa()) {
            case NORMAL: {
                return 30;
            }
            case HARD: {
                return 20;
            }
        }
        return 40;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            IWardStorage s;
            if (this.ticks % 40 == 0 && !this.wardOwner.equals(IWardStorageServer.NIL_UUID) && (s = (IWardStorage)this.field_145850_b.func_175726_f(this.field_174879_c).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer && !((IWardStorageServer)s).isWardOwner(this.wardOwner)) {
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(4)).func_177230_c() == TABlocks.CAPSTONE) {
                    this.field_145850_b.func_175698_g(this.field_174879_c.func_177979_c(4));
                }
                this.field_145850_b.func_175698_g(this.field_174879_c);
                return;
            }
            if (++this.ticks % this.getHealCycleLength() == 0) {
                boolean hard = this.field_145850_b.func_175659_aa() == EnumDifficulty.HARD;
                for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(6.0))) {
                    if (entity.field_70128_L || !(entity instanceof IEldritchMob)) continue;
                    if (entity.func_70687_e(new PotionEffect(MobEffects.field_76428_l, 1, 0))) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, hard ? 1 : 0, true, true));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 100, hard ? 1 : 0, true, true));
                        continue;
                    }
                    entity.func_70606_j(entity.func_110143_aJ() + 1.0f);
                }
            }
        } else if (this.field_145850_b.field_72995_K && ++this.ticks % 5 == 0) {
            boolean particles = false;
            for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(6.0))) {
                if (!(entity instanceof IEldritchMob)) continue;
                ThaumicAugmentation.proxy.getRenderHelper().renderFollowingParticles(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), (Entity)entity, 0.05f, 0.05f, 0.05f);
                ThaumicAugmentation.proxy.getRenderHelper().renderWisp(entity.field_70165_t, entity.field_70163_u + (double)this.field_145850_b.field_73012_v.nextFloat(), entity.field_70161_v, (Entity)entity);
                particles = true;
            }
            if (particles) {
                ThaumicAugmentation.proxy.getRenderHelper().renderObeliskParticles(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat() * 1.5f, (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() * 1.5f, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat() * 1.5f);
            }
        }
    }

    public void setBoundWard(UUID ward) {
        this.wardOwner = ward;
    }

    @Nullable
    public UUID getBoundWard() {
        return this.wardOwner;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public double func_145833_n() {
        return 16384.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(0.0, 1.0, 0.0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void renderWithShader(ShaderType type, double pX, double pY, double pZ) {
        ThaumicAugmentation.proxy.getRenderHelper().renderObelisk(type, this, pX, pY, pZ);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_186854_a("wardOwner", this.wardOwner);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.wardOwner = compound.func_186857_a("wardOwner");
    }
}

