/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.structure;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.EntityMindSpider;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.block.property.IAltarBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEldritchLockType;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IObeliskPart;
import thecodex6824.thaumicaugmentation.api.block.property.IObeliskType;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.api.block.property.IUrnType;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocasterEldritch;
import thecodex6824.thaumicaugmentation.common.entity.EntityFocusShield;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.common.tile.TileAltar;
import thecodex6824.thaumicaugmentation.common.tile.TileObelisk;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireTemplate;
import thecodex6824.thaumicaugmentation.common.world.structure.IAdvancedTemplateProcessor;

public class EldritchSpireComponent
extends StructureComponentTemplate {
    protected String name;
    protected boolean fillBlocks;
    protected UUID ward;

    public EldritchSpireComponent() {
        super(0);
    }

    public EldritchSpireComponent(TemplateManager templateManager, Template template, String templateName, boolean fillBelow, BlockPos position, Rotation rot, Mirror mi, UUID wardOwner) {
        super(0);
        if (template == null) {
            throw new NullPointerException("Structure template is null (removed template?): " + templateName);
        }
        this.name = templateName;
        this.fillBlocks = fillBelow;
        this.ward = wardOwner;
        this.field_186178_c = position;
        PlacementSettings settings = new PlacementSettings().func_186222_a(true).func_186220_a(rot).func_186214_a(mi);
        this.func_186173_a(new EldritchSpireTemplate(template), this.field_186178_c, settings);
    }

    public EldritchSpireComponent(TemplateManager templateManager, String templateName, boolean fillBelow, BlockPos position, Rotation rot, Mirror mi, UUID wardOwner) {
        this(templateManager, templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", templateName)), templateName, fillBelow, position, rot, mi, wardOwner);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox bb) {
        this.field_186177_b.func_186223_a(bb);
        ((EldritchSpireTemplate)this.field_186176_a).addBlocksToWorld(world, this.field_186178_c, new TemplateProcessor(this.field_186178_c, this.field_186177_b), this.field_186177_b, 18, this.ward);
        Map map = this.field_186176_a.func_186258_a(this.field_186178_c, this.field_186177_b);
        for (Map.Entry entry : map.entrySet()) {
            String s = (String)entry.getValue();
            this.func_186175_a(s, (BlockPos)entry.getKey(), world, random, bb);
        }
        return true;
    }

    public Template getTemplate() {
        return this.field_186176_a;
    }

    public boolean shouldFillBlocksBelow() {
        return this.fillBlocks;
    }

    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74778_a("tn", this.name);
        tag.func_74778_a("rot", this.field_186177_b.func_186215_c().name());
        tag.func_74778_a("mi", this.field_186177_b.func_186212_b().name());
        tag.func_186854_a("w", this.ward);
    }

    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        this.ward = tag.func_186857_a("w");
        this.name = tag.func_74779_i("tn");
        Rotation rot = Rotation.valueOf((String)tag.func_74779_i("rot"));
        Mirror mi = Mirror.valueOf((String)tag.func_74779_i("mi"));
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", this.name));
        PlacementSettings settings = new PlacementSettings().func_186222_a(true).func_186220_a(rot).func_186214_a(mi);
        this.func_186173_a(new EldritchSpireTemplate(template), this.field_186178_c, settings);
    }

    protected void setBlockStateClearWard(World world, BlockPos pos, IBlockState toPlace, int flags) {
        world.func_180501_a(pos, toPlace, flags);
        IWardStorage storage = (IWardStorage)world.func_175726_f(pos).getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage instanceof IWardStorageServer) {
            ((IWardStorageServer)storage).clearWard(pos, world);
        }
    }

    protected void func_186175_a(String function, BlockPos pos, World world, Random rand, StructureBoundingBox sbb) {
        if (function.startsWith("loot_")) {
            IBlockState toPlace = TABlocks.URN.func_176223_P();
            String id = function.substring(5);
            toPlace = id.equals("2") ? toPlace.func_177226_a(IUrnType.URN_TYPE, (Comparable)((Object)IUrnType.UrnType.URN_RARE)) : (id.equals("1") ? toPlace.func_177226_a(IUrnType.URN_TYPE, (Comparable)((Object)IUrnType.UrnType.URN_UNCOMMON)) : toPlace.func_177226_a(IUrnType.URN_TYPE, (Comparable)((Object)IUrnType.UrnType.URN_COMMON)));
            this.setBlockStateClearWard(world, pos, toPlace, 2);
        } else if (function.startsWith("pedestal_")) {
            IBlockState toPlace = null;
            String type = function.substring(9, 10);
            toPlace = type.equals("e") ? BlocksTC.pedestalEldritch.func_176223_P() : (type.equals("a") ? BlocksTC.pedestalAncient.func_176223_P() : BlocksTC.pedestalArcane.func_176223_P());
            int tableNum = 0;
            type = function.substring(11);
            if (type.equals("2")) {
                tableNum = 2;
            } else if (type.equals("1")) {
                tableNum = 1;
            }
            this.setBlockStateClearWard(world, pos, toPlace, 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TilePedestal) {
                LootTable table = null;
                switch (tableNum) {
                    case 1: {
                        table = world.func_184146_ak().func_186521_a(TALootTables.PEDESTAL_UNCOMMON);
                        break;
                    }
                    case 2: {
                        table = world.func_184146_ak().func_186521_a(TALootTables.PEDESTAL_RARE);
                        break;
                    }
                    default: {
                        table = world.func_184146_ak().func_186521_a(TALootTables.PEDESTAL_COMMON);
                    }
                }
                LootContext context = new LootContext.Builder((WorldServer)world).func_186471_a();
                ((TilePedestal)tile).func_70299_a(0, (ItemStack)table.func_186462_a(rand, context).get(0));
            }
        } else if (function.startsWith("autocaster")) {
            if (!function.equals("autocaster_random") || rand.nextBoolean()) {
                EntityAutocasterEldritch autocaster = new EntityAutocasterEldritch(world);
                autocaster.func_70107_b(Math.floor(pos.func_177958_n()) + 0.5, Math.floor(pos.func_177956_o()), Math.floor(pos.func_177952_p()) + 0.5);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos checkPos = pos.func_177972_a(facing.func_176734_d());
                    if (!world.func_180495_p(checkPos).isSideSolid((IBlockAccess)world, checkPos, facing)) continue;
                    autocaster.setFacing(facing);
                    break;
                }
                if (!MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent((EntityLiving)autocaster, world, (float)autocaster.field_70165_t, (float)autocaster.field_70163_u, (float)autocaster.field_70161_v))) {
                    autocaster.func_180482_a(world.func_175649_E(pos), null);
                    world.func_72838_d((Entity)autocaster);
                }
            }
        } else if (function.equals("eg")) {
            EntityTAEldritchGuardian entity = new EntityTAEldritchGuardian(world);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextInt(360), 0.0f);
            entity.func_110163_bv();
            if (!MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent((EntityLiving)entity, world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v))) {
                entity.func_180482_a(world.func_175649_E(pos), null);
                world.func_72838_d((Entity)entity);
            }
        } else if (function.equals("inz")) {
            EntityInhabitedZombie entity = new EntityInhabitedZombie(world);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (float)rand.nextInt(360), 0.0f);
            entity.func_110163_bv();
            if (!MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent((EntityLiving)entity, world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v))) {
                entity.func_180482_a(world.func_175649_E(pos), null);
                entity.func_82227_f(false);
                world.func_72838_d((Entity)entity);
            }
        } else if (function.equals("crab")) {
            EntityEldritchCrab entity = new EntityEldritchCrab(world);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (float)rand.nextInt(360), 0.0f);
            entity.func_110163_bv();
            if (!MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent((EntityLiving)entity, world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v))) {
                entity.func_180482_a(world.func_175649_E(pos), null);
                world.func_72838_d((Entity)entity);
            }
        } else if (function.equals("vent")) {
            IBlockState vent = TABlocks.CRAB_VENT.func_176223_P();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos checkPos = pos.func_177972_a(facing.func_176734_d());
                if (!world.func_180495_p(checkPos).isSideSolid((IBlockAccess)world, checkPos, facing)) continue;
                vent = vent.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)facing);
                break;
            }
            this.setBlockStateClearWard(world, pos, vent, 2);
        } else if (function.startsWith("obelisk_")) {
            String type = function.substring(8);
            IObeliskType.ObeliskType oType = null;
            oType = type.equals("e") ? IObeliskType.ObeliskType.ELDRITCH : IObeliskType.ObeliskType.ANCIENT;
            this.setBlockStateClearWard(world, pos, TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.CAP)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)oType)), 2);
            this.setBlockStateClearWard(world, pos.func_177984_a(), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.INNER)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)oType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(2), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.MIDDLE)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)oType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(3), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.INNER)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)oType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(4), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.CAP)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)oType)), 2);
            TileEntity tile = world.func_175625_s(pos.func_177981_b(2));
            if (tile instanceof TileObelisk) {
                ((TileObelisk)tile).setBoundWard(this.ward);
            }
        } else if (function.startsWith("lock_front_")) {
            EnumFacing face = null;
            String dir = function.substring(11, 12);
            face = dir.equals("e") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.EAST)) : (dir.equals("s") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.SOUTH)) : (dir.equals("w") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.WEST)) : this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.NORTH))));
            IBlockState state = TABlocks.ELDRITCH_LOCK_IMPETUS.func_176223_P();
            state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)face);
            this.setBlockStateClearWard(world, pos, state, 2);
        } else if (function.startsWith("lock_")) {
            EnumFacing face = null;
            String type = function.substring(5, 6);
            face = type.equals("e") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.EAST)) : (type.equals("s") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.SOUTH)) : (type.equals("w") ? this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.WEST)) : this.field_186177_b.func_186215_c().func_185831_a(this.field_186177_b.func_186212_b().func_185803_b(EnumFacing.NORTH))));
            IEldritchLockType.LockType lock = null;
            type = function.substring(7);
            lock = type.equals("maze") ? IEldritchLockType.LockType.LABYRINTH : (type.equals("prison") ? IEldritchLockType.LockType.PRISON : (type.equals("library") ? IEldritchLockType.LockType.LIBRARY : IEldritchLockType.LockType.BOSS));
            IBlockState state = TABlocks.ELDRITCH_LOCK.func_176223_P();
            state = state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)face);
            state = state.func_177226_a(IEldritchLockType.LOCK_TYPE, (Comparable)((Object)lock));
            this.setBlockStateClearWard(world, pos, state, 2);
        } else if (function.startsWith("key_")) {
            IBlockState toPlace = null;
            String type = function.substring(4, 5);
            toPlace = type.equals("e") ? BlocksTC.pedestalEldritch.func_176223_P() : (type.equals("a") ? BlocksTC.pedestalAncient.func_176223_P() : BlocksTC.pedestalArcane.func_176223_P());
            IEldritchLockType.LockType lock = null;
            type = function.substring(6);
            lock = type.equals("maze") ? IEldritchLockType.LockType.LABYRINTH : (type.equals("prison") ? IEldritchLockType.LockType.PRISON : (type.equals("library") ? IEldritchLockType.LockType.LIBRARY : IEldritchLockType.LockType.BOSS));
            this.setBlockStateClearWard(world, pos, toPlace, 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TilePedestal) {
                ((TilePedestal)tile).func_70299_a(0, lock.getKey());
            }
        } else if (function.startsWith("spawner_")) {
            String type = function.substring(8);
            ResourceLocation spawn = null;
            spawn = type.equals("mspider") ? EntityRegistry.getEntry(EntityMindSpider.class).getRegistryName() : (type.equals("crab") ? EntityRegistry.getEntry(EntityEldritchCrab.class).getRegistryName() : EntityRegistry.getEntry(EntityWisp.class).getRegistryName());
            this.setBlockStateClearWard(world, pos, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityMobSpawner) {
                MobSpawnerBaseLogic logic = ((TileEntityMobSpawner)tile).func_145881_a();
                logic.field_98285_e.clear();
                logic.func_190894_a(spawn);
            }
        } else if (function.startsWith("altar_")) {
            String type = function.substring(6);
            IBlockState toPlace = TABlocks.CAPSTONE.func_176223_P().func_177226_a((IProperty)IAltarBlock.ALTAR, (Comparable)Boolean.valueOf(true));
            IObeliskType.ObeliskType obeliskType = null;
            obeliskType = type.equals("e") ? IObeliskType.ObeliskType.ELDRITCH : IObeliskType.ObeliskType.ANCIENT;
            this.setBlockStateClearWard(world, pos, toPlace.func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(2), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.CAP)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(3), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.INNER)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(4), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.MIDDLE)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(5), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.INNER)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            this.setBlockStateClearWard(world, pos.func_177981_b(6), TABlocks.OBELISK.func_176223_P().func_177226_a(IObeliskPart.OBELISK_PART, (Comparable)((Object)IObeliskPart.ObeliskPart.CAP)).func_177226_a(IObeliskType.OBELISK_TYPE, (Comparable)((Object)obeliskType)), 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileAltar) {
                ((TileAltar)tile).setStructureAltar(true);
            }
        } else if (function.equals("eg_mb")) {
            EntityTAEldritchGuardian entity = new EntityTAEldritchGuardian(world);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextInt(360), 0.0f);
            entity.func_110163_bv();
            entity.func_96094_a(new TextComponentTranslation("thaumicaugmentation.text.entity.eldritch_guardian_mb", new Object[0]).func_150254_d());
            if (!MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent((EntityLiving)entity, world, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v))) {
                entity.func_180482_a(world.func_175649_E(pos), null);
                entity.func_110149_m(entity.func_110139_bj() * 2.0f);
                if (world.func_72838_d((Entity)entity)) {
                    EntityFocusShield shield = new EntityFocusShield(world);
                    shield.setOwner((Entity)entity);
                    shield.setCasterID(entity.getPersistentID());
                    shield.setColor(0x606060);
                    shield.setInfiniteLifespan();
                    if (world.func_175659_aa() == EnumDifficulty.HARD) {
                        shield.setMaxHealth(100.0f, false);
                        shield.setReflect(true);
                    } else if (world.func_175659_aa() == EnumDifficulty.NORMAL) {
                        shield.setMaxHealth(50.0f, false);
                    } else {
                        shield.setMaxHealth(20.0f, false);
                    }
                    shield.func_70606_j(shield.func_110138_aP());
                    world.func_72838_d((Entity)shield);
                }
            }
        }
    }

    public void onPostGeneration(World world, StructureBoundingBox structurebb) {
    }

    public static class TemplateProcessor
    implements IAdvancedTemplateProcessor {
        protected float chance;
        protected Random rand;

        public TemplateProcessor(BlockPos pos, PlacementSettings settings) {
            this.chance = settings.func_189948_f();
            this.rand = settings.func_189947_a(pos);
        }

        @Nullable
        public Template.BlockInfo func_189943_a(World world, BlockPos pos, Template.BlockInfo blockInfo) {
            return this.chance < 1.0f && this.rand.nextFloat() > this.chance ? null : blockInfo;
        }

        protected boolean isStateWardable(IBlockState state) {
            if (state.func_177230_c() == TABlocks.STONE) {
                ITAStoneType.StoneType stone = (ITAStoneType.StoneType)((Object)state.func_177229_b(ITAStoneType.STONE_TYPE));
                if (stone == ITAStoneType.StoneType.STONE_CRUSTED || stone == ITAStoneType.StoneType.STONE_CRUSTED_GLOWING) {
                    return false;
                }
            } else {
                if (state.func_177230_c() == BlocksTC.stonePorous) {
                    return false;
                }
                if (state.func_177230_c() == TABlocks.STRANGE_CRYSTAL) {
                    return false;
                }
                if (state.func_177230_c() == Blocks.field_150321_G) {
                    return false;
                }
                if (state.func_185904_a().func_76224_d()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean shouldBlockBeWarded(World world, BlockPos pos, Template.BlockInfo blockInfo) {
            return blockInfo.field_186244_c == null && this.isStateWardable(blockInfo.field_186243_b);
        }
    }
}

