/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.ThaumicAugmentationCore;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerWardBlockNoEndermanPickup
extends Transformer {
    private static final String CLASS = "net.minecraft.entity.monster.EntityEnderman$AITakeBlock";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return !ThaumicAugmentationCore.getConfig().getBoolean("DisableWardFocus", "gameplay.ward", false, "") && transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode pickup = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/entity/monster/EntityEnderman$AITakeBlock", "func_75246_d", Type.VOID_TYPE, new Type[0]), "()V");
            boolean found = false;
            int ret = pickup.instructions.size();
            while ((ret = TransformUtil.findLastInstanceOfOpcode(pickup, ret, 153)) != -1) {
                AbstractInsnNode insertAfter = pickup.instructions.get(ret);
                if (insertAfter.getPrevious() instanceof VarInsnNode && ((VarInsnNode)insertAfter.getPrevious()).var == 10) {
                    pickup.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)insertAfter).label));
                    pickup.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "checkWardGeneric", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
                    pickup.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 6));
                    pickup.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 2));
                    found = true;
                    break;
                }
                --ret;
            }
            if (!found) {
                throw new TransformerException("Could not locate required instructions");
            }
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

