/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.storage;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class LocalRegion {
    private int x;
    private int z;

    public static LocalRegion getFromBlockPos(BlockPos pos) {
        return LocalRegion.getFromBlockPos(pos.func_177958_n(), pos.func_177952_p());
    }

    public static LocalRegion getFromBlockPos(int x, int z) {
        return new LocalRegion(x >> 9, z >> 9);
    }

    private LocalRegion(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String getFileName() {
        return "r." + this.x + "." + this.z;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("z", this.z);
        return nbt;
    }

    public static LocalRegion readFromNBT(NBTTagCompound nbt) {
        return new LocalRegion(nbt.func_74762_e("x"), nbt.func_74762_e("z"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRegion other = (LocalRegion)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }
}

