/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.inventory;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.inventory.container.ContainerBarrel;
import thebetweenlands.common.tile.TileEntityBarrel;

@SideOnly(value=Side.CLIENT)
public class GuiTarBarrel
extends GuiContainer {
    private TileEntityBarrel barrel;
    private static final ResourceLocation TAR_BARREL_GUI_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/tar_barrel.png");
    private DecimalFormat numberFormat;

    public GuiTarBarrel(InventoryPlayer inv, TileEntityBarrel tile) {
        super((Container)new ContainerBarrel(inv, tile));
        this.barrel = tile;
        this.numberFormat = new DecimalFormat();
        this.numberFormat.setMinimumFractionDigits(1);
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setRoundingMode(RoundingMode.DOWN);
    }

    protected void func_146976_a(float partialTickTime, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TAR_BARREL_GUI_TEXTURE);
        int xx = this.field_147003_i;
        int yy = this.field_147009_r;
        this.func_73729_b(xx, yy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(xx + 140, yy + 16, 176, 64, 16, 16);
        IFluidTankProperties props = this.barrel.getTankProperties()[0];
        FluidStack fluidStack = props.getContents();
        if (fluidStack != null) {
            ResourceLocation fluidTexture = fluidStack.getFluid().getStill();
            int color = fluidStack.getFluid().getColor(fluidStack);
            int barHeight = MathHelper.func_76123_f((float)((float)(57 * fluidStack.amount) / (float)props.getCapacity()));
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            if (fluidTexture != null) {
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTexture.toString());
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                this.drawTexturedBar(xx + 64, yy + 71, sprite, 47, 57, barHeight);
                this.drawTexturedBar(xx + 140, yy + 32, sprite, 16, 16, 16);
            } else {
                GlStateManager.func_179090_x();
                GuiTarBarrel.func_73734_a((int)(xx + 64), (int)(yy + 71 - barHeight), (int)(xx + 64 + 47), (int)(yy + 71), (int)color);
                GuiTarBarrel.func_73734_a((int)(xx + 140), (int)(yy + 16), (int)(xx + 140 + 16), (int)(yy + 16 + 16), (int)color);
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(TAR_BARREL_GUI_TEXTURE);
            this.func_73729_b(xx + 64, yy + 12, 176, 1, 47, 62);
            this.func_73729_b(xx + 140, yy + 16, 193, 64, 16, 16);
            this.field_146289_q.func_78276_b(this.numberFormat.format(fluidStack != null ? (double)((float)fluidStack.amount / 1000.0f) : 0.0), xx + 127, yy + 26, -1);
            GlStateManager.func_179084_k();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        IFluidTankProperties props;
        FluidStack fluidStack;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.func_146978_c(69, 16, 37, 54, mouseX, mouseY) && (fluidStack = (props = this.barrel.getTankProperties()[0]).getContents()) != null) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(fluidStack.getLocalizedName() + " (" + fluidStack.amount + "mb)");
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void drawTexturedBar(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn, int fullHeight) {
        if (heightIn <= 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int yStart = 0; yStart < fullHeight; yStart += heightIn) {
            int segmentHeight = Math.min(yStart + heightIn, fullHeight) - yStart;
            float fraction = (float)segmentHeight / (float)heightIn;
            float minU = textureSprite.func_94209_e();
            float minV = textureSprite.func_94206_g();
            float maxU = textureSprite.func_94212_f();
            float maxV = textureSprite.func_94210_h();
            maxV = minV + (maxV - minV) * fraction;
            int yOff = -yStart - (int)((float)heightIn * fraction);
            bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yOff + yCoord + 0), (double)this.field_73735_i).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yOff + yCoord + 0), (double)this.field_73735_i).func_187315_a((double)minU, (double)maxV).func_181675_d();
            bufferbuilder.func_181662_b((double)(xCoord + 0), (double)((float)(yOff + yCoord) + (float)heightIn * fraction), (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181675_d();
            bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)((float)(yOff + yCoord) + (float)heightIn * fraction), (double)this.field_73735_i).func_187315_a((double)maxU, (double)minV).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

