/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.client.audio.RainBackgroundSound;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.SoundRegistry;

public class AmbienceSoundPlayHandler {
    private static List<RainPosition> rainPositions = new ArrayList<RainPosition>();
    private static float relRainX = 0.0f;
    private static float relRainY = 0.0f;
    private static float relRainZ = 0.0f;
    private static float rainAbove = 0.0f;
    private static float rainVolume = 0.0f;
    private static int rainSoundTimer = 30;

    public static float getRelativeRainX() {
        return relRainX;
    }

    public static float getRelativeRainY() {
        return relRainY;
    }

    public static float getRelativeRainZ() {
        return relRainZ;
    }

    public static float getRainAbove() {
        return rainAbove;
    }

    public static float getRainVolume() {
        return rainVolume;
    }

    @SubscribeEvent
    public static void onPlayerCltTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.CLIENT && event.player == TheBetweenlands.proxy.getClientPlayer()) {
            AmbienceManager.INSTANCE.update();
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float isAbove = 0.0f;
            float rd = Float.MAX_VALUE;
            if (!rainPositions.isEmpty()) {
                float totalWeight = 0.0f;
                boolean playSound = false;
                if (rainSoundTimer-- < 0) {
                    rainSoundTimer = 30 + event.player.field_70170_p.field_73012_v.nextInt(20);
                    playSound = true;
                }
                Iterator<RainPosition> it = rainPositions.iterator();
                while (it.hasNext()) {
                    RainPosition position = it.next();
                    float weight = (float)(position.timer + 1) / 41.0f;
                    totalWeight += weight;
                    rx += (float)((RainPosition)position).position.field_72450_a * weight;
                    ry += (float)((RainPosition)position).position.field_72448_b * weight;
                    rz += (float)((RainPosition)position).position.field_72449_c * weight;
                    isAbove += (float)(position.isAbove ? 1 : 0) * weight;
                    rd = Math.min(rd, (float)Math.sqrt(position.position.func_72433_c()));
                    if (playSound && position.timer > 28) {
                        PositionedSoundRecord sound = new PositionedSoundRecord(AmbienceSoundPlayHandler.getSoundForDistance((float)position.position.func_72433_c() - 3.0f, position.isAbove ? 1.0f : 0.0f), SoundCategory.WEATHER, position.isAbove ? 0.05f : 0.1f, position.isAbove ? 0.5f : 0.9f, (float)((RainPosition)position).position.field_72450_a + (float)event.player.field_70165_t, (float)((RainPosition)position).position.field_72448_b + (float)event.player.field_70163_u, (float)((RainPosition)position).position.field_72449_c + (float)event.player.field_70161_v);
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
                    }
                    if (--position.timer >= 0) continue;
                    it.remove();
                }
                float blend = 0.25f;
                relRainX = (1.0f - blend) * relRainX + blend * (rx /= totalWeight);
                relRainY = (1.0f - blend) * relRainY + blend * (ry /= totalWeight);
                relRainZ = (1.0f - blend) * relRainZ + blend * (rz /= totalWeight);
                rainAbove = (1.0f - blend) * rainAbove + blend * (isAbove /= totalWeight);
                rainVolume = (1.0f - blend) * rainVolume + blend * MathHelper.func_76131_a((float)(1.0f / (rd - 0.5f)), (float)0.0f, (float)1.0f);
                if (playSound) {
                    RainBackgroundSound rainSound = new RainBackgroundSound(AmbienceSoundPlayHandler.getSoundForDistance(rd, rainAbove * 2.0f), SoundCategory.WEATHER);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)rainSound);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySoundSource(SoundEvent.SoundSourceEvent event) {
        if (event.getSound().func_184365_d() == SoundCategory.MUSIC && AmbienceManager.INSTANCE.shouldStopMusic()) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(event.getSound());
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        ISound sound = event.getResultSound();
        if (sound != null) {
            boolean isWeatherSound = SoundEvents.field_187918_gr.func_187503_a().equals((Object)sound.func_147650_b());
            boolean isWeatherSoundAbove = SoundEvents.field_187919_gs.func_187503_a().equals((Object)sound.func_147650_b());
            if (isWeatherSound || isWeatherSoundAbove) {
                Entity view = Minecraft.func_71410_x().func_175606_aa();
                if (view != null && rainPositions.size() < 100) {
                    rainPositions.add(new RainPosition(new Vec3d((double)(sound.func_147649_g() - (float)view.field_70165_t), (double)(sound.func_147654_h() - (float)view.field_70163_u), (double)(sound.func_147651_i() - (float)view.field_70161_v)), isWeatherSoundAbove));
                }
                event.setResultSound(null);
            }
        }
    }

    private static SoundEvent getSoundForDistance(float distance, float rainAbove) {
        float value = distance + rainAbove * 2.0f;
        if (value >= 3.0f) {
            return SoundRegistry.RAIN_DRIPPING;
        }
        if (value >= 2.0f) {
            return SoundRegistry.RAIN_WEAK;
        }
        if (value >= 1.0f) {
            return SoundRegistry.RAIN_MEDIUM;
        }
        return SoundRegistry.RAIN_STRONG;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            AmbienceManager.INSTANCE.stopAll();
        }
    }

    private static class RainPosition {
        private static final int MAX_TIMER = 40;
        private final Vec3d position;
        private final boolean isAbove;
        private int timer;

        private RainPosition(Vec3d position, boolean isAbove) {
            this.position = position;
            this.isAbove = isAbove;
            this.timer = 40;
        }
    }
}

