/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.render.sprite.TextureCorrosion;
import thebetweenlands.client.render.sprite.TextureFromData;
import thebetweenlands.client.render.tile.RenderBarrel;
import thebetweenlands.client.render.tile.RenderCenser;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.ModelRegistry;
import thebetweenlands.util.TexturePacker;

public class TextureStitchHandler {
    public static final TextureStitchHandler INSTANCE = new TextureStitchHandler();
    private final List<TextureCorrosion> stitchedCorrosionSprites = new ArrayList<TextureCorrosion>();
    private final List<TextureStitcher> stitchers = new ArrayList<TextureStitcher>();

    public void registerTextureStitcher(TextureStitcher splitter) {
        this.stitchers.add(splitter);
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre e) {
        Map mapRegisteredSprites;
        if (e.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        for (Fluid fluid : FluidRegistry.REGISTERED_FLUIDS) {
            e.getMap().func_174942_a(fluid.getFlowing());
            e.getMap().func_174942_a(fluid.getStill());
        }
        e.getMap().func_174942_a(RenderBarrel.WHITE_SPRITE_PATH);
        e.getMap().func_174942_a(RenderCenser.CENSER_FOG_PATH);
        long packingStartTime = System.nanoTime();
        Map<ResourceLocation, BufferedImage> packedTextures = ModelRegistry.MODEL_TEXTURE_PACKER.pack(Minecraft.func_71410_x().func_110442_L());
        TheBetweenlands.logger.info("Packed model textures in " + (float)(System.nanoTime() - packingStartTime) / 1000000.0f + "ms");
        TheBetweenlands.logger.info("Optimal footprint: " + ModelRegistry.MODEL_TEXTURE_PACKER.getOptimalFootprint() + "px^2, Packed footprint: " + ModelRegistry.MODEL_TEXTURE_PACKER.getPackedFootprint() + "px^2");
        if (BetweenlandsConfig.DEBUG.dumpPackedTextures) {
            for (Map.Entry entry : packedTextures.entrySet()) {
                try {
                    File f = new File("betweenlands/packed_textures/" + ((ResourceLocation)entry.getKey()).func_110623_a() + ".png");
                    f.mkdirs();
                    ImageIO.write((RenderedImage)entry.getValue(), "PNG", f);
                }
                catch (IOException ex) {
                    TheBetweenlands.logger.error("Failed dumping packed texture", (Throwable)ex);
                }
            }
        }
        for (TexturePacker.TextureQuadMap textureQuadMap : ModelRegistry.MODEL_TEXTURE_PACKER.getTextureMaps()) {
            if (textureQuadMap.getOwner() == null) continue;
            textureQuadMap.getOwner().onPacked();
        }
        for (Map.Entry entry : packedTextures.entrySet()) {
            e.getMap().setTextureEntry((TextureAtlasSprite)new TextureFromData(((ResourceLocation)entry.getKey()).toString(), (BufferedImage)entry.getValue()));
        }
        this.stitchedCorrosionSprites.clear();
        try {
            mapRegisteredSprites = e.getMap().field_110574_e;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load underlying sprite map", exception);
        }
        for (Item item : ItemRegistry.ITEMS) {
            ResourceLocation[] variants;
            if (!(item instanceof ICorrodible)) continue;
            for (ResourceLocation variant : variants = ICorrodible.getItemCorrodibleVariants((Item)((ICorrodible)item))) {
                try {
                    ResourceLocation modelLocation = new ResourceLocation(variant.func_110624_b(), "item/" + variant.func_110623_a());
                    IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
                    ArrayList textures = Lists.newArrayList();
                    textures.addAll(model.getTextures());
                    List<IModel> dependencies = this.gatherModelDependencies(model, new ArrayList<IModel>());
                    for (IModel dependencyModel : dependencies) {
                        Collection dependencyTextures = dependencyModel.getTextures();
                        for (ResourceLocation dependencyTexture : dependencyTextures) {
                            if (textures.contains(dependencyTexture)) continue;
                            textures.add(dependencyTexture);
                        }
                    }
                    for (ResourceLocation texture : textures) {
                        String path = texture.func_110623_a();
                        if (!path.contains("/")) continue;
                        String corrodibleSuffix = "_corrodible";
                        String fileName = texture.func_110623_a().substring(texture.func_110623_a().lastIndexOf("/") + 1);
                        if (!fileName.endsWith(corrodibleSuffix)) continue;
                        ResourceLocation completeBaseTextureLocation = new ResourceLocation(texture.func_110624_b(), String.format("textures/%s.png", texture.func_110623_a()));
                        for (int n = 0; n < 6; ++n) {
                            String corrosionSpriteName = texture.func_110624_b() + ":" + path.substring(0, path.length() - corrodibleSuffix.length()) + "_corrosion_" + n;
                            TextureCorrosion corrosionTexture = new TextureCorrosion(corrosionSpriteName, completeBaseTextureLocation, n, item.func_77658_a().hashCode());
                            mapRegisteredSprites.put(corrosionSpriteName, corrosionTexture);
                            this.stitchedCorrosionSprites.add(corrosionTexture);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to load corrosion texture", ex);
                }
            }
        }
        HashMap<ResourceLocation, Frame[]> hashMap = new HashMap<ResourceLocation, Frame[]>();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        for (TextureStitcher stitcher : this.stitchers) {
            ResourceLocation[] textures = stitcher.getTextures();
            Frame[][] frames = new Frame[textures.length][];
            for (int i = 0; i < textures.length; ++i) {
                TextureAtlasSprite sprite = e.getMap().func_174942_a(textures[i]);
                if (stitcher.splitFrames) {
                    try {
                        ResourceLocation resourceLocation = this.getResourceLocation(e.getMap().getBasePath(), sprite);
                        Frame[] cachedFrames = (Frame[])hashMap.get(resourceLocation);
                        if (cachedFrames != null) {
                            frames[i] = cachedFrames;
                            continue;
                        }
                        IResource resource = null;
                        if (sprite.hasCustomLoader(resourceManager, resourceLocation)) {
                            sprite.load(resourceManager, resourceLocation, l -> (TextureAtlasSprite)mapRegisteredSprites.get(l.toString()));
                        } else {
                            PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resourceManager.func_110536_a(resourceLocation));
                            resource = resourceManager.func_110536_a(resourceLocation);
                            boolean hasAnimation = resource.func_110526_a("animation") != null;
                            sprite.func_188538_a(pngSizeInfo, hasAnimation);
                        }
                        sprite.func_188539_a(resource, e.getMap().getMipmapLevels() + 1);
                        if (sprite.func_94211_a() < 16) {
                            TheBetweenlands.logger.warn("Sprite '" + textures[i] + "' has frames that are smaller than 16x16, this is not allowed!");
                            frames[i] = new Frame[]{new Frame(TextureMap.field_174945_f, e.getMap().func_174944_f(), 20)};
                        } else if (!sprite.func_130098_m() || sprite.func_110970_k() == 1) {
                            frames[i] = new Frame[]{new Frame(textures[i], sprite, 0)};
                        } else {
                            AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource.func_110526_a("animation");
                            boolean hasFrameMeta = animationMetadata.func_110473_c() > 0;
                            int frameCount = hasFrameMeta ? animationMetadata.func_110473_c() : sprite.func_110970_k();
                            frames[i] = new Frame[frameCount];
                            for (int frame = 0; frame < frameCount; ++frame) {
                                int duration = hasFrameMeta ? animationMetadata.func_110472_a(frame) : animationMetadata.func_110469_d();
                                int index = hasFrameMeta ? animationMetadata.func_110468_c(frame) : frame;
                                int[] frameData = sprite.func_147965_a(index)[0];
                                TextureFromData frameSprite = new TextureFromData(sprite.func_94215_i() + "_frame_" + frame, frameData, sprite.func_94211_a(), sprite.func_94216_b());
                                e.getMap().setTextureEntry((TextureAtlasSprite)frameSprite);
                                frames[i][frame] = new Frame(textures[i], frameSprite, duration);
                            }
                        }
                        hashMap.put(resourceLocation, frames[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed splitting texture animation", ex);
                    }
                }
                frames[i] = new Frame[]{new Frame(textures[i], sprite, 0)};
            }
            TextureStitcher.access$102(stitcher, frames);
        }
    }

    private ResourceLocation getResourceLocation(String basePath, TextureAtlasSprite sprite) {
        ResourceLocation resourcelocation = new ResourceLocation(sprite.func_94215_i());
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", basePath, resourcelocation.func_110623_a(), ".png"));
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post e) {
        if (e.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        TextureMap map = e.getMap();
        for (TextureCorrosion corrosionSprite : this.stitchedCorrosionSprites) {
            String parentIconName = corrosionSprite.getParentSpriteName().toString();
            TextureAtlasSprite parentSprite = map.getTextureExtry(parentIconName);
            if (parentSprite == null) continue;
            corrosionSprite.setParentSprite(parentSprite);
        }
        this.stitchedCorrosionSprites.clear();
        for (TextureStitcher splitter : this.stitchers) {
            if (splitter.callback == null) continue;
            splitter.callback.accept(splitter);
        }
    }

    private List<IModel> gatherModelDependencies(IModel model, List<IModel> foundDependencies) {
        Collection dependencies = model.getDependencies();
        for (ResourceLocation dependency : dependencies) {
            try {
                IModel dependencyModel = ModelLoaderRegistry.getModel((ResourceLocation)dependency);
                if (foundDependencies.contains(dependencyModel)) continue;
                foundDependencies.add(dependencyModel);
                this.gatherModelDependencies(dependencyModel, foundDependencies);
            }
            catch (ModelLoaderRegistry.LoaderException dependencyModel) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return foundDependencies;
    }

    public static final class Frame {
        private final ResourceLocation location;
        private final TextureAtlasSprite sprite;
        private final int duration;

        protected Frame(ResourceLocation location, TextureAtlasSprite sprite, int duration) {
            this.location = location;
            this.sprite = sprite;
            this.duration = duration;
        }

        public ResourceLocation getLocation() {
            return this.location;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    public static final class TextureStitcher {
        private final Consumer<TextureStitcher> callback;
        private final ResourceLocation[] textures;
        private Frame[][] frames;
        private boolean splitFrames;

        public TextureStitcher(ResourceLocation ... textures) {
            this((Consumer<TextureStitcher>)null, textures);
        }

        public TextureStitcher(@Nullable Consumer<TextureStitcher> callback, ResourceLocation ... textures) {
            this.textures = textures;
            this.callback = callback;
        }

        public TextureStitcher setSplitFrames(boolean split) {
            this.splitFrames = split;
            return this;
        }

        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        public Frame[][] getFrames() {
            return this.frames;
        }

        static /* synthetic */ Frame[][] access$102(TextureStitcher x0, Frame[][] x1) {
            x0.frames = x1;
            return x1;
        }
    }
}

