/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import thebetweenlands.client.render.model.entity.ModelSwarm;
import thebetweenlands.common.entity.mobs.EntitySwarm;

public class RenderSwarm
extends RenderLiving<EntitySwarm> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/swarm.png");
    protected static final ModelSwarm MODEL = new ModelSwarm();
    private float partialTicks;

    public RenderSwarm(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)MODEL, 0.0f);
    }

    public void doRender(EntitySwarm entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.partialTicks = partialTicks;
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected float getDeathMaxRotation(EntitySwarm entityLivingBaseIn) {
        return 0.0f;
    }

    protected void applyRotations(EntitySwarm entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
    }

    protected void renderModel(EntitySwarm entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean isTranslucent;
        boolean isVisible = this.func_193115_c((EntityLivingBase)entity);
        boolean bl = isTranslucent = !isVisible && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (isVisible || isTranslucent) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (isTranslucent) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
            int count = Math.round(entity.getSwarmSize() * 4.0f);
            float offset = (float)Math.abs(Math.sin(ageInTicks * 0.01f) * (double)0.05f) + 0.15f;
            float radius = count == 1 ? 0.0f : (float)count / 4.0f * 0.45f + 0.2f;
            float entityYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * this.partialTicks;
            float move = Math.max(1.0f - limbSwingAmount / 0.3f, 0.0f);
            for (int i = 0; i < count; ++i) {
                float time1 = ageInTicks;
                float ox = MathHelper.func_76134_b((float)((float)i / 4.0f * (float)Math.PI * 2.0f)) * radius + MathHelper.func_76126_a((float)(time1 * 0.1f * (1.0f + (float)i / 4.0f * 0.3f) + (float)i * 0.34f)) * offset;
                float oy = (float)i / 4.0f * 0.5f + 1.5f + MathHelper.func_76126_a((float)(time1 * 0.2f * (1.0f + (float)i / 4.0f * 0.2f) + (float)i * 1.5f)) * offset;
                float oz = MathHelper.func_76126_a((float)((float)i / 4.0f * (float)Math.PI * 2.0f)) * radius + MathHelper.func_76126_a((float)(time1 * 0.05f * (1.0f + (float)i / 4.0f * 0.5f) - (float)i * 2.4f)) * offset;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)ox, (float)oy, (float)oz);
                GlStateManager.func_179114_b((float)(entityYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((1.0f - move) * 0.5f));
                this.field_77045_g.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            if (isTranslucent) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntitySwarm entity) {
        return TEXTURE;
    }
}

