/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;

@SideOnly(value=Side.CLIENT)
public class ParticleBatchTypeBuilder {
    private List<Pass> passes = new ArrayList<Pass>();
    private Pass mainPass;
    private Predicate<Particle> filter;

    public Pass pass() {
        return this.pass(true);
    }

    public Pass pass(boolean main) {
        Pass pass = new Pass(this);
        if (main) {
            this.mainPass = pass;
        }
        this.passes.add(pass);
        return pass;
    }

    public ParticleBatchTypeBuilder filter(@Nullable Predicate<Particle> filter) {
        this.filter = filter;
        return this;
    }

    public BatchedParticleRenderer.ParticleBatchType build() {
        Preconditions.checkNotNull((Object)this.mainPass, (Object)"Particle batch type requires at least one pass");
        BatchedParticleRenderer.ParticleBatchType type = new BatchedParticleRenderer.ParticleBatchType(){
            private ResourceLocation boundTexture = null;

            @Override
            public boolean filter(Particle particle) {
                if (ParticleBatchTypeBuilder.this.filter != null) {
                    return ParticleBatchTypeBuilder.this.filter.test(particle);
                }
                return true;
            }

            @Nullable
            protected ResourceLocation preSetup(Pass pass) {
                if (pass.preRenderPassCallback != null) {
                    pass.preRenderPassCallback.run();
                }
                if (pass.setCull) {
                    if (pass.cull) {
                        GlStateManager.func_179089_o();
                    } else {
                        GlStateManager.func_179129_p();
                    }
                }
                if (pass.setDepthTest) {
                    if (pass.depthTest) {
                        GlStateManager.func_179126_j();
                    } else {
                        GlStateManager.func_179097_i();
                    }
                }
                if (pass.setDepthMask) {
                    if (pass.depthMask) {
                        GlStateManager.func_179132_a((boolean)true);
                    } else {
                        GlStateManager.func_179132_a((boolean)false);
                    }
                }
                if (pass.setColorMask) {
                    GlStateManager.func_179135_a((boolean)pass.colorMaskR, (boolean)pass.colorMaskG, (boolean)pass.colorMaskB, (boolean)pass.colormaskA);
                }
                if (pass.setLit) {
                    if (pass.lit) {
                        Minecraft.func_71410_x().field_71460_t.func_180436_i();
                    } else {
                        Minecraft.func_71410_x().field_71460_t.func_175072_h();
                    }
                }
                if (pass.setFog) {
                    if (pass.fog) {
                        GlStateManager.func_179127_m();
                    } else {
                        GlStateManager.func_179106_n();
                    }
                }
                if (pass.setBlend) {
                    if (pass.blend) {
                        GlStateManager.func_179147_l();
                    } else {
                        GlStateManager.func_179084_k();
                    }
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)pass.glBlendSrc, (GlStateManager.DestFactor)pass.glBlendDst);
                }
                if (pass.texture != null && pass.setTexture) {
                    ResourceLocation texLoc = (ResourceLocation)pass.texture.get();
                    if (texLoc != null) {
                        ITextureObject tex;
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(texLoc);
                        if (pass.setBlur && (tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(texLoc)) != null) {
                            tex.func_174936_b(pass.blur, pass.mipmap);
                        }
                    }
                    return texLoc;
                }
                return null;
            }

            protected void postSetup(Pass pass, @Nullable ResourceLocation texLoc) {
                if (pass.postRenderPassCallback != null) {
                    pass.postRenderPassCallback.run();
                }
                if (texLoc != null && pass.setTexture) {
                    ITextureObject tex;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(texLoc);
                    if (pass.setBlur && (tex = Minecraft.func_71410_x().func_110434_K().func_110581_b(texLoc)) != null) {
                        tex.func_174935_a();
                    }
                }
            }

            @Override
            protected void preRender(Tessellator tessellator, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
                this.boundTexture = this.preSetup(ParticleBatchTypeBuilder.this.mainPass);
                tessellator.func_178180_c().func_181668_a(ParticleBatchTypeBuilder.this.mainPass.glPrimitive, ParticleBatchTypeBuilder.this.mainPass.format);
            }

            @Override
            protected void postRender(Tessellator tessellator, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
                this.postSetup(ParticleBatchTypeBuilder.this.mainPass, this.boundTexture);
                boolean firstPass = true;
                BufferBuilder buffer = tessellator.func_178180_c();
                VertexFormat format = buffer.func_178973_g();
                ByteBuffer byteBuffer = buffer.func_178966_f();
                int drawMode = buffer.func_178979_i();
                int vertexCount = buffer.func_178989_h();
                for (Pass pass : ParticleBatchTypeBuilder.this.passes) {
                    ResourceLocation localBoundTex = this.preSetup(pass);
                    if (pass.depthMask && pass.depthMaskPass) {
                        GlStateManager.func_179132_a((boolean)false);
                        if (firstPass) {
                            tessellator.func_78381_a();
                        } else {
                            this.redraw(format, vertexCount, drawMode, byteBuffer);
                        }
                        GlStateManager.func_179132_a((boolean)true);
                        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        this.redraw(format, vertexCount, drawMode, byteBuffer);
                        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    } else if (firstPass) {
                        tessellator.func_78381_a();
                    } else {
                        this.redraw(format, vertexCount, drawMode, byteBuffer);
                    }
                    this.postSetup(pass, localBoundTex);
                    firstPass = false;
                }
            }

            private void redraw(VertexFormat vertexformat, int vertexCount, int drawMode, ByteBuffer byteBuffer) {
                byteBuffer.position(0);
                if (vertexCount > 0) {
                    int i = vertexformat.func_177338_f();
                    List list = vertexformat.func_177343_g();
                    for (int j = 0; j < list.size(); ++j) {
                        VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                        byteBuffer.position(vertexformat.func_181720_d(j));
                        vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, byteBuffer);
                    }
                    GlStateManager.func_187439_f((int)drawMode, (int)0, (int)vertexCount);
                    int j1 = list.size();
                    for (int i1 = 0; i1 < j1; ++i1) {
                        VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                        vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, byteBuffer);
                    }
                }
            }

            @Override
            public int maxParticles() {
                return ParticleBatchTypeBuilder.this.mainPass.maxParticles;
            }

            @Override
            public int batchSize() {
                return ParticleBatchTypeBuilder.this.mainPass.batchSize;
            }
        };
        return type;
    }

    public static class Pass {
        private final ParticleBatchTypeBuilder builder;
        private int maxParticles = 8192;
        private int batchSize = 8192;
        private boolean setFog = true;
        private boolean fog = true;
        private boolean setCull = true;
        private boolean cull = true;
        private boolean setDepthTest = true;
        private boolean depthTest = true;
        private boolean setDepthMask = true;
        private boolean depthMask = true;
        private boolean setColorMask = true;
        private boolean colorMaskR = true;
        private boolean colorMaskG = true;
        private boolean colorMaskB = true;
        private boolean colormaskA = true;
        private boolean depthMaskPass = false;
        private boolean setLit = true;
        private boolean lit = false;
        private VertexFormat format = DefaultVertexFormats.field_181704_d;
        private int glPrimitive = 7;
        private boolean setBlend = true;
        private boolean blend = true;
        private GlStateManager.SourceFactor glBlendSrc = GlStateManager.SourceFactor.SRC_ALPHA;
        private GlStateManager.DestFactor glBlendDst = GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA;
        private boolean setTexture = true;
        private Supplier<ResourceLocation> texture = () -> TextureMap.field_110575_b;
        private boolean setBlur = true;
        private boolean blur = false;
        private boolean setMipmap = true;
        private boolean mipmap = false;
        private Runnable preRenderPassCallback = null;
        private Runnable postRenderPassCallback = null;

        private Pass(ParticleBatchTypeBuilder builder) {
            this.builder = builder;
        }

        public Pass preRenderPassCallback(@Nullable Runnable callback) {
            this.preRenderPassCallback = callback;
            return this;
        }

        public Pass postRenderPassCallback(@Nullable Runnable callback) {
            this.postRenderPassCallback = callback;
            return this;
        }

        public Pass maxParticles(int maxParticles) {
            this.maxParticles = maxParticles;
            return this;
        }

        public Pass batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Pass setCull(boolean set) {
            this.setCull = set;
            return this;
        }

        public Pass cull(boolean cull) {
            this.cull = cull;
            return this;
        }

        public Pass setDepthTest(boolean set) {
            this.setDepthTest = set;
            return this;
        }

        public Pass depthTest(boolean depth) {
            this.depthTest = depth;
            return this;
        }

        public Pass setDepthMask(boolean set) {
            this.setDepthMask = set;
            return this;
        }

        public Pass depthMask(boolean mask) {
            this.depthMask = mask;
            return this;
        }

        public Pass setColorMask(boolean set) {
            this.setColorMask = set;
            return this;
        }

        public Pass colorMask(boolean r, boolean g, boolean b, boolean a) {
            this.colorMaskR = r;
            this.colorMaskG = b;
            this.colorMaskB = b;
            this.colormaskA = a;
            return this;
        }

        public Pass depthMaskPass(boolean depthMaskPass) {
            this.depthMaskPass = depthMaskPass;
            return this;
        }

        public Pass setLit(boolean set) {
            this.setLit = set;
            return this;
        }

        public Pass lit(boolean lit) {
            this.lit = lit;
            return this;
        }

        public Pass setFog(boolean set) {
            this.setFog = set;
            return this;
        }

        public Pass fog(boolean fog) {
            this.fog = fog;
            return this;
        }

        public Pass format(VertexFormat format) {
            this.format = format;
            return this;
        }

        public Pass primitive(int glPrimitive) {
            this.glPrimitive = glPrimitive;
            return this;
        }

        public Pass setBlend(boolean set) {
            this.setBlend = set;
            return this;
        }

        public Pass blend(boolean blend) {
            this.blend = blend;
            return this;
        }

        public Pass blend(GlStateManager.SourceFactor src, GlStateManager.DestFactor dst) {
            this.glBlendSrc = src;
            this.glBlendDst = dst;
            return this;
        }

        public Pass setTexture(boolean set) {
            this.setTexture = set;
            return this;
        }

        public Pass texture(@Nullable ResourceLocation texture) {
            this.texture = texture != null ? () -> texture : null;
            return this;
        }

        public Pass texture(@Nullable Supplier<ResourceLocation> texture) {
            this.texture = texture;
            return this;
        }

        public Pass setBlur(boolean set) {
            this.setBlur = set;
            return this;
        }

        public Pass blur(boolean blur) {
            this.blur = blur;
            return this;
        }

        public Pass setMipmap(boolean set) {
            this.setMipmap = set;
            return this;
        }

        public Pass mipmap(boolean mipmap) {
            this.mipmap = mipmap;
            return this;
        }

        public ParticleBatchTypeBuilder end() {
            return this.builder;
        }
    }
}

