/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import java.util.function.Supplier;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleSwarm;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleEmissiveSwarm
extends ParticleSwarm {
    private TextureAnimation emissiveAnimation = new TextureAnimation();

    protected ParticleEmissiveSwarm(World world, double x, double y, double z, double mx, double my, double mz, EnumFacing face, float scale, int maxAge, Vec3d start, Supplier<Vec3d> end) {
        super(world, x, y, z, mx, my, mz, face, scale, maxAge, start, end);
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null && frames != null) {
            if (frames.length % 2 != 0) {
                throw new IllegalStateException("Emissive particle requires a multiple of two number of sprites");
            }
            int variant = this.field_187136_p.nextInt(frames.length / 2);
            this.animation.setFrames(frames[variant * 2]);
            this.emissiveAnimation.setFrames(frames[variant * 2 + 1]);
            ResourceLocation location = frames[variant * 2][0].getLocation();
            if (location instanceof ParticleSwarm.ResourceLocationWithScale) {
                this.field_70544_f *= ((ParticleSwarm.ResourceLocationWithScale)location).scale;
            }
            if (this.field_70547_e < 0) {
                this.field_70547_e = this.animation.getTotalDuration() - 1;
            }
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[variant * 2][0].getSprite());
            }
        }
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.emissiveAnimation.update();
    }

    @Override
    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        this.func_187117_a(this.animation.getCurrentSprite());
        super.func_180434_a(buff, entityIn, partialTicks, rx, rz, ryz, rxy, rxz);
        int prevLightmapX = this.lightmapX;
        int prevLightmapY = this.lightmapY;
        this.lightmapX = 240;
        this.lightmapY = 240;
        this.func_187117_a(this.emissiveAnimation.getCurrentSprite());
        super.func_180434_a(buff, entityIn, partialTicks, rx, rz, ryz, rxy, rxz);
        this.lightmapX = prevLightmapX;
        this.lightmapY = prevLightmapY;
    }

    public int func_189214_a(float partialTick) {
        if (this.field_187119_C == this.emissiveAnimation.getCurrentSprite()) {
            return 0xF000F0;
        }
        return super.func_189214_a(partialTick);
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleEmissiveSwarm> {
        public Factory() {
            super(ParticleEmissiveSwarm.class, ParticleTextureStitcher.create(ParticleEmissiveSwarm.class, new ParticleSwarm.ResourceLocationWithScale("thebetweenlands:particle/swarm_4", 2.0f), new ParticleSwarm.ResourceLocationWithScale("thebetweenlands:particle/swarm_4_emissive", 2.0f)).setSplitAnimations(true));
        }

        @Override
        public ParticleEmissiveSwarm createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEmissiveSwarm(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getObject(EnumFacing.class, 0), args.scale, args.data.getInt(1), args.data.getObject(Vec3d.class, 2), args.data.getObject(Supplier.class, 3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(EnumFacing.UP, 40, Vec3d.field_186680_a, () -> Vec3d.field_186680_a);
        }
    }
}

