/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelDecayPitChain;
import thebetweenlands.common.block.structure.BlockDecayPitGroundChain;
import thebetweenlands.common.tile.TileEntityDecayPitGroundChain;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderDecayPitGroundChain
extends TileEntitySpecialRenderer<TileEntityDecayPitGroundChain> {
    public static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/decay_pit_chain.png");
    private final ModelDecayPitChain CHAIN_MODEL = new ModelDecayPitChain();

    public void render(TileEntityDecayPitGroundChain tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        float scroll = (float)tile.animationTicksChainPrev * 0.0078125f + ((float)tile.animationTicksChain * 0.0078125f - (float)tile.animationTicksChainPrev * 0.0078125f) * partialTicks;
        EnumFacing facing = StatePropertyHelper.getStatePropertySafely(tile, BlockDecayPitGroundChain.class, BlockDecayPitGroundChain.field_185512_D, EnumFacing.NORTH);
        int easyFacingIndex = 0;
        switch (facing) {
            case UP: {
                easyFacingIndex = 2;
                break;
            }
            case DOWN: {
                easyFacingIndex = 2;
                break;
            }
            case NORTH: {
                easyFacingIndex = 2;
                break;
            }
            case SOUTH: {
                easyFacingIndex = 0;
                break;
            }
            case WEST: {
                easyFacingIndex = 1;
                break;
            }
            case EAST: {
                easyFacingIndex = 3;
            }
        }
        this.func_147499_a(CHAIN_TEXTURE);
        if (tile.isMoving()) {
            GlStateManager.func_179094_E();
            if (tile.isRaising()) {
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5 + (double)scroll), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)easyFacingIndex * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.CHAIN_MODEL.render(0.0625f);
            }
            if (!tile.isRaising()) {
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)tile.getLength() + 1.5 - (double)scroll), (double)(z + 0.5));
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)easyFacingIndex * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                this.CHAIN_MODEL.render(0.0625f);
            }
            GlStateManager.func_179121_F();
        }
        for (int len = 1; len <= tile.getLength(); ++len) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)len + 0.5 + (double)(tile.isRaising() ? scroll : -scroll)), (double)(z + 0.5));
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)easyFacingIndex * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.CHAIN_MODEL.render(0.0625f);
            GlStateManager.func_179121_F();
        }
    }

    public boolean isGlobalRenderer(TileEntityDecayPitGroundChain tile) {
        return true;
    }
}

