/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common;

import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thebetweenlands.common.BLDataFixers;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.block.plant.BlockWeedwoodBush;
import thebetweenlands.common.capability.base.EntityCapabilityHandler;
import thebetweenlands.common.capability.base.ItemCapabilityHandler;
import thebetweenlands.common.capability.blessing.BlessingEntityCapability;
import thebetweenlands.common.capability.collision.RingOfDispersionEntityCapability;
import thebetweenlands.common.capability.lastkilled.LastKilledCapability;
import thebetweenlands.common.capability.playermounts.PlayerMountsEntityCapability;
import thebetweenlands.common.capability.swarmed.SwarmedCapability;
import thebetweenlands.common.command.CommandAspectDiscovery;
import thebetweenlands.common.command.CommandBLEvent;
import thebetweenlands.common.command.CommandDecay;
import thebetweenlands.common.command.CommandReloadRecipes;
import thebetweenlands.common.command.CommandResetAspects;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.ConfigHelper;
import thebetweenlands.common.entity.EntityVolarkite;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.entity.mobs.EntitySludgeMenace;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.common.handler.AdvancementHandler;
import thebetweenlands.common.handler.AnvilEventHandler;
import thebetweenlands.common.handler.ArmorHandler;
import thebetweenlands.common.handler.AspectSyncHandler;
import thebetweenlands.common.handler.AttackDamageHandler;
import thebetweenlands.common.handler.BlockBreakHandler;
import thebetweenlands.common.handler.BossHandler;
import thebetweenlands.common.handler.CustomEntityCollisionsHandler;
import thebetweenlands.common.handler.ElixirCommonHandler;
import thebetweenlands.common.handler.EntitySpawnHandler;
import thebetweenlands.common.handler.EntityUnmountHandler;
import thebetweenlands.common.handler.EnvironmentEventHandler;
import thebetweenlands.common.handler.EnvironmentEventOverridesHandler;
import thebetweenlands.common.handler.FoodSicknessHandler;
import thebetweenlands.common.handler.FuelHandler;
import thebetweenlands.common.handler.ItemEquipmentHandler;
import thebetweenlands.common.handler.LocationHandler;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.handler.PlayerDecayHandler;
import thebetweenlands.common.handler.PlayerJoinWorldHandler;
import thebetweenlands.common.handler.PlayerPortalHandler;
import thebetweenlands.common.handler.PlayerRespawnHandler;
import thebetweenlands.common.handler.PuppetHandler;
import thebetweenlands.common.handler.WorldEventHandler;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.herblore.elixir.PotionRootBound;
import thebetweenlands.common.item.armor.ItemAncientArmor;
import thebetweenlands.common.item.equipment.ItemRingOfFlight;
import thebetweenlands.common.item.misc.ItemMagicItemMagnet;
import thebetweenlands.common.item.misc.ItemRingOfGathering;
import thebetweenlands.common.item.shields.ItemDentrothystShield;
import thebetweenlands.common.item.tools.ItemBLShield;
import thebetweenlands.common.item.tools.ItemGreatsword;
import thebetweenlands.common.proxy.CommonProxy;
import thebetweenlands.common.recipe.censer.CenserRecipeCremains;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.GameruleRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.MessageRegistry;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.common.registries.Registries;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntitySimulacrum;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.biome.spawning.WorldMobSpawner;
import thebetweenlands.common.world.gen.feature.structure.WorldGenDruidCircle;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWaystone;
import thebetweenlands.common.world.storage.BetweenlandsChunkStorage;
import thebetweenlands.common.world.storage.OfflinePlayerHandlerImpl;
import thebetweenlands.common.world.storage.WorldStorageImpl;
import thebetweenlands.compat.tmg.TMGEquipmentInventory;
import thebetweenlands.core.TheBetweenlandsPreconditions;

@Mod(modid="thebetweenlands", name="The Betweenlands", version="3.7.2", acceptedMinecraftVersions="[1.12.2]", certificateFingerprint="38067d6878811efb38b6a045521cfd80b9b60b38", dependencies="required-after:forge@[14.23.5.2773,);after:tombmanygraves2api@[1.12-4.1.0,);after:tombmanygraves@[1.12-4.1.0,);after:jei@[4.12.0,)", serverSideOnly=false)
public class TheBetweenlands {
    @Mod.Instance(value="thebetweenlands")
    public static TheBetweenlands instance;
    @SidedProxy(modId="thebetweenlands", clientSide="thebetweenlands.client.proxy.ClientProxy", serverSide="thebetweenlands.common.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Registries REGISTRIES;
    public static DimensionType dimensionType;
    public static SimpleNetworkWrapper networkWrapper;
    public static Logger logger;
    public static boolean isToughAsNailsModInstalled;
    public static final String DIMENSION_NAME = "betweenlands";

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        Logger fpLogger = LogManager.getLogger((String)"Betweenlands Fingerprint Violation");
        fpLogger.warn("Invalid fingerprint for The Betweenlands detected!");
        fpLogger.warn("The Betweenlands jar file was either tampered with or");
        fpLogger.warn("is corrupted. Please remove the file and (re)download");
        fpLogger.warn("the mod from the official CurseForge project at");
        fpLogger.warn("https://www.curseforge.com/minecraft/mc-mods/angry-pixel-the-betweenlands-mod");
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigHelper.init();
        BetweenlandsAPI.init();
        dimensionType = DimensionType.register((String)DIMENSION_NAME, (String)"_betweenlands", (int)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId, WorldProviderBetweenlands.class, (boolean)false);
        DimensionManager.registerDimension((int)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId, (DimensionType)dimensionType);
        REGISTRIES.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("thebetweenlands");
        MessageRegistry.preInit();
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"thebetweenlands.compat.hwyla.HwylaProvider.callbackRegister");
        proxy.registerItemAndBlockRenderers();
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register(BlockRegistry.class);
        MinecraftForge.EVENT_BUS.register(ItemRegistry.class);
        MinecraftForge.EVENT_BUS.register(RecipeRegistry.class);
        MinecraftForge.EVENT_BUS.register(BiomeRegistry.class);
        MinecraftForge.EVENT_BUS.register(SoundRegistry.class);
        MinecraftForge.EVENT_BUS.register(ElixirEffectRegistry.class);
    }

    @Mod.InstanceFactory
    public static TheBetweenlands createInstance() {
        TheBetweenlandsPreconditions.check();
        ConfigHelper.loadExistingConfig();
        return new TheBetweenlands();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        REGISTRIES.init();
        proxy.init();
        this.registerEventHandlers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenDruidCircle(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenWaystone(), (int)0);
        BLDataFixers.register();
        if (Loader.isModLoaded((String)"tombmanygraves2api")) {
            new TMGEquipmentInventory();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        isToughAsNailsModInstalled = Loader.isModLoaded((String)"toughasnails") || Loader.isModLoaded((String)"ToughAsNails");
        ConfigHelper.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBLEvent());
        event.registerServerCommand((ICommand)new CommandResetAspects());
        event.registerServerCommand((ICommand)new CommandDecay());
        event.registerServerCommand((ICommand)new CommandAspectDiscovery());
        GameruleRegistry.INSTANCE.onServerStarting(event);
        event.registerServerCommand((ICommand)new CommandReloadRecipes());
    }

    private void registerEventHandlers() {
        proxy.registerEventHandlers();
        WorldStorageImpl.register();
        MinecraftForge.EVENT_BUS.register(ConfigHelper.class);
        MinecraftForge.EVENT_BUS.register((Object)ItemBLShield.EventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register(WorldEventHandler.class);
        MinecraftForge.EVENT_BUS.register(BetweenlandsChunkStorage.class);
        MinecraftForge.EVENT_BUS.register((Object)new AnvilEventHandler());
        MinecraftForge.EVENT_BUS.register(EnvironmentEventHandler.class);
        MinecraftForge.EVENT_BUS.register(EntityCapabilityHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemCapabilityHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerDecayHandler.class);
        MinecraftForge.EVENT_BUS.register(AspectSyncHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)WorldMobSpawner.INSTANCE);
        MinecraftForge.EVENT_BUS.register(BlockBreakHandler.class);
        MinecraftForge.EVENT_BUS.register(LocationHandler.class);
        MinecraftForge.EVENT_BUS.register(AttackDamageHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemEquipmentHandler.class);
        MinecraftForge.EVENT_BUS.register(EntitySpawnHandler.class);
        MinecraftForge.EVENT_BUS.register(ArmorHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemRingOfFlight.class);
        MinecraftForge.EVENT_BUS.register(PuppetHandler.class);
        MinecraftForge.EVENT_BUS.register(OverworldItemHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerPortalHandler.class);
        MinecraftForge.EVENT_BUS.register(FoodSicknessHandler.class);
        MinecraftForge.EVENT_BUS.register(BlockGenericDugSoil.class);
        MinecraftForge.EVENT_BUS.register((Object)ElixirCommonHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register(BlockWeedwoodBush.class);
        MinecraftForge.EVENT_BUS.register(ItemDentrothystShield.class);
        MinecraftForge.EVENT_BUS.register(EnvironmentEventOverridesHandler.class);
        MinecraftForge.EVENT_BUS.register(AdvancementHandler.class);
        MinecraftForge.EVENT_BUS.register(FuelHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerJoinWorldHandler.class);
        MinecraftForge.EVENT_BUS.register(PlayerRespawnHandler.class);
        MinecraftForge.EVENT_BUS.register(CustomEntityCollisionsHandler.class);
        MinecraftForge.EVENT_BUS.register(PotionRootBound.class);
        MinecraftForge.EVENT_BUS.register(BossHandler.class);
        MinecraftForge.EVENT_BUS.register(ItemMagicItemMagnet.class);
        MinecraftForge.EVENT_BUS.register(EntityWeedwoodRowboat.class);
        MinecraftForge.EVENT_BUS.register(GameruleRegistry.class);
        MinecraftForge.EVENT_BUS.register(RingOfDispersionEntityCapability.class);
        MinecraftForge.EVENT_BUS.register(ItemGreatsword.class);
        MinecraftForge.EVENT_BUS.register(CenserRecipeCremains.class);
        MinecraftForge.EVENT_BUS.register(EntitySludgeMenace.class);
        MinecraftForge.EVENT_BUS.register(OfflinePlayerHandlerImpl.class);
        MinecraftForge.EVENT_BUS.register(ItemRingOfGathering.class);
        MinecraftForge.EVENT_BUS.register(EntityVolarkite.class);
        MinecraftForge.EVENT_BUS.register(BLDataFixers.class);
        MinecraftForge.EVENT_BUS.register(EntityDraeton.class);
        MinecraftForge.EVENT_BUS.register(PlayerMountsEntityCapability.class);
        MinecraftForge.EVENT_BUS.register(EntityChiromawMatriarch.class);
        MinecraftForge.EVENT_BUS.register(ItemAncientArmor.class);
        MinecraftForge.EVENT_BUS.register(EntityUnmountHandler.class);
        MinecraftForge.EVENT_BUS.register(LastKilledCapability.class);
        MinecraftForge.EVENT_BUS.register(TileEntitySimulacrum.class);
        MinecraftForge.EVENT_BUS.register(BlessingEntityCapability.class);
        MinecraftForge.EVENT_BUS.register(SwarmedCapability.class);
    }

    static {
        REGISTRIES = new Registries();
        isToughAsNailsModInstalled = false;
    }
}

