/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityGeckoCage;

public class BlockGeckoCage
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockGeckoCage() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)rotation).func_176734_d());
        worldIn.func_180501_a(pos, state, 3);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityGeckoCage tile;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityGeckoCage && (tile = (TileEntityGeckoCage)te).hasGecko()) {
            EntityGecko gecko = new EntityGecko(world);
            gecko.func_70606_j(tile.getGeckoUsages());
            gecko.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
            if (tile.getGeckoName() != null && !tile.getGeckoName().isEmpty()) {
                gecko.func_96094_a(tile.getGeckoName());
            }
            world.func_72838_d((Entity)gecko);
            gecko.func_70642_aH();
            if (player instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.GECKO_TRIGGER.trigger((EntityPlayerMP)player, false, true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHeartParticles(World world, BlockPos pos) {
        for (int i = 0; i < 7; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_175688_a(EnumParticleTypes.HEART, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177956_o() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), d0, d1, d2, new int[0]);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItemStack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGeckoCage) {
            TileEntityGeckoCage tile = (TileEntityGeckoCage)te;
            if (player.func_70093_af()) {
                return false;
            }
            if (!heldItemStack.func_190926_b()) {
                Item heldItem = heldItemStack.func_77973_b();
                if (ItemRegistry.CRITTER.isCapturedEntity(heldItemStack, EntityGecko.class)) {
                    if (!tile.hasGecko()) {
                        Entity gecko;
                        if (!world.field_72995_K && (gecko = ItemRegistry.CRITTER.createCapturedEntity(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), heldItemStack)) instanceof EntityGecko) {
                            tile.addGecko((int)((EntityGecko)gecko).func_110143_aJ(), gecko.func_145818_k_() ? gecko.func_95999_t() : null);
                            if (!player.field_71075_bZ.field_75098_d) {
                                heldItemStack.func_190918_g(1);
                            }
                        }
                        return true;
                    }
                    return false;
                }
                if (heldItem == ItemRegistry.SAP_SPIT && tile.hasGecko() && tile.getGeckoUsages() < 12) {
                    if (!world.field_72995_K) {
                        tile.setGeckoUsages(12);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItemStack.func_190918_g(1);
                        }
                    } else {
                        this.spawnHeartParticles(world, pos);
                    }
                    return true;
                }
                if (tile.getAspectType() == null) {
                    if (tile.hasGecko()) {
                        if (DiscoveryContainer.hasDiscoveryProvider(player)) {
                            if (!world.field_72995_K) {
                                AspectItem aspectItem;
                                AspectManager manager = AspectManager.get(world);
                                List<Aspect> aspects = manager.getStaticAspects(aspectItem = AspectManager.getAspectItem(heldItemStack));
                                if (aspects.size() > 0) {
                                    DiscoveryContainer<?> mergedKnowledge = DiscoveryContainer.getMergedDiscoveryContainer(player);
                                    DiscoveryContainer.AspectDiscovery discovery = mergedKnowledge.discover(manager, aspectItem);
                                    switch (discovery.result) {
                                        case NEW: 
                                        case LAST: {
                                            DiscoveryContainer.addDiscoveryToContainers(player, aspectItem, discovery.discovered.type);
                                            tile.setAspectType(discovery.discovered.type, 600);
                                            if (player instanceof EntityPlayerMP) {
                                                AdvancementCriterionRegistry.GECKO_TRIGGER.trigger((EntityPlayerMP)player, true, false);
                                                if (discovery.result == DiscoveryContainer.AspectDiscovery.EnumDiscoveryResult.LAST && DiscoveryContainer.getMergedDiscoveryContainer(player).haveDiscoveredAll(manager)) {
                                                    AdvancementCriterionRegistry.HERBLORE_FIND_ALL.trigger((EntityPlayerMP)player);
                                                }
                                            }
                                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery." + discovery.discovered.type.getName().toLowerCase(), new Object[0]), false);
                                            if (discovery.result == DiscoveryContainer.AspectDiscovery.EnumDiscoveryResult.LAST) {
                                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.last", new Object[0]), true);
                                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.last", new Object[0]), false);
                                            } else {
                                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.more", new Object[0]), true);
                                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.more", new Object[0]), false);
                                            }
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                heldItemStack.func_190918_g(1);
                                            }
                                            return true;
                                        }
                                        case END: {
                                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.end", new Object[0]), true);
                                            return false;
                                        }
                                    }
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.none", new Object[0]), true);
                                    return false;
                                }
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.none", new Object[0]), true);
                                return true;
                            }
                            return false;
                        }
                        if (!world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.book.none", new Object[0]), true);
                        }
                        return false;
                    }
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.gecko.none", new Object[0]), true);
                    }
                    return false;
                }
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aspect.discovery.gecko.recovering", new Object[0]), true);
                }
                return false;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGeckoCage();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

