/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.farming;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.block.IAspectFogBlock;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAspectrusCrop;
import thebetweenlands.common.tile.TileEntityDugSoil;

public class BlockAspectrusCrop
extends BlockGenericCrop
implements BlockRegistry.ICustomItemBlock,
ITileEntityProvider {
    protected static final int MAX_HEIGHT = 3;

    public BlockAspectrusCrop() {
        this.func_149647_a(null);
        this.setMaxHeight(3);
    }

    public void setAspect(IBlockAccess world, BlockPos pos, @Nullable Aspect aspect) {
        TileEntityAspectrusCrop tile = this.getTile(world, pos);
        if (tile != null) {
            tile.setAspect(aspect);
        }
    }

    @Nullable
    public Aspect getAspect(IBlockAccess world, BlockPos pos) {
        TileEntityAspectrusCrop tile = this.getTile(world, pos);
        if (tile != null) {
            return tile.getAspect();
        }
        return null;
    }

    @Nullable
    public TileEntityAspectrusCrop getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAspectrusCrop) {
            return (TileEntityAspectrusCrop)tile;
        }
        return null;
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.updateAspectSource(worldIn, pos, state);
        super.func_180650_b(worldIn, pos, state, rand);
        Aspect aspect = this.getAspect((IBlockAccess)worldIn, pos);
        if (aspect != null && worldIn.field_73012_v.nextInt(3) == 0) {
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
            checkPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
            for (int i = 0; i < 3; ++i) {
                IBlockState offsetState = worldIn.func_180495_p((BlockPos)checkPos);
                if (offsetState.func_177230_c() instanceof BlockGenericDugSoil) {
                    TileEntityDugSoil te;
                    if (((BlockGenericDugSoil)offsetState.func_177230_c()).isPurified(worldIn, (BlockPos)checkPos, offsetState) || (te = BlockGenericDugSoil.getTile(worldIn, (BlockPos)checkPos)) == null || te.isFullyDecayed()) break;
                    te.setDecay(te.getDecay() + 5);
                    break;
                }
                checkPos.func_181079_c(checkPos.func_177958_n(), checkPos.func_177956_o() - 1, checkPos.func_177952_p());
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BlockFence.field_185671_f;
    }

    @Override
    protected boolean removePlant(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        return world.func_180501_a(pos, BlockRegistry.RUBBER_TREE_PLANK_FENCE.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    @Override
    public int getCropDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 1 + rand.nextInt(3 + fortune);
        }
        return 0;
    }

    @Override
    public int getSeedDrops(IBlockAccess world, BlockPos pos, Random rand, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 15) {
            return 1 + (rand.nextInt(8) == 0 ? 1 : 0);
        }
        return 1;
    }

    @Override
    protected boolean canGrow(World world, BlockPos pos, IBlockState state) {
        TileEntityAspectrusCrop tile = this.getTile((IBlockAccess)world, pos);
        return tile.getAspect() != null && tile.hasSource();
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    protected boolean canGrowUp(World world, BlockPos pos, IBlockState state, int height) {
        BlockPos posUp;
        IBlockState upState;
        if ((this.maxHeight == -1 || height < this.maxHeight) && (upState = world.func_180495_p(posUp = pos.func_177984_a())).func_177230_c() == BlockRegistry.RUBBER_TREE_PLANK_FENCE) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                if (!BlockRegistry.RUBBER_TREE_PLANK_FENCE.canBeConnectedTo((IBlockAccess)world, posUp, dir)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void growUp(World world, BlockPos pos) {
        BlockPos posUp;
        TileEntityAspectrusCrop tile;
        super.growUp(world, pos);
        Aspect aspect = this.getAspect((IBlockAccess)world, pos);
        if (aspect != null && (tile = this.getTile((IBlockAccess)world, posUp = pos.func_177984_a())) != null) {
            tile.setAspect(aspect);
            tile.setHasSource(true);
        }
    }

    @Override
    protected PropertyInteger createStageProperty() {
        return PropertyInteger.func_177719_a((String)"stage", (int)0, (int)15);
    }

    @Override
    public ItemStack getSeedDrop(IBlockAccess world, BlockPos pos, Random rand) {
        return new ItemStack(ItemRegistry.ASPECTRUS_SEEDS);
    }

    @Override
    public ItemStack getCropDrop(IBlockAccess world, BlockPos pos, Random rand) {
        if (!this.isDecayed(world, pos)) {
            ItemStack stack = new ItemStack(ItemRegistry.ASPECTRUS_FRUIT);
            Aspect aspect = this.getAspect(world, pos);
            if (aspect != null) {
                ItemAspectContainer.fromItem(stack).set(aspect.type, aspect.amount);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ItemRegistry.ASPECTRUS_SEEDS);
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAspectrusCrop();
    }

    protected void updateAspectSource(World world, BlockPos pos, IBlockState state) {
        TileEntityAspectrusCrop tile;
        boolean hasSource = false;
        Aspect aspect = this.getAspect((IBlockAccess)world, pos);
        for (BlockPos.MutableBlockPos checkPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-6, -this.maxHeight, -6), (BlockPos)pos.func_177982_a(6, 0, 6))) {
            IAspectType aspectType;
            IBlockState offsetState;
            Block offsetBlock;
            if (!world.func_175667_e((BlockPos)checkPos) || !((offsetBlock = (offsetState = world.func_180495_p((BlockPos)checkPos)).func_177230_c()) instanceof IAspectFogBlock) || (aspectType = ((IAspectFogBlock)offsetBlock).getAspectFogType((IBlockAccess)world, (BlockPos)checkPos, offsetState)) == null) continue;
            if (aspect != null) {
                if (aspect.type != aspectType) continue;
                hasSource = true;
                break;
            }
            this.setAspect((IBlockAccess)world, pos, new Aspect(aspectType, 250));
            hasSource = true;
            break;
        }
        if ((tile = this.getTile((IBlockAccess)world, pos)) != null) {
            tile.setHasSource(hasSource);
        }
    }
}

