/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.world.event.EventWinter;

public class BlockBauble
extends Block
implements ITintedBlock,
IShearable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyInteger COLOR = PropertyInteger.func_177719_a((String)"color", (int)0, (int)7);
    public static final PropertyBool DIAGONAL = PropertyBool.func_177716_a((String)"diagonal");

    public BlockBauble() {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149647_a(null);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DIAGONAL, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)COLOR);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR, DIAGONAL});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            int rotation = MathHelper.func_76128_c((double)((double)((placer.field_70177_z + 180.0f) * 8.0f / 360.0f) + 0.5)) & 7;
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)DIAGONAL, (Comparable)Boolean.valueOf(rotation % 2 == 1)).func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(worldIn.field_73012_v.nextInt(8))), 11);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) != BlockFaceShape.UNDEFINED);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) && worldIn.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) == BlockFaceShape.UNDEFINED) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        switch ((Integer)state.func_177229_b((IProperty)COLOR)) {
            default: {
                return -65536;
            }
            case 1: {
                return -16711936;
            }
            case 2: {
                return -16776961;
            }
            case 3: {
                return -256;
            }
            case 4: {
                return -16711681;
            }
            case 5: {
                return -65281;
            }
            case 6: {
                return -40756;
            }
            case 7: 
        }
        return -13566038;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (!worldIn.field_72995_K) {
            EntityXPOrb orb = new EntityXPOrb(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 1);
            worldIn.func_72838_d((Entity)orb);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!EventWinter.isFroooosty(worldIn)) {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }
}

