/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.plant.BlockHangingPlant;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class BlockCaveMoss
extends BlockHangingPlant {
    public BlockCaveMoss() {
        super(Material.field_151585_k);
    }

    @Override
    protected boolean isValidBlock(World world, BlockPos pos, IBlockState blockState) {
        return SurfaceType.UNDERGROUND.matches(blockState) || blockState.func_177230_c() == this;
    }

    @Override
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(40) == 0) {
            float dripRange = 0.5f;
            float px = rand.nextFloat() - 0.5f;
            float py = rand.nextFloat();
            float pz = rand.nextFloat() - 0.5f;
            float u = Math.max(Math.abs(px), Math.abs(pz));
            px = px / u * dripRange + 0.5f;
            pz = pz / u * dripRange + 0.5f;
            BLParticles.CAVE_WATER_DRIP.spawn(worldIn, (float)pos.func_177958_n() + px, (float)pos.func_177956_o() + py, (float)pos.func_177952_p() + pz);
        }
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1));
    }
}

