/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.plant.BlockStackablePlantUnderwater;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockMarshMarigoldStalk
extends BlockStackablePlantUnderwater {
    public BlockMarshMarigoldStalk() {
        this.harvestAll = true;
        this.setMaxHeight(1);
        this.func_149647_a(null);
    }

    @Override
    protected boolean isSamePlant(IBlockState blockState) {
        return super.isSamePlant(blockState) || blockState.func_177230_c() == BlockRegistry.MARSH_MARIGOLD_FLOWER;
    }

    @Override
    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        return super.canBlockStay(worldIn, pos, state) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == BlockRegistry.MARSH_MARIGOLD_FLOWER;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, BlockRegistry.MARSH_MARIGOLD_STALK.func_176223_P());
        worldIn.func_175656_a(pos.func_177984_a(), BlockRegistry.MARSH_MARIGOLD_FLOWER.func_176223_P());
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a()) && super.func_176196_c(worldIn, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{IS_TOP, IS_BOTTOM});
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)BlockRegistry.MARSH_MARIGOLD_FLOWER)));
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return super.canSpreadTo(world, pos, state, targetPos, rand) && world.func_175623_d(targetPos.func_177984_a());
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        super.spreadTo(world, pos, state, targetPos, rand);
        world.func_175656_a(targetPos.func_177984_a(), BlockRegistry.MARSH_MARIGOLD_FLOWER.func_176223_P());
    }

    @Override
    public void decayPlant(World world, BlockPos pos, IBlockState state, Random rand) {
        super.decayPlant(world, pos, state, rand);
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == BlockRegistry.MARSH_MARIGOLD_FLOWER) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BlockRegistry.MARSH_MARIGOLD_FLOWER);
    }
}

