/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.ItemBlockEnum;
import thebetweenlands.common.item.ItemRenamableBlockEnum;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntitySimulacrum;
import thebetweenlands.util.AdvancedStateMap;
import thebetweenlands.util.NBTHelper;

public class BlockSimulacrum
extends BlockContainer
implements BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.15, 0.0, 0.15, 0.85, 1.0, 0.85);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);

    public BlockSimulacrum(Material material, SoundType soundType) {
        super(material);
        this.func_149711_c(10.0f);
        this.func_149752_b(10000.0f);
        this.func_149672_a(soundType);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata((EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5 + 2.0)) & 3;
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)rotation));
        state = state.func_177226_a(VARIANT, (Comparable)((Object)Variant.byMetadata(stack.func_77952_i())));
        worldIn.func_180501_a(pos, state, 3);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntitySimulacrum) {
            ((TileEntitySimulacrum)tile).setEffect(TileEntitySimulacrum.Effect.byId(NBTHelper.getStackNBTSafe(stack).func_74762_e("simulacrumEffectId")));
            ((TileEntitySimulacrum)tile).setActive(true);
            if (stack.func_82837_s()) {
                ((TileEntitySimulacrum)tile).setCustomName(stack.func_82833_r());
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            this.dropAt(worldIn, pos, state);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySimulacrum();
    }

    @Override
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{VARIANT}).withPropertySuffix(VARIANT, v -> ((Variant)v).name);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, Variant.ONE.getMetadata(EnumFacing.NORTH)));
        list.add((Object)new ItemStack((Block)this, 1, Variant.TWO.getMetadata(EnumFacing.NORTH)));
        list.add((Object)new ItemStack((Block)this, 1, Variant.THREE.getMetadata(EnumFacing.NORTH)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack = new ItemStack((Block)this, 1, ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata(EnumFacing.NORTH));
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntitySimulacrum) {
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            nbt.func_74768_a("simulacrumEffectId", ((TileEntitySimulacrum)tile).getEffect().id);
        }
        return stack;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && !player.func_184812_l_() && worldIn.func_82736_K().func_82766_b("doTileDrops")) {
            this.dropAt(worldIn, pos, state);
        }
    }

    private void dropAt(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack = new ItemStack((Block)this, 1, ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata(EnumFacing.NORTH));
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntitySimulacrum) {
            if (!((TileEntitySimulacrum)tile).isActive()) {
                worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (SoundEvent)SoundRegistry.SIMULACRUM_BREAK, SoundCategory.BLOCKS, 1.0f, 0.95f + worldIn.field_73012_v.nextFloat() * 0.1f);
            }
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            nbt.func_74768_a("simulacrumEffectId", ((TileEntitySimulacrum)tile).getEffect().id);
            String customName = ((TileEntitySimulacrum)tile).getCustomName();
            if (customName.length() > 0) {
                stack.func_151001_c(customName);
            }
        }
        InventoryHelper.func_180173_a((World)worldIn, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)stack);
    }

    @Override
    public int getSubtypeNumber() {
        return Variant.values().length * 4;
    }

    @Override
    public String getSubtypeName(int meta) {
        return "%s_" + Variant.byMetadata(meta).func_176610_l();
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemRenamableBlockEnum<Variant> item = ItemRenamableBlockEnum.create((Block)this, Variant.class);
        item.func_77625_d(1);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.bl.simulacrum.effect", (Object[])new Object[]{I18n.func_135052_a((String)("tooltip.bl.simulacrum.effect." + TileEntitySimulacrum.Effect.byId((int)NBTHelper.getStackNBTSafe((ItemStack)stack).func_74762_e((String)"simulacrumEffectId")).name), (Object[])new Object[0])}));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && playerIn.func_184812_l_() && playerIn.func_70093_af()) {
            TileEntity tile;
            if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntitySimulacrum) {
                TileEntitySimulacrum simulacrum = (TileEntitySimulacrum)tile;
                TileEntitySimulacrum.Effect nextEffect = TileEntitySimulacrum.Effect.values()[(simulacrum.getEffect().ordinal() + 1) % TileEntitySimulacrum.Effect.values().length];
                simulacrum.setEffect(nextEffect);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.simulacrum.changed_effect", new Object[]{new TextComponentTranslation("tooltip.bl.simulacrum.effect." + nextEffect.name, new Object[0])}), true);
            }
            playerIn.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public static enum Variant implements IStringSerializable,
    ItemBlockEnum.IGenericMetaSelector
    {
        ONE("1"),
        TWO("2"),
        THREE("3");

        private final String name;

        private Variant(String name) {
            this.name = name.toLowerCase(Locale.ENGLISH);
        }

        public int getMetadata(EnumFacing facing) {
            return facing.func_176736_b() | this.ordinal() << 2;
        }

        public String toString() {
            return this.name;
        }

        public static Variant byMetadata(int metadata) {
            if ((metadata >>= 2) < 0 || metadata >= Variant.values().length) {
                metadata = 0;
            }
            return Variant.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public boolean isMetadataMatching(int meta) {
            return Variant.byMetadata(meta) == this;
        }
    }
}

