/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.item.ItemBlockSlab;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockSlabBetweenlands
extends BasicBlock
implements BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumBlockHalfBL> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalfBL.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockSlabBetweenlands(Block block) {
        super(block.func_149688_o(block.func_176223_P()));
        this.func_149672_a(block.func_185467_w());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalfBL.BOTTOM)));
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.field_149783_u = true;
    }

    @Override
    @Nonnull
    public ItemBlock getItemBlock() {
        return new ItemBlockSlab(this);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.BOTTOM) && face == EnumFacing.DOWN || ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.TOP) && face == EnumFacing.UP || ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL) ? state : (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a(HALF, (Comparable)((Object)EnumBlockHalfBL.BOTTOM)) : state.func_177226_a(HALF, (Comparable)((Object)EnumBlockHalfBL.TOP)));
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL) ? 2 : 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumBlockHalfBL half = (EnumBlockHalfBL)((Object)state.func_177229_b(HALF));
        switch (half) {
            case TOP: {
                return AABB_TOP_HALF;
            }
            case BOTTOM: {
                return AABB_BOTTOM_HALF;
            }
        }
        return field_185505_j;
    }

    public boolean func_185481_k(IBlockState state) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.FULL) || ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.TOP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (state.func_177229_b(HALF) == EnumBlockHalfBL.FULL) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && state.func_177229_b(HALF) == EnumBlockHalfBL.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && state.func_177229_b(HALF) == EnumBlockHalfBL.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.TOP) && facing.equals((Object)EnumFacing.DOWN) || ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).equals((Object)EnumBlockHalfBL.BOTTOM) && facing.equals((Object)EnumFacing.UP)) && heldItem.func_77973_b() == Item.func_150898_a((Block)this)) {
            worldIn.func_175656_a(pos, state.func_177226_a(HALF, (Comparable)((Object)EnumBlockHalfBL.FULL)));
            if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
            }
            SoundType soundtype = this.getSoundType(state, worldIn, pos, (Entity)playerIn);
            worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalfBL.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockHalfBL)((Object)state.func_177229_b(HALF))).ordinal();
    }

    public static enum EnumBlockHalfBL implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom"),
        FULL("full");

        private final String name;

        private EnumBlockHalfBL(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumBlockHalfBL byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumBlockHalfBL.values().length) {
                metadata = 0;
            }
            return EnumBlockHalfBL.values()[metadata];
        }
    }
}

