/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.recruitment;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.IPuppeteerCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.api.capability.ProtectionShield;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EntityPuppeteerCapability
extends EntityCapability<EntityPuppeteerCapability, IPuppeteerCapability, EntityPlayer>
implements IPuppeteerCapability,
ISerializableCapability {
    private int activatingTicks;
    private int activatingEntityId = -1;
    private Entity activatingEntity;
    private final ProtectionShield shield = new ProtectionShield(){

        @Override
        public void setActive(int index, boolean active) {
            super.setActive(index, active);
            EntityPuppeteerCapability.this.markDirty();
        }

        @Override
        public void unpackActiveData(int packedData) {
            super.unpackActiveData(packedData);
            EntityPuppeteerCapability.this.markDirty();
        }
    };
    private int shieldRotationTicks = 0;
    private int prevShieldRotationTicks = 0;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "puppeteer");
    }

    @Override
    protected Capability<IPuppeteerCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_PUPPETEER;
    }

    @Override
    protected Class<IPuppeteerCapability> getCapabilityClass() {
        return IPuppeteerCapability.class;
    }

    @Override
    protected EntityPuppeteerCapability getDefaultCapabilityImplementation() {
        return new EntityPuppeteerCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public List<Entity> getPuppets() {
        return ((EntityPlayer)this.getEntity()).func_130014_f_().func_175647_a(Entity.class, ((EntityPlayer)this.getEntity()).func_174813_aQ().func_72314_b(24.0, 24.0, 24.0), entity -> {
            IPuppetCapability cap = (IPuppetCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_PUPPET, null);
            return cap != null && cap.getPuppeteer() == this.getEntity();
        });
    }

    @Override
    public void setActivatingEntity(Entity entity) {
        this.activatingEntityId = entity == null ? -1 : entity.func_145782_y();
        this.activatingEntity = entity;
        this.markDirty();
    }

    @Override
    public Entity getActivatingEntity() {
        if (this.activatingEntityId < 0) {
            this.activatingEntity = null;
        } else if (this.activatingEntity == null || !this.activatingEntity.func_70089_S() || this.activatingEntity.func_145782_y() != this.activatingEntityId) {
            this.activatingEntity = ((EntityPlayer)this.getEntity()).field_70170_p.func_73045_a(this.activatingEntityId);
        }
        return this.activatingEntity;
    }

    @Override
    public int getActivatingTicks() {
        return this.activatingTicks;
    }

    @Override
    public void setActivatingTicks(int ticks) {
        this.activatingTicks = ticks;
    }

    @Override
    public ProtectionShield getShield() {
        return this.shield;
    }

    @Override
    public void updateShield() {
        for (int i = 0; i <= 19; ++i) {
            if (this.shield.getAnimationTicks(i) == 0 && ((EntityPlayer)this.getEntity()).field_70170_p.field_73012_v.nextInt(50) == 0) {
                this.shield.setAnimationTicks(i, 40);
            }
            if (this.shield.getAnimationTicks(i) <= 0) continue;
            this.shield.setAnimationTicks(i, this.shield.getAnimationTicks(i) - 1);
            if (this.shield.getAnimationTicks(i) != 20) continue;
            this.shield.setAnimationTicks(i, 0);
        }
        this.prevShieldRotationTicks = this.shieldRotationTicks++;
        if (this.shield.hasShield()) {
            this.markDirty();
        }
    }

    @Override
    public int getShieldRotationTicks() {
        return this.shieldRotationTicks;
    }

    @Override
    public int getPrevShieldRotationTicks() {
        return this.prevShieldRotationTicks;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("shieldActiveData", this.shield.packActiveData());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.shield.unpackActiveData(nbt.func_74762_e("shieldActiveData"));
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("activatingEntityId", this.activatingEntityId);
        if (this.shield.hasShield()) {
            nbt.func_74768_a("shieldRotationTicks", this.shieldRotationTicks);
            nbt.func_74768_a("shieldActiveData", this.shield.packActiveData());
        }
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.activatingEntityId = nbt.func_74762_e("activatingEntityId");
        this.shieldRotationTicks = nbt.func_74762_e("shieldRotationTicks");
        this.shield.unpackActiveData(nbt.func_74762_e("shieldActiveData"));
    }

    @Override
    public int getTrackingTime() {
        return 5;
    }
}

