/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.summoning;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.api.capability.ISummoningCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EntitySummoningCapability
extends EntityCapability<EntitySummoningCapability, ISummoningCapability, EntityCreature>
implements ISummoningCapability,
ISerializableCapability {
    private boolean active;
    private int cooldownTicks;
    private int activeTicks;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "summoning");
    }

    @Override
    protected Capability<ISummoningCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_SUMMON;
    }

    @Override
    protected Class<ISummoningCapability> getCapabilityClass() {
        return ISummoningCapability.class;
    }

    @Override
    protected EntitySummoningCapability getDefaultCapabilityImplementation() {
        return new EntitySummoningCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.markDirty();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    @Override
    public void setCooldownTicks(int ticks) {
        this.cooldownTicks = ticks;
    }

    @Override
    public int getActiveTicks() {
        return this.activeTicks;
    }

    @Override
    public void setActiveTicks(int ticks) {
        this.activeTicks = ticks;
        this.markDirty();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("cooldown", this.cooldownTicks);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.cooldownTicks = nbt.func_74762_e("cooldown");
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("active", this.active);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }
}

