/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.swarmed;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.api.capability.ISwarmedCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class SwarmedCapability
extends EntityCapability<SwarmedCapability, ISwarmedCapability, EntityPlayer>
implements ISwarmedCapability,
ISerializableCapability {
    private float strength;
    private int hurtTimer;
    private int damageTimer;
    private float damage;
    private float lastYaw;
    private float lastPitch;
    private float lastYawDelta;
    private float lastPitchDelta;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "swarmed");
    }

    @Override
    protected Capability<ISwarmedCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_SWARMED;
    }

    @Override
    protected Class<ISwarmedCapability> getCapabilityClass() {
        return ISwarmedCapability.class;
    }

    @Override
    protected SwarmedCapability getDefaultCapabilityImplementation() {
        return new SwarmedCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void setSwarmedStrength(float strength) {
        float newStrength = MathHelper.func_76131_a((float)strength, (float)0.0f, (float)1.0f);
        if (newStrength != this.strength) {
            this.strength = newStrength;
            this.markDirty();
        }
    }

    @Override
    public float getSwarmedStrength() {
        return this.strength;
    }

    @Override
    public void setHurtTimer(int timer) {
        if (timer != this.hurtTimer) {
            this.hurtTimer = timer;
            this.markDirty();
        }
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public void setDamageTimer(int timer) {
        this.damageTimer = timer;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public int getHurtTimer() {
        return this.hurtTimer;
    }

    @Override
    public void setLastRotations(float yaw, float pitch) {
        this.lastYaw = yaw;
        this.lastPitch = pitch;
    }

    @Override
    public float getLastYaw() {
        return this.lastYaw;
    }

    @Override
    public float getLastPitch() {
        return this.lastPitch;
    }

    @Override
    public void setLastRotationDeltas(float yaw, float pitch) {
        this.lastYawDelta = yaw;
        this.lastPitchDelta = pitch;
    }

    @Override
    public float getLastYawDelta() {
        return this.lastYawDelta;
    }

    @Override
    public float getLastPitchDelta() {
        return this.lastPitchDelta;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("strength", this.strength);
        nbt.func_74768_a("hurtTimer", this.hurtTimer);
        nbt.func_74768_a("damageTimer", this.damageTimer);
        nbt.func_74776_a("damage", this.damage);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.strength = nbt.func_74760_g("strength");
        this.hurtTimer = nbt.func_74762_e("hurtTimer");
        this.damageTimer = nbt.func_74762_e("damageTimer");
        this.damage = nbt.func_74760_g("damage");
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ISwarmedCapability cap;
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && (cap = (ISwarmedCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_SWARMED, null)) != null) {
            if (cap.getHurtTimer() > 0) {
                cap.setHurtTimer(cap.getHurtTimer() - 1);
            }
            if (cap.getSwarmedStrength() > 0.0f) {
                if (event.player.func_70055_a(Material.field_151586_h) || event.player.func_70027_ad()) {
                    cap.setSwarmedStrength(0.0f);
                } else if (event.player.field_82175_bq || event.player.field_70163_u - event.player.field_70167_r > (double)0.1f || event.player.func_70093_af()) {
                    cap.setSwarmedStrength(cap.getSwarmedStrength() - 0.01f);
                    cap.setHurtTimer(5);
                    event.player.func_70095_a(false);
                }
                float dYaw = MathHelper.func_76142_g((float)(event.player.field_70177_z - cap.getLastYaw()));
                float dPitch = MathHelper.func_76142_g((float)(event.player.field_70125_A - cap.getLastPitch()));
                float ddYaw = MathHelper.func_76142_g((float)(dYaw - cap.getLastYawDelta()));
                float ddPitch = MathHelper.func_76142_g((float)(dPitch - cap.getLastPitchDelta()));
                float ddRot = MathHelper.func_76129_c((float)(ddYaw * ddYaw + ddPitch * ddPitch));
                if (ddRot > 30.0f) {
                    cap.setSwarmedStrength(cap.getSwarmedStrength() - (ddRot - 30.0f) * 0.001f);
                }
                cap.setLastRotations(event.player.field_70177_z, event.player.field_70125_A);
                cap.setLastRotationDeltas(dYaw, dPitch);
            }
            if (cap.getSwarmedStrength() < 0.1f) {
                cap.setSwarmedStrength(cap.getSwarmedStrength() - 5.0E-4f);
            } else {
                cap.setDamageTimer(cap.getDamageTimer() + 1);
                if ((float)cap.getDamageTimer() > 15.0f + (1.0f - cap.getSwarmedStrength()) * 75.0f) {
                    cap.setDamageTimer(0);
                    event.player.func_70097_a(new DamageSource("bl.swarm").func_76348_h(), cap.getDamage());
                }
            }
        }
    }
}

