/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config.properties;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.ConfigProperty;

public class ItemListProperty
extends ConfigProperty {
    private final Supplier<String[]> unparsed;
    private Map<String, IntOpenHashSet> itemList;

    public ItemListProperty(Supplier<String[]> unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    protected void init() {
        String[] unparsed;
        this.itemList = new HashMap<String, IntOpenHashSet>();
        for (String listed : unparsed = this.unparsed.get()) {
            try {
                IntOpenHashSet metaSet;
                int meta;
                String item;
                block9: {
                    String[] data = listed.split(":");
                    item = data[0] + ":" + data[1];
                    if (this.itemList.get(item) != null && this.itemList.get(item).contains(Short.MAX_VALUE)) continue;
                    meta = 0;
                    if (data.length > 2) {
                        if (!"*".equals(data[2])) {
                            try {
                                meta = Integer.parseInt(data[2]);
                                break block9;
                            }
                            catch (NumberFormatException ex) {
                                TheBetweenlands.logger.error("Failed to parse item: " + listed + ". Invalid metadata: " + data[2]);
                                continue;
                            }
                        }
                        meta = Short.MAX_VALUE;
                    }
                }
                if ((metaSet = this.itemList.get(item)) == null) {
                    metaSet = new IntOpenHashSet();
                    this.itemList.put(item, metaSet);
                }
                if (meta == Short.MAX_VALUE) {
                    metaSet.clear();
                }
                metaSet.add(meta);
            }
            catch (Exception e) {
                TheBetweenlands.logger.error("Failed to parse item: " + listed);
            }
        }
    }

    public boolean isListed(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        IntOpenHashSet metas = this.itemList.get(name.toString());
        if (metas == null) {
            return false;
        }
        if (metas.contains(Short.MAX_VALUE)) {
            return true;
        }
        return metas.contains(stack.func_77960_j());
    }
}

