/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.item.armor.ItemRubberBoots;
import thebetweenlands.common.network.clientbound.MessageShockArrowHit;

public class EntityShock
extends Entity {
    private final EntityBLArrow arrow;
    private final Set<EntityLivingBase> targets = new HashSet<EntityLivingBase>();
    private int maxJumps;
    private int jumps;
    private boolean isWet;

    public EntityShock(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.arrow = null;
    }

    public EntityShock(World worldIn, EntityBLArrow arrow, EntityLivingBase hit, boolean isWet) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, 0.0f, 0.0f);
        this.arrow = arrow;
        this.targets.add(hit);
        this.isWet = isWet;
        this.maxJumps = 2 + this.field_70170_p.field_73012_v.nextInt(3);
        if (isWet) {
            this.maxJumps *= 2;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.arrow == null) {
                this.func_70106_y();
            } else {
                Entity shootingEntity = this.arrow.getThrower();
                DamageSource damagesource = shootingEntity == null ? DamageSource.func_76353_a((EntityArrow)this.arrow, (Entity)this.arrow) : DamageSource.func_76353_a((EntityArrow)this.arrow, (Entity)shootingEntity);
                ArrayList<Pair<Entity, Entity>> chain = new ArrayList<Pair<Entity, Entity>>();
                if (this.jumps < this.maxJumps) {
                    if (this.field_70173_aa != 0 && this.field_70173_aa % 3 == 0) {
                        HashSet<EntityLivingBase> newTargets = new HashSet<EntityLivingBase>();
                        block0: for (Entity entity : this.targets) {
                            boolean isWet = entity.func_70026_G() || entity.func_70090_H() || this.field_70170_p.func_175727_C(entity.func_180425_c().func_177984_a());
                            List entities = this.field_70170_p.func_175647_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(isWet ? 6.0 : 4.0), e -> {
                                Entity riding = e.func_184208_bv();
                                return riding == e || !(riding instanceof EntityLivingBase);
                            });
                            if (entities.size() <= 1) continue;
                            Collections.sort(entities, (e1, e2) -> Double.compare(e1.func_70068_e(entity), e2.func_70068_e(entity)));
                            for (int j = 1; j < entities.size(); ++j) {
                                EntityLivingBase newTarget = (EntityLivingBase)entities.get(j);
                                if (this.targets.contains(newTarget) || newTargets.contains(newTarget)) continue;
                                newTargets.add(newTarget);
                                chain.add((Pair<Entity, Entity>)Pair.of((Object)entity, (Object)newTarget));
                                float f = MathHelper.func_76133_a((double)(this.arrow.field_70159_w * this.arrow.field_70159_w + this.arrow.field_70181_x * this.arrow.field_70181_x + this.arrow.field_70179_y * this.arrow.field_70179_y));
                                float damage = MathHelper.func_76143_f((double)((double)f * this.arrow.func_70242_d()));
                                if (this.arrow.func_70241_g()) {
                                    damage += (float)this.field_70146_Z.nextInt((int)damage / 2 + 2);
                                }
                                boolean blocked = false;
                                for (ItemStack stack : newTarget.func_184209_aF()) {
                                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemRubberBoots)) continue;
                                    stack.func_77972_a(2, newTarget);
                                    blocked = true;
                                }
                                if (blocked) continue block0;
                                newTarget.func_70097_a(damagesource, isWet ? 2.0f * damage : damage);
                                for (Entity passenger : newTarget.func_184182_bu()) {
                                    if (!(passenger instanceof EntityLivingBase) || this.targets.contains(passenger) || newTargets.contains(passenger)) continue;
                                    passenger.func_70097_a(damagesource, isWet ? 2.0f * damage : damage);
                                    newTargets.add((EntityLivingBase)passenger);
                                }
                                continue block0;
                            }
                        }
                        this.targets.addAll(newTargets);
                        TheBetweenlands.networkWrapper.sendToAllTracking((IMessage)new MessageShockArrowHit(chain), (Entity)this);
                        ++this.jumps;
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }
    }
}

