/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.environment.IRemotelyControllableEnvironmentEvent;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EnvironmentEventOverridesHandler {
    private static final ExecutorService DOWNLOADER = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("BL Environment Event Overrides Downloader #" + OVERRIDES_DOWNLOADER_THREAD_ID.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final AtomicInteger OVERRIDES_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    private static int remoteDataRecheckTicks = 0;
    private static volatile int failedDownloadAttempts = 0;
    private static volatile boolean overrideStatesDownloaded = false;
    private static List<OverrideState> overrideStates = new ArrayList<OverrideState>();
    public static final Gson GSON = new Gson();
    public static final Type STRING_ARRAY_TYPE = new TypeToken<String[]>(){}.getType();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (BetweenlandsConfig.EVENT_OVERRIDES.onlineEnvironmentEventOverrides) {
                if (failedDownloadAttempts > 0 && failedDownloadAttempts <= BetweenlandsConfig.EVENT_OVERRIDES.failedRecheckCount && remoteDataRecheckTicks > BetweenlandsConfig.EVENT_OVERRIDES.failedRecheckInterval * 20) {
                    remoteDataRecheckTicks = BetweenlandsConfig.EVENT_OVERRIDES.failedRecheckInterval * 20;
                }
                if (--remoteDataRecheckTicks <= 0) {
                    remoteDataRecheckTicks = BetweenlandsConfig.EVENT_OVERRIDES.checkInterval * 20;
                    ArrayList<WeakReference<World>> worldRefs = new ArrayList<WeakReference<World>>();
                    for (WorldServer world : server.field_71305_c) {
                        worldRefs.add(new WeakReference<WorldServer>(world));
                    }
                    EnvironmentEventOverridesHandler.downloadAndCheckStates(new WeakReference<MinecraftServer>(server), worldRefs);
                }
            } else if (!overrideStates.isEmpty()) {
                overrideStates.clear();
                for (WorldServer world : server.field_71305_c) {
                    EnvironmentEventOverridesHandler.updateWorldEventOverrideStates((World)world);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && overrideStatesDownloaded) {
            EnvironmentEventOverridesHandler.updateWorldEventOverrideStates(event.getWorld());
        }
    }

    public static boolean isRemoteDataAvailable() {
        return failedDownloadAttempts <= BetweenlandsConfig.EVENT_OVERRIDES.failedRecheckCount;
    }

    public static void downloadAndCheckStates(final WeakReference<IThreadListener> schedulerRef, final List<WeakReference<World>> worldRefs) {
        if (BetweenlandsConfig.EVENT_OVERRIDES.onlineEnvironmentEventOverrides) {
            final Proxy proxy = TheBetweenlands.proxy.getNetProxy();
            DOWNLOADER.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block8: {
                        try {
                            URL url = new URL("https://raw.githubusercontent.com/Angry-Pixel/The-Betweenlands/environment_event_overrides/overrides.json");
                            HttpURLConnection request = null;
                            try {
                                request = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                                request.setDoInput(true);
                                request.setDoOutput(false);
                                request.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                                request.connect();
                                if (request.getResponseCode() == 200) {
                                    JsonParser parser = new JsonParser();
                                    JsonElement jsonElement = parser.parse((Reader)new InputStreamReader(request.getInputStream()));
                                    failedDownloadAttempts = 0;
                                    IThreadListener scheduler = (IThreadListener)schedulerRef.get();
                                    if (scheduler != null) {
                                        List<OverrideState> states = EnvironmentEventOverridesHandler.parseStates(jsonElement);
                                        scheduler.func_152344_a(() -> {
                                            overrideStates = states;
                                            for (WeakReference worldRef : worldRefs) {
                                                World world = (World)worldRef.get();
                                                if (world == null) continue;
                                                EnvironmentEventOverridesHandler.updateWorldEventOverrideStates(world);
                                            }
                                            overrideStatesDownloaded = true;
                                        });
                                    }
                                }
                            }
                            finally {
                                if (request != null) {
                                    request.disconnect();
                                }
                            }
                        }
                        catch (Exception ex) {
                            failedDownloadAttempts++;
                            if (!BetweenlandsConfig.DEBUG.debug) break block8;
                            TheBetweenlands.logger.info("Failed downloading remote environment event overrides", (Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public static List<OverrideState> parseStates(JsonElement json) {
        ArrayList<OverrideState> states = new ArrayList<OverrideState>();
        if (json.isJsonArray()) {
            JsonArray jsonArr = json.getAsJsonArray();
            for (int i = 0; i < jsonArr.size(); ++i) {
                try {
                    boolean isVersionValid;
                    JsonObject element = jsonArr.get(i).getAsJsonObject();
                    if (element.has("versions")) {
                        String[] versions;
                        isVersionValid = false;
                        for (String version : versions = (String[])GSON.fromJson(element.get("versions"), STRING_ARRAY_TYPE)) {
                            if (!"3.7.2".equals(version)) continue;
                            isVersionValid = true;
                            break;
                        }
                    } else {
                        isVersionValid = true;
                    }
                    if (!isVersionValid) continue;
                    JsonArray overrides = element.get("overrides").getAsJsonArray();
                    for (int j = 0; j < overrides.size(); ++j) {
                        try {
                            JsonObject override = overrides.get(j).getAsJsonObject();
                            ResourceLocation id = new ResourceLocation(override.get("id").getAsString());
                            boolean value = override.get("value").getAsBoolean();
                            int remoteResetTicks = BetweenlandsConfig.EVENT_OVERRIDES.defaultRemoteResetTime * 20;
                            if (override.has("remote_reset_ticks")) {
                                remoteResetTicks = override.get("remote_reset_ticks").getAsInt();
                            }
                            HashSet<Object> dimensions = new HashSet<Object>();
                            if (override.has("dimensions")) {
                                String[] dimensionsArr = (String[])GSON.fromJson(override.get("dimensions"), STRING_ARRAY_TYPE);
                                for (String dim : dimensionsArr) {
                                    dimensions.add(dim);
                                }
                            } else {
                                dimensions.add("betweenlands");
                            }
                            ImmutableMap.Builder data = ImmutableMap.builder();
                            for (Map.Entry entry : override.entrySet()) {
                                String key = (String)entry.getKey();
                                if (key.equals("id") || key.equals("value") || key.equals("remote_reset_ticks") || key.equals("dimensions")) continue;
                                data.put((Object)key, (Object)((JsonElement)entry.getValue()).toString());
                            }
                            states.add(new OverrideState(dimensions.isEmpty() ? Optional.empty() : Optional.of(dimensions), id, remoteResetTicks, value, (ImmutableMap<String, String>)data.build()));
                            continue;
                        }
                        catch (Exception ex) {
                            if (!BetweenlandsConfig.DEBUG.debug) continue;
                            TheBetweenlands.logger.error("Failed parsing override entry: " + j, (Throwable)ex);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    if (!BetweenlandsConfig.DEBUG.debug) continue;
                    TheBetweenlands.logger.error("Failed parsing version entry: " + i, (Throwable)ex);
                }
            }
        }
        return states;
    }

    public static void updateWorldEventOverrideStates(World world) {
        BLEnvironmentEventRegistry registry;
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld(world);
        if (storage != null && (registry = storage.getEnvironmentEventRegistry()).isEnabled()) {
            IRemotelyControllableEnvironmentEvent controllable;
            IEnvironmentEvent event;
            HashSet<ResourceLocation> updatedEvents = new HashSet<ResourceLocation>();
            for (OverrideState overrideState : overrideStates) {
                if (overrideState.dimensions.isPresent() && !overrideState.dimensions.get().contains(world.field_73011_w.func_186058_p().func_186065_b()) || !((event = registry.getEvent(overrideState.eventId)) instanceof IRemotelyControllableEnvironmentEvent) || !(controllable = (IRemotelyControllableEnvironmentEvent)event).isRemotelyControllable()) continue;
                controllable.updateStateFromRemote(overrideState.value, overrideState.remoteResetTicks, overrideState.data);
                updatedEvents.add(overrideState.eventId);
            }
            for (Map.Entry entry : registry.getEvents().entrySet()) {
                event = (IEnvironmentEvent)entry.getValue();
                if (!(event instanceof IRemotelyControllableEnvironmentEvent) || !(controllable = (IRemotelyControllableEnvironmentEvent)event).isRemotelyControllable() || updatedEvents.contains(entry.getKey())) continue;
                boolean wasStateFromRemote = controllable.isCurrentStateFromRemote();
                controllable.updateNoStateFromRemote();
                if (!wasStateFromRemote) continue;
                controllable.resetStateFromRemote();
            }
        }
    }

    public static class OverrideState {
        public final Optional<Set<String>> dimensions;
        public final ResourceLocation eventId;
        public final int remoteResetTicks;
        public final boolean value;
        public final ImmutableMap<String, String> data;

        public OverrideState(Optional<Set<String>> dimensions, ResourceLocation eventId, int remoteResetTicks, boolean value, ImmutableMap<String, String> data) {
            this.dimensions = dimensions;
            this.eventId = eventId;
            this.remoteResetTicks = remoteResetTicks;
            this.value = value;
            this.data = data;
        }
    }
}

