/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityChiromawHatchling;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationChiromawMatriarchNest;

public class ItemChiromawEgg
extends ItemMob {
    private final boolean electric;

    public ItemChiromawEgg(boolean electric) {
        super(1, EntityChiromawHatchling.class, entity -> entity.setElectricBoogaloo(electric));
        this.electric = electric;
    }

    @Override
    public void onCapturedByPlayer(EntityPlayer player, EnumHand hand, ItemStack captured) {
        AxisAlignedBB checkBox;
        if (player instanceof EntityPlayerMP && player.field_70170_p.func_175647_a(EntityChiromawHatchling.class, checkBox = player.func_174813_aQ().func_186662_g(8.0), entity -> entity.func_70089_S()).isEmpty()) {
            List<LocationChiromawMatriarchNest> nests = BetweenlandsWorldStorage.forWorld(player.field_70170_p).getLocalStorageHandler().getLocalStorages(LocationChiromawMatriarchNest.class, checkBox, location -> location.getBoundingBox().func_72326_a(checkBox));
            if (nests.isEmpty()) {
                return;
            }
            for (LocationChiromawMatriarchNest nest : nests) {
                if (nest.getGuard() != null && !nest.getGuard().isClear(player.field_70170_p)) continue;
                return;
            }
            AdvancementCriterionRegistry.CHIROMAW_MATRIARCH_NEST_RAIDED.trigger((EntityPlayerMP)player);
        }
    }

    @Override
    protected void spawnCapturedEntity(EntityPlayer player, World world, Entity entity) {
        if (entity instanceof EntityChiromawHatchling) {
            ((EntityChiromawHatchling)entity).setOwnerId(player.func_110124_au());
            ((EntityChiromawHatchling)entity).setFoodCraved(((EntityChiromawHatchling)entity).chooseNewFoodFromLootTable());
        }
        super.spawnCapturedEntity(player, world, entity);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.electric;
    }
}

