/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemWeedwoodRowboat
extends Item {
    private static final float REACH = 5.0f;

    public ItemWeedwoodRowboat() {
        this.field_77777_bU = 1;
        this.func_77637_a(BLCreativeTabs.ITEMS);
        this.func_185043_a(new ResourceLocation("tarred"), (stack, world, entity) -> EntityWeedwoodRowboat.isTarred(stack) ? 1.0f : 0.0f);
    }

    public String func_77657_g(ItemStack stack) {
        String key = this.func_77667_c(stack);
        if (EntityWeedwoodRowboat.isTarred(stack)) {
            return key + ".tarred";
        }
        return key;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            list.add((Object)ItemWeedwoodRowboat.getTarred());
        }
    }

    public static ItemStack getTarred() {
        ItemStack tarred = new ItemStack(ItemRegistry.WEEDWOOD_ROWBOAT);
        NBTTagCompound attrs = new NBTTagCompound();
        attrs.func_74757_a("isTarred", true);
        tarred.func_77983_a("attributes", (NBTBase)attrs);
        return tarred;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Vec3d pos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d lookExtent = pos.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        RayTraceResult hit = world.func_72901_a(pos, lookExtent, true);
        if (hit == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        List list = world.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0).func_72314_b(1.0, 1.0, 1.0));
        for (Entity entity : list) {
            AxisAlignedBB axisalignedbb;
            if (!entity.func_70067_L() || !(axisalignedbb = entity.func_174813_aQ().func_72314_b((double)entity.func_70111_Y(), (double)entity.func_70111_Y(), (double)entity.func_70111_Y())).func_72318_a(pos)) continue;
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        IBlockState block = world.func_180495_p(hit.func_178782_a());
        boolean liquid = block.func_185904_a().func_76224_d();
        EntityWeedwoodRowboat rowboat = new EntityWeedwoodRowboat(world, hit.field_72307_f.field_72450_a, liquid ? hit.field_72307_f.field_72448_b - 0.3 : hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
        rowboat.field_70177_z = player.field_70177_z;
        if (!world.func_184144_a((Entity)rowboat, rowboat.func_174813_aQ().func_72314_b(-0.1, -0.1, -0.1)).isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            NBTTagCompound attrs = stack.func_179543_a("attributes");
            if (attrs != null) {
                rowboat.func_70037_a(attrs);
            }
            world.func_72838_d((Entity)rowboat);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

