/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.registries.FluidRegistry;

public class CenserRecipeStagnantWater
extends AbstractCenserRecipe<Void> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "stagnant_water");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.STAGNANT_WATER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Void context, ICenser censer, double x, double y, double z, float partialTicks) {
        float effectStrength = censer.getEffectStrength(partialTicks);
        if (effectStrength > 0.01f && ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            float fogBrightness = 0.85f;
            float inScattering = 0.04f * effectStrength;
            float extinction = 3.0f;
            AxisAlignedBB fogArea = new AxisAlignedBB(censer.getCenserPos()).func_72314_b(6.0, 0.1, 6.0).func_72321_a(0.0, 12.0, 0.0);
            ShaderHelper.INSTANCE.getWorldShader().addGroundFogVolume(new GroundFog.GroundFogVolume(new Vec3d(fogArea.field_72340_a, fogArea.field_72338_b, fogArea.field_72339_c), new Vec3d(fogArea.field_72336_d - fogArea.field_72340_a, fogArea.field_72337_e - fogArea.field_72338_b, fogArea.field_72334_f - fogArea.field_72339_c), inScattering, extinction, fogBrightness * 0.7f, fogBrightness * 0.7f, fogBrightness * 0.5f));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(Void context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return -86;
    }

    private List<EntityLivingBase> getAffectedEntities(World world, BlockPos pos) {
        return world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(6.0, 0.1, 6.0).func_72321_a(0.0, 12.0, 0.0));
    }

    @Override
    public int update(Void context, ICenser censer) {
        World world = censer.getCenserWorld();
        if (!world.field_72995_K && world.func_82737_E() % 100L == 0L) {
            BlockPos pos = censer.getCenserPos();
            List<EntityLivingBase> affected = this.getAffectedEntities(world, pos);
            for (EntityLivingBase living : affected) {
                living.func_70690_d(ElixirEffectRegistry.EFFECT_DECAY.createEffect(200, 1));
            }
        }
        return 0;
    }

    @Override
    public int getConsumptionDuration(Void context, ICenser censer) {
        return 30;
    }
}

