/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.DecayPitChainSound;
import thebetweenlands.common.registries.BlockRegistry;

public class TileEntityDecayPitHangingChain
extends TileEntity
implements ITickable {
    public int animationTicksChain = 0;
    public int animationTicksChainPrev = 0;
    public int PROGRESS = 0;
    public final float MOVE_UNIT = 0.0078125f;
    public boolean IS_MOVING = false;
    public boolean IS_SLOW = false;
    public boolean IS_BROKEN = false;
    public boolean playChainSound = true;

    public void func_73660_a() {
        this.animationTicksChainPrev = this.animationTicksChain++;
        if (this.isMoving() && !this.isSlow()) {
            this.animationTicksChain = this.isBroken() ? (this.animationTicksChain += 32) : (this.animationTicksChain += 8);
        }
        if (this.isBroken() && this.getProgress() > -512) {
            this.setProgress(this.getProgress() - 32);
        }
        if (this.isBroken() && this.getProgress() <= -512 && !this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), BlockRegistry.COMPACTED_MUD.func_176223_P(), 3);
        }
        if (this.getEntityCollidedWithChains(this.getHangingLengthCollision(1.0, 0.0, 2.0f + (float)this.getProgress() * 0.0078125f)) != null) {
            this.checkCollisions(this.getEntityCollidedWithChains(this.getHangingLengthCollision(1.0, 0.0, 2.0f + (float)this.getProgress() * 0.0078125f)));
        }
        if (this.getEntityCollidedWithChains(this.getHangingLengthCollision(-1.0, 0.0, 2.0f + (float)this.getProgress() * 0.0078125f)) != null) {
            this.checkCollisions(this.getEntityCollidedWithChains(this.getHangingLengthCollision(-1.0, 0.0, 2.0f + (float)this.getProgress() * 0.0078125f)));
        }
        if (this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.0, 1.0, 2.0f + (float)this.getProgress() * 0.0078125f)) != null) {
            this.checkCollisions(this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.0, 1.0, 2.0f + (float)this.getProgress() * 0.0078125f)));
        }
        if (this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.0, -1.0, 2.0f + (float)this.getProgress() * 0.0078125f)) != null) {
            this.checkCollisions(this.getEntityCollidedWithChains(this.getHangingLengthCollision(0.0, -1.0, 2.0f + (float)this.getProgress() * 0.0078125f)));
        }
        if (this.animationTicksChainPrev >= 128) {
            this.animationTicksChainPrev = 0;
            this.animationTicksChain = 0;
            if (!this.isBroken()) {
                this.setMoving(false);
            }
        }
        if (this.animationTicksChainPrev == 0 && this.isMoving() && this.isSlow() && !this.playChainSound) {
            this.playChainSound = true;
        }
        if (this.isBroken() && this.getProgress() >= 640 && !this.playChainSound) {
            this.playChainSound = true;
        }
        if (this.func_145831_w().field_72995_K && this.playChainSound) {
            if (!this.isBroken()) {
                this.playChainSound(this.func_145831_w(), this.func_174877_v());
            } else {
                this.playChainSoundFinal(this.func_145831_w(), this.func_174877_v());
            }
            this.playChainSound = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playChainSound(World world, BlockPos pos) {
        DecayPitChainSound chain_sound = new DecayPitChainSound(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)chain_sound);
    }

    @SideOnly(value=Side.CLIENT)
    public void playChainSoundFinal(World world, BlockPos pos) {
    }

    public List<Entity> getEntityCollidedWithChains(AxisAlignedBB chainBox) {
        return this.func_145831_w().func_72872_a(Entity.class, chainBox);
    }

    private void checkCollisions(List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityArrow)) continue;
            EntityArrow arrow = (EntityArrow)entity;
            arrow.func_70634_a(arrow.field_70169_q, arrow.field_70167_r, arrow.field_70166_s);
            arrow.field_70159_w *= (double)-0.1f;
            arrow.field_70181_x *= (double)-0.1f;
            arrow.field_70179_y *= (double)-0.1f;
            arrow.field_70177_z += 180.0f;
            arrow.field_70126_B += 180.0f;
            this.func_145831_w().func_184148_a((EntityPlayer)null, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.5f, 3.0f);
        }
    }

    public AxisAlignedBB getHangingLengthCollision(double offX, double offZ, float extended) {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + offX + 0.1875, (double)((float)this.func_174877_v().func_177956_o() - extended), (double)this.func_174877_v().func_177952_p() + offZ + 0.1875, (double)this.func_174877_v().func_177958_n() + offX + 0.8125, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + offZ + 0.8125);
    }

    public void setProgress(int progress) {
        this.PROGRESS = progress;
    }

    public int getProgress() {
        return this.PROGRESS;
    }

    public void setMoving(boolean moving) {
        this.IS_MOVING = moving;
    }

    public boolean isMoving() {
        return this.IS_MOVING;
    }

    public void setSlow(boolean slow) {
        this.IS_SLOW = slow;
    }

    public boolean isSlow() {
        return this.IS_SLOW;
    }

    public void setBroken(boolean broken) {
        this.IS_BROKEN = broken;
    }

    public boolean isBroken() {
        return this.IS_BROKEN;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("animationTicksChain", this.animationTicksChain);
        nbt.func_74768_a("animationTicksChainPrev", this.animationTicksChainPrev);
        nbt.func_74768_a("progress", this.PROGRESS);
        nbt.func_74757_a("broken", this.IS_BROKEN);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.animationTicksChain = nbt.func_74762_e("animationTicksChain");
        this.animationTicksChainPrev = nbt.func_74762_e("animationTicksChainPrev");
        this.PROGRESS = nbt.func_74762_e("progress");
        this.IS_BROKEN = nbt.func_74767_n("broken");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }
}

