/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationSpawnEntry
extends AreaMobSpawner.BLSpawnEntry {
    protected final EnumLocationType locationType;

    public LocationSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, EnumLocationType locationType) {
        super(id, entityType, entityCtor);
        this.locationType = locationType;
    }

    public LocationSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, short weight, EnumLocationType locationType) {
        super(id, entityType, entityCtor, weight);
        this.locationType = locationType;
    }

    @Override
    public void update(World world, BlockPos pos) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        List<LocationStorage> locations = worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, pos.func_177958_n(), pos.func_177952_p(), location -> location.isInside((Vec3i)pos) && this.locationType.equals((Object)location.getType()));
        if (locations.isEmpty()) {
            this.setWeight((short)0);
        } else {
            this.setWeight(this.getBaseWeight());
        }
    }
}

