/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.block.terrain.BlockHanger;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.IBlockStateAccessOnly;
import thebetweenlands.common.world.gen.biome.feature.CoarseIslandsFeature;
import thebetweenlands.common.world.gen.feature.WorldGenGiantRoot;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class MapGenFloatingIslands
extends MapGenBase {
    protected CoarseIslandsFeature coarseIslandsFeature = new CoarseIslandsFeature();
    protected List<BlockPos> islands = new ArrayList<BlockPos>();
    protected List<WorldGenGiantRoot> giantRootGens = new ArrayList<WorldGenGiantRoot>();
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] islandNoise = new double[256];
    private NoiseGeneratorPerlin cragNoiseGen;
    private double[] cragNoise = new double[256];

    public MapGenFloatingIslands(long worldSeed) {
        this.field_75040_a = 5;
        Random rng = new Random(worldSeed);
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 3);
        this.cragNoiseGen = new NoiseGeneratorPerlin(rng, 5);
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        this.islands.clear();
        this.giantRootGens.clear();
        super.func_186125_a(worldIn, x, z, primer);
        for (BlockPos island : this.islands) {
            if (!(island.func_185332_f(x * 16, island.func_177956_o(), z * 16) <= 52.0)) continue;
            Random rand = new Random();
            rand.setSeed((long)(island.func_177958_n() ^ island.func_177956_o() ^ island.func_177952_p()) ^ worldIn.func_72905_C());
            this.generateIsland(island, rand, x, z, primer);
        }
        for (WorldGenGiantRoot root : this.giantRootGens) {
            root.setGenBounds(new AxisAlignedBB((double)(x * 16), 0.0, (double)(z * 16), (double)(x * 16 + 15), 256.0, (double)(z * 16 + 15)));
            Random rootRand = new Random();
            rootRand.setSeed((long)(root.start.func_177958_n() ^ root.start.func_177956_o() ^ root.start.func_177952_p()) ^ worldIn.func_72905_C());
            root.generate(IBlockStateAccessOnly.from(x, z, primer), x, z, true, rootRand, root.start);
        }
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer chunkPrimerIn) {
        if (this.field_75038_b.nextInt(80) == 0) {
            int inChunkX = this.field_75038_b.nextInt(16);
            int inChunkZ = this.field_75038_b.nextInt(16);
            if (worldIn.func_72959_q().func_180631_a(new BlockPos(chunkX * 16 + inChunkX, 64, chunkZ * 16 + inChunkZ)) == BiomeRegistry.RAISED_ISLES) {
                BlockPos end;
                ArrayList<BlockPos> surfaceRootCandidates = new ArrayList<BlockPos>();
                ArrayList<BlockPos> islandRootCandidates = new ArrayList<BlockPos>();
                BlockPos islandCandidate = new BlockPos(chunkX * 16 + inChunkX, 145 + this.field_75038_b.nextInt(40), chunkZ * 16 + inChunkZ);
                int numRoots = this.field_75038_b.nextInt(4) + 3;
                for (int i = 0; i < numRoots; ++i) {
                    int range = (i + 1) * 5 + 10;
                    surfaceRootCandidates.add(islandCandidate.func_177982_a(this.field_75038_b.nextInt(range) - range / 2, -6, this.field_75038_b.nextInt(range) - range / 2));
                }
                islandRootCandidates.add(islandCandidate.func_177982_a(this.field_75038_b.nextInt(32) - 16, 1, this.field_75038_b.nextInt(32) - 16));
                int numSmallRoots = this.field_75038_b.nextInt(3);
                for (int i = 0; i < numSmallRoots; ++i) {
                    BlockPos start = islandCandidate.func_177982_a(this.field_75038_b.nextInt(32) - 16, 1, this.field_75038_b.nextInt(32) - 16);
                    end = islandCandidate.func_177982_a(this.field_75038_b.nextInt(32) - 16, 1, this.field_75038_b.nextInt(32) - 16);
                    this.giantRootGens.add(new WorldGenGiantRoot(start, end, 1.0, 1.5, 3.0, 2.0, 7.0, false, false, true, true, null));
                }
                Collections.shuffle(surfaceRootCandidates, this.field_75038_b);
                Collections.shuffle(islandRootCandidates, this.field_75038_b);
                this.islands.add(islandCandidate);
                for (BlockPos start : surfaceRootCandidates) {
                    end = this.findSurfaceEndpoint(start.func_177958_n() >> 4, start.func_177952_p() >> 4, start, 2);
                    if (end == null) continue;
                    this.giantRootGens.add(new WorldGenGiantRoot(start, end, 2.0, 4.0, 10.0, 7.0, -12.0, true, false, true, true, null));
                }
                for (BlockPos start : islandRootCandidates) {
                    end = this.findIslandEndpoint(start.func_177958_n() >> 4, start.func_177952_p() >> 4, start, 3);
                    if (end == null) continue;
                    this.giantRootGens.add(new WorldGenGiantRoot(start, end, 1.0, 2.0, 6.0, 4.0, 25.0, false, false, true, true, null));
                }
            }
        }
    }

    protected void generateIsland(BlockPos center, Random rand, int chunkX, int chunkZ, ChunkPrimer primer) {
        long locationSeed = rand.nextLong();
        if (center.func_177958_n() >> 4 == chunkX && center.func_177952_p() >> 4 == chunkZ) {
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(this.field_75039_c);
            LocationStorage locationStorage = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(center), "floating_island", EnumLocationType.FLOATING_ISLAND);
            locationStorage.addBounds(new AxisAlignedBB(center).func_72314_b(30.0, 18.0, 30.0).func_72317_d(0.0, 5.0, 0.0));
            locationStorage.setVisible(false);
            locationStorage.setSeed(locationSeed);
            locationStorage.setDirty(true);
            worldStorage.getLocalStorageHandler().addLocalStorage(locationStorage);
        }
        float[] islandMask = new float[256];
        int i = rand.nextInt(4) + 6;
        float size = rand.nextFloat();
        float minSize = 20.0f + size * 8.0f;
        float maxSize = 40.0f + size * 18.0f;
        int relX = center.func_177958_n() - chunkX * 16;
        int relZ = center.func_177952_p() - chunkZ * 16;
        for (int round = 0; round < i; ++round) {
            float wx = rand.nextFloat() * (maxSize - minSize) + minSize;
            float wz = rand.nextFloat() * (maxSize - minSize) + minSize;
            float mx = 32.0f + (rand.nextFloat() - 0.5f) * wx * 0.5f;
            float mz = 32.0f + (rand.nextFloat() - 0.5f) * wz * 0.5f;
            for (int bx = 0; bx < 16; ++bx) {
                for (int bz = 0; bz < 16; ++bz) {
                    int ix = bx - relX + 32;
                    int iz = bz - relZ + 32;
                    if (ix < 0 || ix >= 64 || iz < 0 || iz >= 64) continue;
                    float dx = ((float)ix - mx) / wx;
                    float dz = ((float)iz - mz) / wz;
                    float d = dx * dx + dz * dz;
                    islandMask[bx * 16 + bz] = Math.max(islandMask[bx * 16 + bz], 1.0f - d);
                }
            }
        }
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.4, 0.4, 1.0);
        this.cragNoise = this.cragNoiseGen.func_151599_a(this.cragNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.55, 0.55, 1.0);
        float minVal = 0.8f;
        boolean hasPond = rand.nextInt(3) == 0;
        for (int bx = 0; bx < 16; ++bx) {
            for (int bz = 0; bz < 16; ++bz) {
                int by;
                int y;
                int by2;
                int y2;
                int surface;
                if (!(islandMask[bx * 16 + bz] > minVal)) continue;
                double islandNoiseVal = this.islandNoise[bz * 16 + bx] / (double)0.9f + (double)2.1f;
                double cragNoise = this.cragNoise[bz * 16 + bx] / (double)2.1f + 2.0;
                boolean isCrag = cragNoise <= 0.0;
                double islandMaskVal = islandMask[bx * 16 + bz] - minVal;
                int depth = MathHelper.func_76143_f((double)(islandMaskVal * islandMaskVal * 200.0 + islandNoiseVal * islandNoiseVal * islandMaskVal));
                int height = MathHelper.func_76128_c((double)(islandMaskVal * 12.0 - islandNoiseVal * islandMaskVal * (double)0.1f + (double)(cragNoise < (double)0.2f ? 1 : 0)));
                int lowering = 0;
                if (hasPond && islandMaskVal * 12.0 > 1.5) {
                    lowering = MathHelper.func_76143_f((double)((islandMaskVal * 12.0 - 1.5) * 5.0));
                }
                int water = -1;
                for (surface = center.func_177956_o(); surface > depth + 1; --surface) {
                    IBlockState state = primer.func_177856_a(bx, surface, bz);
                    boolean liquid = state.func_185904_a().func_76224_d();
                    if (liquid && water < 0) {
                        water = surface;
                    }
                    if (state.func_177230_c() != Blocks.field_150350_a && !liquid) break;
                }
                for (int y3 = 0; y3 > -depth; --y3) {
                    if (surface + y3 <= 0 || primer.func_177856_a(bx, surface, bz).func_185904_a().func_76224_d()) continue;
                    if (surface + y3 <= 120) {
                        primer.func_177855_a(bx, surface + y3, bz, BlockRegistry.SWAMP_WATER.func_176223_P());
                        continue;
                    }
                    primer.func_177855_a(bx, surface + y3, bz, Blocks.field_150350_a.func_176223_P());
                }
                boolean isPondColumn = height - lowering < 0 && lowering > 0;
                for (y2 = height - lowering; y2 > -depth - lowering; --y2) {
                    by2 = center.func_177956_o() + y2;
                    if (by2 <= 0) continue;
                    if (isCrag) {
                        if (y2 == height - lowering) {
                            primer.func_177855_a(bx, by2, bz, BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_1)));
                            continue;
                        }
                        if (y2 == height - lowering - 1) {
                            primer.func_177855_a(bx, by2, bz, BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_2)));
                            continue;
                        }
                        if (y2 == height - lowering - 2) {
                            primer.func_177855_a(bx, by2, bz, BlockRegistry.CRAGROCK.func_176223_P());
                            continue;
                        }
                        primer.func_177855_a(bx, by2, bz, BlockRegistry.BETWEENSTONE.func_176223_P());
                        continue;
                    }
                    if (isPondColumn) {
                        primer.func_177855_a(bx, by2, bz, BlockRegistry.MUD.func_176223_P());
                        continue;
                    }
                    if (y2 == height - lowering) {
                        primer.func_177855_a(bx, by2, bz, BlockRegistry.SWAMP_GRASS.func_176223_P());
                        continue;
                    }
                    if (y2 >= height - lowering - 2) {
                        primer.func_177855_a(bx, by2, bz, BlockRegistry.SWAMP_DIRT.func_176223_P());
                        continue;
                    }
                    primer.func_177855_a(bx, by2, bz, BlockRegistry.BETWEENSTONE.func_176223_P());
                }
                if (isPondColumn) {
                    for (y2 = 0; y2 > height - lowering; --y2) {
                        by2 = center.func_177956_o() + y2;
                        if (by2 <= 0) continue;
                        primer.func_177855_a(bx, by2, bz, BlockRegistry.SWAMP_WATER.func_176223_P());
                    }
                }
                if (rand.nextInt(20) == 0 && height + depth <= 3 && !isCrag) {
                    int rootLength = 1 + rand.nextInt(12);
                    for (y = -depth - lowering; y > -depth - rootLength - lowering; --y) {
                        by = center.func_177956_o() + y;
                        if (by <= 0) continue;
                        primer.func_177855_a(bx, by, bz, BlockRegistry.ROOT.func_176223_P());
                    }
                    continue;
                }
                if (rand.nextInt(13) == 0) {
                    int hangerLength = 1 + rand.nextInt(8);
                    for (y = -depth - lowering; y > -depth - hangerLength - lowering; --y) {
                        by = center.func_177956_o() + y;
                        if (by <= 0) continue;
                        primer.func_177855_a(bx, by, bz, BlockRegistry.HANGER.func_176223_P().func_177226_a((IProperty)BlockHanger.CAN_GROW, (Comparable)Boolean.valueOf(false)));
                    }
                    continue;
                }
                if (rand.nextInt(400) != 0 || water <= 0 || height + depth < 4 || center.func_177956_o() - depth - lowering + 3 <= 0) continue;
                primer.func_177855_a(bx, center.func_177956_o() - depth - lowering + 3, bz, BlockRegistry.SWAMP_WATER.func_176223_P());
                for (int by3 = center.func_177956_o() - depth - lowering + 2; by3 > water; --by3) {
                    if (by3 <= 0) continue;
                    primer.func_177855_a(bx, by3, bz, BlockRegistry.SWAMP_WATER.func_176223_P().func_177226_a((IProperty)BlockSwampWater.LEVEL, (Comparable)Integer.valueOf(1)));
                }
            }
        }
    }

    @Nullable
    protected BlockPos findIslandEndpoint(int chunkX, int chunkZ, BlockPos start, int chunkRange) {
        ArrayList<BlockPos> endCandidates = new ArrayList<BlockPos>();
        int subDivs = 2;
        int step = 16 / subDivs;
        for (int newChunkX = chunkX - chunkRange; newChunkX <= chunkX + chunkRange; ++newChunkX) {
            for (int newChunkZ = chunkZ - chunkRange; newChunkZ <= chunkZ + chunkRange; ++newChunkZ) {
                int inChunkX = 0;
                int inChunkZ = 0;
                for (int xs = 0; xs < subDivs; ++xs) {
                    for (int zs = 0; zs < subDivs; ++zs) {
                        if (this.field_75038_b.nextInt(60) == 0) {
                            int wx = newChunkX * 16 + inChunkX;
                            int wz = newChunkZ * 16 + inChunkZ;
                            for (BlockPos island : this.islands) {
                                int dz;
                                int dx;
                                if (island.equals((Object)start) || (dx = island.func_177958_n() - wx) * dx + (dz = island.func_177952_p() - wz) * dz >> 4 > 2) continue;
                                endCandidates.add(new BlockPos(newChunkX * 16 + inChunkX, island.func_177956_o(), newChunkZ * 16 + inChunkZ));
                            }
                        }
                        inChunkZ += step;
                    }
                    inChunkX += step;
                }
            }
        }
        if (!endCandidates.isEmpty()) {
            Collections.shuffle(endCandidates, this.field_75038_b);
            for (BlockPos endCandidate : endCandidates) {
                if (!(endCandidate.func_177951_i((Vec3i)start) >= 400.0)) continue;
                return endCandidate;
            }
        }
        return null;
    }

    @Nullable
    protected BlockPos findSurfaceEndpoint(int chunkX, int chunkZ, BlockPos start, int chunkRange) {
        ArrayList<BlockPos> endCandidates = new ArrayList<BlockPos>();
        int subDivs = 4;
        int step = 16 / subDivs;
        for (int newChunkX = chunkX - chunkRange; newChunkX <= chunkX + chunkRange; ++newChunkX) {
            for (int newChunkZ = chunkZ - chunkRange; newChunkZ <= chunkZ + chunkRange; ++newChunkZ) {
                int inChunkX = 0;
                int inChunkZ = 0;
                for (int xs = 0; xs < subDivs; ++xs) {
                    for (int zs = 0; zs < subDivs; ++zs) {
                        if (this.field_75038_b.nextInt(60) == 0) {
                            endCandidates.add(new BlockPos(newChunkX * 16 + inChunkX, 114, newChunkZ * 16 + inChunkZ));
                        }
                        inChunkZ += step;
                    }
                    inChunkX += step;
                }
            }
        }
        if (!endCandidates.isEmpty()) {
            Collections.shuffle(endCandidates, this.field_75038_b);
            for (BlockPos endCandidate : endCandidates) {
                if (!(endCandidate.func_177951_i((Vec3i)start) >= 1600.0)) continue;
                return endCandidate;
            }
        }
        return null;
    }
}

