/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.container.BlockLootUrn;
import thebetweenlands.common.block.container.BlockMudBrickAlcove;
import thebetweenlands.common.block.misc.BlockMudFlowerPotCandle;
import thebetweenlands.common.block.plant.BlockEdgePlant;
import thebetweenlands.common.block.plant.BlockHangingPlant;
import thebetweenlands.common.block.structure.BlockBrazier;
import thebetweenlands.common.block.structure.BlockCarvedMudBrick;
import thebetweenlands.common.block.structure.BlockDiagonalEnergyBarrier;
import thebetweenlands.common.block.structure.BlockDungeonDoorCombination;
import thebetweenlands.common.block.structure.BlockDungeonDoorRunes;
import thebetweenlands.common.block.structure.BlockDungeonWallCandle;
import thebetweenlands.common.block.structure.BlockMudBricksClimbable;
import thebetweenlands.common.block.structure.BlockMudTiles;
import thebetweenlands.common.block.structure.BlockMudTilesWater;
import thebetweenlands.common.block.structure.BlockRottenBarkCarved;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.structure.BlockStairsBetweenlands;
import thebetweenlands.common.block.structure.BlockWoodenSupportBeam;
import thebetweenlands.common.block.structure.BlockWormDungeonPillar;
import thebetweenlands.common.block.terrain.BlockHanger;
import thebetweenlands.common.block.terrain.BlockLogBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityGroundItem;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSludgeWormDungeon;

public class SludgeWormMazeBlockHelper {
    public IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    public IBlockState MOB_SPAWNER = BlockRegistry.MOB_SPAWNER.func_176223_P();
    public IBlockState BLACK_HAT_MUSHROOM = BlockRegistry.BLACK_HAT_MUSHROOM.func_176223_P();
    public IBlockState FLAT_HEAD_MUSHROOM = BlockRegistry.FLAT_HEAD_MUSHROOM.func_176223_P();
    public IBlockState ROTBULB = BlockRegistry.ROTBULB.func_176223_P();
    public IBlockState TALL_SLUDGECREEP = BlockRegistry.TALL_SLUDGECREEP.func_176223_P();
    public IBlockState PALE_GRASS = BlockRegistry.PALE_GRASS.func_176223_P();
    public IBlockState MOSS = BlockRegistry.DEAD_MOSS.func_176223_P();
    public IBlockState LICHEN = BlockRegistry.DEAD_LICHEN.func_176223_P();
    public IBlockState EDGE_SHROOM = BlockRegistry.EDGE_SHROOM.func_176223_P();
    public IBlockState EDGE_MOSS = BlockRegistry.EDGE_MOSS.func_176223_P();
    public IBlockState EDGE_LEAF = BlockRegistry.EDGE_LEAF.func_176223_P();
    public IBlockState CRYPTWEED = BlockRegistry.CRYPTWEED.func_176223_P().func_177226_a((IProperty)BlockHangingPlant.CAN_GROW, (Comparable)Boolean.valueOf(false));
    public IBlockState STRING_ROOTS = BlockRegistry.STRING_ROOTS.func_176223_P().func_177226_a((IProperty)BlockHangingPlant.CAN_GROW, (Comparable)Boolean.valueOf(false));
    public IBlockState HANGER = BlockRegistry.HANGER.func_176223_P().func_177226_a((IProperty)BlockHanger.CAN_GROW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockHanger.SEEDED, (Comparable)Boolean.valueOf(false));
    public IBlockState STAGNANT_WATER = BlockRegistry.STAGNANT_WATER.func_176223_P();
    public IBlockState DUNGEON_WALL_CANDLE_NORTH = BlockRegistry.DUNGEON_WALL_CANDLE.func_176223_P().func_177226_a((IProperty)BlockDungeonWallCandle.field_185512_D, (Comparable)EnumFacing.NORTH);
    public IBlockState DUNGEON_WALL_CANDLE_EAST = BlockRegistry.DUNGEON_WALL_CANDLE.func_176223_P().func_177226_a((IProperty)BlockDungeonWallCandle.field_185512_D, (Comparable)EnumFacing.EAST);
    public IBlockState DUNGEON_WALL_CANDLE_SOUTH = BlockRegistry.DUNGEON_WALL_CANDLE.func_176223_P().func_177226_a((IProperty)BlockDungeonWallCandle.field_185512_D, (Comparable)EnumFacing.SOUTH);
    public IBlockState DUNGEON_WALL_CANDLE_WEST = BlockRegistry.DUNGEON_WALL_CANDLE.func_176223_P().func_177226_a((IProperty)BlockDungeonWallCandle.field_185512_D, (Comparable)EnumFacing.WEST);
    public IBlockState CHEST = BlockRegistry.WEEDWOOD_CHEST.func_176223_P();
    public IBlockState WORM_DUNGEON_PILLAR = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P();
    public IBlockState WORM_DUNGEON_PILLAR_TOP = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP));
    public IBlockState WORM_DUNGEON_PILLAR_DECAY_1 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_VERTICAL_DECAY_1));
    public IBlockState WORM_DUNGEON_PILLAR_TOP_DECAY_1 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP_DECAY_1));
    public IBlockState WORM_DUNGEON_PILLAR_DECAY_2 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_VERTICAL_DECAY_2));
    public IBlockState WORM_DUNGEON_PILLAR_TOP_DECAY_2 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP_DECAY_2));
    public IBlockState WORM_DUNGEON_PILLAR_DECAY_3 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_VERTICAL_DECAY_3));
    public IBlockState WORM_DUNGEON_PILLAR_TOP_DECAY_3 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP_DECAY_3));
    public IBlockState WORM_DUNGEON_PILLAR_DECAY_4 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_VERTICAL_DECAY_4));
    public IBlockState WORM_DUNGEON_PILLAR_TOP_DECAY_4 = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP_DECAY_4));
    public IBlockState WORM_DUNGEON_PILLAR_DECAY_FULL = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_VERTICAL_DECAY_FULL));
    public IBlockState WORM_DUNGEON_PILLAR_TOP_DECAY_FULL = BlockRegistry.WORM_DUNGEON_PILLAR.func_176223_P().func_177226_a(BlockWormDungeonPillar.VARIANT, (Comparable)((Object)BlockWormDungeonPillar.EnumWormPillarType.WORM_PILLAR_TOP_DECAY_FULL));
    public IBlockState MUD_TILES = BlockRegistry.MUD_TILES.func_176223_P();
    public IBlockState MUD_TILES_DECAY = BlockRegistry.MUD_TILES.func_176223_P().func_177226_a(BlockMudTiles.VARIANT, (Comparable)((Object)BlockMudTiles.EnumMudTileType.MUD_TILES_DECAY));
    public IBlockState MUD_TILES_CRACKED = BlockRegistry.MUD_TILES.func_176223_P().func_177226_a(BlockMudTiles.VARIANT, (Comparable)((Object)BlockMudTiles.EnumMudTileType.MUD_TILES_CRACKED));
    public IBlockState MUD_TILES_CRACKED_DECAY = BlockRegistry.MUD_TILES.func_176223_P().func_177226_a(BlockMudTiles.VARIANT, (Comparable)((Object)BlockMudTiles.EnumMudTileType.MUD_TILES_CRACKED_DECAY));
    public IBlockState MUD_TILES_WATER = BlockRegistry.MUD_TILES_WATER.func_176223_P();
    public IBlockState MUD_BRICK_STAIRS = BlockRegistry.MUD_BRICK_STAIRS.func_176223_P();
    public IBlockState MUD_BRICK_STAIRS_DECAY_1 = BlockRegistry.MUD_BRICK_STAIRS_DECAY_1.func_176223_P();
    public IBlockState MUD_BRICK_STAIRS_DECAY_2 = BlockRegistry.MUD_BRICK_STAIRS_DECAY_2.func_176223_P();
    public IBlockState MUD_BRICK_STAIRS_DECAY_3 = BlockRegistry.MUD_BRICK_STAIRS_DECAY_3.func_176223_P();
    public IBlockState MUD_BRICK_STAIRS_DECAY_4 = BlockRegistry.MUD_BRICK_STAIRS_DECAY_4.func_176223_P();
    public IBlockState MUD_BRICK_SLAB = BlockRegistry.MUD_BRICK_SLAB.func_176223_P();
    public IBlockState MUD_BRICK_SLAB_DECAY_1 = BlockRegistry.MUD_BRICK_SLAB_DECAY_1.func_176223_P();
    public IBlockState MUD_BRICK_SLAB_DECAY_2 = BlockRegistry.MUD_BRICK_SLAB_DECAY_2.func_176223_P();
    public IBlockState MUD_BRICK_SLAB_DECAY_3 = BlockRegistry.MUD_BRICK_SLAB_DECAY_3.func_176223_P();
    public IBlockState MUD_BRICK_SLAB_DECAY_4 = BlockRegistry.MUD_BRICK_SLAB_DECAY_4.func_176223_P();
    public IBlockState MUD_BRICKS = BlockRegistry.MUD_BRICKS.func_176223_P();
    public IBlockState MUD_BRICKS_DECAY_1 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_DECAY_1));
    public IBlockState MUD_BRICKS_DECAY_2 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_DECAY_2));
    public IBlockState MUD_BRICKS_DECAY_3 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_DECAY_3));
    public IBlockState MUD_BRICKS_DECAY_4 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_DECAY_4));
    public IBlockState MUD_BRICKS_CARVED = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED));
    public IBlockState MUD_BRICKS_CARVED_DECAY_1 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_DECAY_1));
    public IBlockState MUD_BRICKS_CARVED_DECAY_2 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_DECAY_2));
    public IBlockState MUD_BRICKS_CARVED_DECAY_3 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_DECAY_3));
    public IBlockState MUD_BRICKS_CARVED_DECAY_4 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_DECAY_4));
    public IBlockState MUD_BRICKS_CARVED_EDGE = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_EDGE));
    public IBlockState MUD_BRICKS_CARVED_EDGE_DECAY_1 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_EDGE_DECAY_1));
    public IBlockState MUD_BRICKS_CARVED_EDGE_DECAY_2 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_EDGE_DECAY_2));
    public IBlockState MUD_BRICKS_CARVED_EDGE_DECAY_3 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_EDGE_DECAY_3));
    public IBlockState MUD_BRICKS_CARVED_EDGE_DECAY_4 = BlockRegistry.MUD_BRICKS_CARVED.func_176223_P().func_177226_a(BlockCarvedMudBrick.VARIANT, (Comparable)((Object)BlockCarvedMudBrick.EnumCarvedMudBrickType.MUD_BRICKS_CARVED_EDGE_DECAY_4));
    public IBlockState MUD_BRICKS_SPIKE_TRAP = BlockRegistry.MUD_BRICK_SPIKE_TRAP.func_176223_P();
    public IBlockState MUD_TILES_SPIKE_TRAP = BlockRegistry.MUD_TILES_SPIKE_TRAP.func_176223_P();
    public IBlockState MUD = BlockRegistry.MUD.func_176223_P();
    public IBlockState COMPACTED_MUD = BlockRegistry.COMPACTED_MUD.func_176223_P();
    public IBlockState COMPACTED_MUD_SLOPE = BlockRegistry.COMPACTED_MUD_SLOPE.func_176223_P();
    public IBlockState MUD_BRICK_ROOF = BlockRegistry.MUD_BRICK_ROOF.func_176223_P();
    public IBlockState PUFFSHROOM = BlockRegistry.PUFFSHROOM.func_176223_P();
    public IBlockState ROTTEN_BARK = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P().func_177226_a((IProperty)BlockLogBetweenlands.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
    public IBlockState ROOT = BlockRegistry.ROOT.func_176223_P();
    public IBlockState DUNGEON_DOOR_COMBINATION_EAST = BlockRegistry.DUNGEON_DOOR_COMBINATION.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorCombination.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState DUNGEON_DOOR_COMBINATION_WEST = BlockRegistry.DUNGEON_DOOR_COMBINATION.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorCombination.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState DUNGEON_DOOR_EAST = BlockRegistry.DUNGEON_DOOR_RUNES.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState DUNGEON_DOOR_WEST = BlockRegistry.DUNGEON_DOOR_RUNES.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState DUNGEON_DOOR_NORTH = BlockRegistry.DUNGEON_DOOR_RUNES.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.NORTH);
    public IBlockState DUNGEON_DOOR_SOUTH = BlockRegistry.DUNGEON_DOOR_RUNES.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.SOUTH);
    public IBlockState DUNGEON_DOOR_MIMIC_EAST = BlockRegistry.DUNGEON_DOOR_RUNES_MIMIC.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState DUNGEON_DOOR_MIMIC_WEST = BlockRegistry.DUNGEON_DOOR_RUNES_MIMIC.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState DUNGEON_DOOR_MIMIC_NORTH = BlockRegistry.DUNGEON_DOOR_RUNES_MIMIC.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.NORTH);
    public IBlockState DUNGEON_DOOR_MIMIC_SOUTH = BlockRegistry.DUNGEON_DOOR_RUNES_MIMIC.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.SOUTH);
    public IBlockState DUNGEON_DOOR_CRAWLER_EAST = BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState DUNGEON_DOOR_CRAWLER_WEST = BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState DUNGEON_DOOR_CRAWLER_NORTH = BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.NORTH);
    public IBlockState DUNGEON_DOOR_CRAWLER_SOUTH = BlockRegistry.DUNGEON_DOOR_RUNES_CRAWLER.func_176223_P().func_177226_a((IProperty)BlockDungeonDoorRunes.FACING, (Comparable)EnumFacing.SOUTH);
    public IBlockState LOOT_URN_1 = BlockRegistry.LOOT_URN.func_176223_P().func_177226_a(BlockLootUrn.VARIANT, (Comparable)((Object)BlockLootUrn.EnumLootUrn.URN_1));
    public IBlockState LOOT_URN_2 = BlockRegistry.LOOT_URN.func_176223_P().func_177226_a(BlockLootUrn.VARIANT, (Comparable)((Object)BlockLootUrn.EnumLootUrn.URN_2));
    public IBlockState LOOT_URN_3 = BlockRegistry.LOOT_URN.func_176223_P().func_177226_a(BlockLootUrn.VARIANT, (Comparable)((Object)BlockLootUrn.EnumLootUrn.URN_3));
    public IBlockState MUD_BRICKS_ALCOVE_NORTH = BlockRegistry.MUD_BRICK_ALCOVE.func_176223_P().func_177226_a((IProperty)BlockMudBrickAlcove.FACING, (Comparable)EnumFacing.NORTH);
    public IBlockState MUD_BRICKS_ALCOVE_EAST = BlockRegistry.MUD_BRICK_ALCOVE.func_176223_P().func_177226_a((IProperty)BlockMudBrickAlcove.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState MUD_BRICKS_ALCOVE_SOUTH = BlockRegistry.MUD_BRICK_ALCOVE.func_176223_P().func_177226_a((IProperty)BlockMudBrickAlcove.FACING, (Comparable)EnumFacing.SOUTH);
    public IBlockState MUD_BRICKS_ALCOVE_WEST = BlockRegistry.MUD_BRICK_ALCOVE.func_176223_P().func_177226_a((IProperty)BlockMudBrickAlcove.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState MUD_BRICKS_CLIMBABLE_NORTH = BlockRegistry.MUD_BRICKS_CLIMBABLE.func_176223_P().func_177226_a((IProperty)BlockMudBricksClimbable.FACING, (Comparable)EnumFacing.NORTH);
    public IBlockState MUD_BRICKS_CLIMBABLE_EAST = BlockRegistry.MUD_BRICKS_CLIMBABLE.func_176223_P().func_177226_a((IProperty)BlockMudBricksClimbable.FACING, (Comparable)EnumFacing.EAST);
    public IBlockState MUD_BRICKS_CLIMBABLE_SOUTH = BlockRegistry.MUD_BRICKS_CLIMBABLE.func_176223_P().func_177226_a((IProperty)BlockMudBricksClimbable.FACING, (Comparable)EnumFacing.SOUTH);
    public IBlockState MUD_BRICKS_CLIMBABLE_WEST = BlockRegistry.MUD_BRICKS_CLIMBABLE.func_176223_P().func_177226_a((IProperty)BlockMudBricksClimbable.FACING, (Comparable)EnumFacing.WEST);
    public IBlockState MUD_FLOWER_POT_CANDLE_LIT = BlockRegistry.MUD_FLOWER_POT_CANDLE.func_176223_P().func_177226_a((IProperty)BlockMudFlowerPotCandle.LIT, (Comparable)Boolean.valueOf(true));
    public IBlockState MUD_FLOWER_POT_CANDLE_UNLIT = BlockRegistry.MUD_FLOWER_POT_CANDLE.func_176223_P().func_177226_a((IProperty)BlockMudFlowerPotCandle.LIT, (Comparable)Boolean.valueOf(false));
    public IBlockState MUD_BRICK_WALL = BlockRegistry.MUD_BRICK_WALL.func_176223_P();
    public IBlockState ITEM_SHELF = BlockRegistry.ITEM_SHELF.func_176223_P();
    public IBlockState WOODEN_SUPPORT_BEAM_ROTTEN_1 = BlockRegistry.WOODEN_SUPPORT_BEAM_ROTTEN_1.func_176223_P();
    public IBlockState WOODEN_SUPPORT_BEAM_ROTTEN_2 = BlockRegistry.WOODEN_SUPPORT_BEAM_ROTTEN_2.func_176223_P();
    public IBlockState WOODEN_SUPPORT_BEAM_ROTTEN_3 = BlockRegistry.WOODEN_SUPPORT_BEAM_ROTTEN_2.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK = BlockRegistry.LOG_ROTTEN_BARK.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_1 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_1.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_2 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_2.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_3 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_3.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_4 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_4.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_5 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_5.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_6 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_6.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_7 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_7.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_8 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_8.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_9 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_9.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_10 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_10.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_11 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_11.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_12 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_12.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_13 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_13.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_14 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_14.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_15 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_15.func_176223_P();
    public IBlockState LOG_ROTTEN_BARK_CARVED_16 = BlockRegistry.LOG_ROTTEN_BARK_CARVED_16.func_176223_P();
    public IBlockState ROTTEN_PLANKS = BlockRegistry.ROTTEN_PLANKS.func_176223_P();
    public IBlockState ROTTEN_PLANK_SLAB_UPPER = BlockRegistry.ROTTEN_PLANK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    public IBlockState ROTTEN_PLANK_SLAB_LOWER = BlockRegistry.ROTTEN_PLANK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM));
    public IBlockState BETWEENSTONE = BlockRegistry.BETWEENSTONE.func_176223_P();
    public IBlockState SMOOTH_BETWEENSTONE = BlockRegistry.SMOOTH_BETWEENSTONE.func_176223_P();
    public IBlockState SMOOTH_BETWEENSTONE_STAIRS = BlockRegistry.SMOOTH_BETWEENSTONE_STAIRS.func_176223_P();
    public IBlockState SMOOTH_BETWEENSTONE_SLAB_UPPER = BlockRegistry.SMOOTH_BETWEENSTONE_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    public IBlockState SMOOTH_BETWEENSTONE_SLAB_LOWER = BlockRegistry.SMOOTH_BETWEENSTONE_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM));
    public IBlockState BETWEENSTONE_BRICKS = BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P();
    public IBlockState BETWEENSTONE_BRICK_STAIRS = BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P();
    public IBlockState BETWEENSTONE_BRICK_SLAB_UPPER = BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    public IBlockState BETWEENSTONE_BRICK_SLAB_LOWER = BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM));
    public IBlockState BETWEENSTONE_PILLAR = BlockRegistry.BETWEENSTONE_PILLAR.func_176223_P();
    public IBlockState BETWEENSTONE_TILES = BlockRegistry.BETWEENSTONE_TILES.func_176223_P();
    public IBlockState SMOOTH_PITSTONE = BlockRegistry.SMOOTH_PITSTONE.func_176223_P();
    public IBlockState SMOOTH_PITSTONE_STAIRS = BlockRegistry.SMOOTH_PITSTONE_STAIRS.func_176223_P();
    public IBlockState SMOOTH_PITSTONE_SLAB_UPPER = BlockRegistry.SMOOTH_PITSTONE_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    public IBlockState SMOOTH_PITSTONE_SLAB_LOWER = BlockRegistry.SMOOTH_PITSTONE_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM));
    public IBlockState PITSTONE_BRICKS = BlockRegistry.PITSTONE_BRICKS.func_176223_P();
    public IBlockState PITSTONE_BRICK_STAIRS = BlockRegistry.PITSTONE_BRICK_STAIRS.func_176223_P();
    public IBlockState PITSTONE_BRICK_SLAB_UPPER = BlockRegistry.PITSTONE_BRICK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    public IBlockState PITSTONE_BRICK_SLAB_LOWER = BlockRegistry.PITSTONE_BRICK_SLAB.func_176223_P().func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM));
    public IBlockState PITSTONE_PILLAR = BlockRegistry.PITSTONE_PILLAR.func_176223_P();
    public IBlockState PITSTONE_TILES = BlockRegistry.PITSTONE_TILES.func_176223_P();
    public IBlockState PITSTONE_CHISELED = BlockRegistry.PITSTONE_CHISELED.func_176223_P();
    public IBlockState SCABYST_PITSTONE_DOTTED = BlockRegistry.SCABYST_PITSTONE_DOTTED.func_176223_P();
    public IBlockState SCABYST_PITSTONE_HORIZONTAL = BlockRegistry.SCABYST_PITSTONE_HORIZONTAL.func_176223_P();
    public IBlockState ENERGY_BARRIER_MUD = BlockRegistry.ENERGY_BARRIER_MUD.func_176223_P();
    public IBlockState DIAGONAL_ENERGY_BARRIER = BlockRegistry.DIAGONAL_ENERGY_BARRIER.func_176223_P();
    public IBlockState MUD_TOWER_BEAM_ORIGIN = BlockRegistry.MUD_TOWER_BEAM_ORIGIN.func_176223_P();
    public IBlockState MUD_TOWER_BEAM_RELAY = BlockRegistry.MUD_TOWER_BEAM_RELAY.func_176223_P();
    public IBlockState MUD_TOWER_BEAM_TUBE = BlockRegistry.MUD_TOWER_BEAM_TUBE.func_176223_P();
    public IBlockState MUD_TOWER_BEAM_LENS_SUPPORTS = BlockRegistry.MUD_TOWER_BEAM_LENS_SUPPORTS.func_176223_P();
    public IBlockState BRAZIER_TOP = BlockRegistry.MUD_TOWER_BRAZIER.func_176223_P().func_177226_a(BlockBrazier.HALF, (Comparable)((Object)BlockBrazier.EnumBrazierHalf.UPPER));
    public IBlockState BRAZIER_BOTTOM = BlockRegistry.MUD_TOWER_BRAZIER.func_176223_P().func_177226_a(BlockBrazier.HALF, (Comparable)((Object)BlockBrazier.EnumBrazierHalf.LOWER));
    public IBlockState COMPACTED_MUD_MIRAGE = BlockRegistry.COMPACTED_MUD_MIRAGE.func_176223_P();
    public IBlockState COMPACTED_MUD_SLAB = BlockRegistry.COMPACTED_MUD_SLAB.func_176223_P();
    public IBlockState GROUND_ITEM = BlockRegistry.GROUND_ITEM.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_1 = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_1.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_2 = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_2.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK_DIAGONAL = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_DIAGONAL.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_1 = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_1.func_176223_P();
    public IBlockState DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_2 = BlockRegistry.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_2.func_176223_P();
    public final Map<IBlockState, Boolean> STRUCTURE_BLOCKS = new HashMap<IBlockState, Boolean>();
    private final WorldGenSludgeWormDungeon dungeon;

    public SludgeWormMazeBlockHelper(WorldGenSludgeWormDungeon dungeon) {
        this.initStuctureBlockMap();
        this.dungeon = dungeon;
    }

    @Nullable
    public IBlockState getMudBricksForLevel(Random rand, int level, int layer) {
        switch (level) {
            case 0: {
                if (layer == 1) {
                    return this.MUD_BRICKS;
                }
                if (layer == 2) {
                    return this.MUD_BRICKS_CARVED;
                }
                if (layer == 3) {
                    return this.MUD_BRICKS_CARVED_EDGE;
                }
            }
            case 1: {
                if (layer == 1) {
                    return rand.nextBoolean() ? this.MUD_BRICKS : this.MUD_BRICKS_DECAY_1;
                }
                if (layer == 2) {
                    return this.MUD_BRICKS_CARVED;
                }
                if (layer == 3) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_EDGE : this.MUD_BRICKS_CARVED_EDGE_DECAY_1;
                }
            }
            case 2: {
                if (layer == 1) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_DECAY_1 : this.MUD_BRICKS_DECAY_2;
                }
                if (layer == 2) {
                    return this.MUD_BRICKS_CARVED;
                }
                if (layer == 3) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_EDGE_DECAY_1 : this.MUD_BRICKS_CARVED_EDGE_DECAY_2;
                }
            }
            case 3: {
                if (layer == 1) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_DECAY_2 : this.MUD_BRICKS_DECAY_3;
                }
                if (layer == 2) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED : this.MUD_BRICKS_CARVED_DECAY_1;
                }
                if (layer == 3) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_EDGE_DECAY_2 : this.MUD_BRICKS_CARVED_EDGE_DECAY_3;
                }
            }
            case 4: {
                if (layer == 1) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_DECAY_3 : this.MUD_BRICKS_DECAY_4;
                }
                if (layer == 2) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_DECAY_1 : this.MUD_BRICKS_CARVED_DECAY_2;
                }
                if (layer == 3) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_EDGE_DECAY_3 : this.MUD_BRICKS_CARVED_EDGE_DECAY_4;
                }
            }
            case 5: {
                if (layer == 1) {
                    return this.MUD_BRICKS_DECAY_4;
                }
                if (layer == 2) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_DECAY_1 : (rand.nextBoolean() ? this.MUD_BRICKS_CARVED_DECAY_2 : this.MUD_BRICKS_CARVED_DECAY_3);
                }
                if (layer == 3) {
                    return this.MUD_BRICKS_CARVED_EDGE_DECAY_4;
                }
            }
            case 6: {
                if (layer == 1) {
                    return this.MUD_BRICKS_DECAY_4;
                }
                if (layer == 2) {
                    return rand.nextBoolean() ? this.MUD_BRICKS_CARVED_DECAY_2 : (rand.nextBoolean() ? this.MUD_BRICKS_CARVED_DECAY_3 : this.MUD_BRICKS_CARVED_DECAY_4);
                }
                if (layer == 3) {
                    return this.MUD_BRICKS_CARVED_EDGE_DECAY_4;
                }
            }
            case 7: {
                if (layer == 1) {
                    return this.MUD_BRICKS_DECAY_4;
                }
                if (layer == 2) {
                    return this.MUD_BRICKS_CARVED_DECAY_4;
                }
                if (layer != 3) break;
                return this.MUD_BRICKS_CARVED_EDGE_DECAY_4;
            }
        }
        return this.MUD_BRICKS;
    }

    @Nullable
    public IBlockState getMudSlabsForLevel(Random rand, int level, BlockSlabBetweenlands.EnumBlockHalfBL half) {
        IBlockState state = this.MUD_BRICK_SLAB;
        switch (level) {
            case 0: {
                state = this.MUD_BRICK_SLAB;
                break;
            }
            case 1: {
                state = rand.nextBoolean() ? this.MUD_BRICK_SLAB : this.MUD_BRICK_SLAB_DECAY_1;
                break;
            }
            case 2: {
                state = this.MUD_BRICK_SLAB_DECAY_1;
                break;
            }
            case 3: {
                state = rand.nextBoolean() ? this.MUD_BRICK_SLAB_DECAY_1 : this.MUD_BRICK_SLAB_DECAY_2;
                break;
            }
            case 4: {
                state = this.MUD_BRICK_SLAB_DECAY_2;
                break;
            }
            case 5: {
                state = rand.nextBoolean() ? this.MUD_BRICK_SLAB_DECAY_2 : this.MUD_BRICK_SLAB_DECAY_3;
                break;
            }
            case 6: 
            case 7: {
                state = this.MUD_BRICK_SLAB_DECAY_3;
            }
        }
        return state.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)half));
    }

    @Nullable
    public IBlockState getPillarsForLevel(Random rand, int level, int layer) {
        switch (level) {
            case 0: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP;
                }
            }
            case 1: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_1;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_1;
                }
            }
            case 2: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_2;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_2;
                }
            }
            case 3: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_3;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_1;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_3;
                }
            }
            case 4: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_4;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_2;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_4;
                }
            }
            case 5: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_FULL;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_3;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_4;
                }
            }
            case 6: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_FULL;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_4;
                }
                if (layer == 3) {
                    return this.WORM_DUNGEON_PILLAR_TOP_DECAY_FULL;
                }
            }
            case 7: {
                if (layer == 1) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_FULL;
                }
                if (layer == 2) {
                    return this.WORM_DUNGEON_PILLAR_DECAY_4;
                }
                if (layer != 3) break;
                return this.WORM_DUNGEON_PILLAR_TOP_DECAY_FULL;
            }
        }
        return this.WORM_DUNGEON_PILLAR;
    }

    @Nullable
    public IBlockState getTilesForLevel(Random rand, int level) {
        int type = rand.nextInt(8);
        switch (level) {
            case 0: {
                if (type == 0) {
                    return this.MUD_TILES_CRACKED;
                }
                return this.MUD_TILES;
            }
            case 1: {
                if (type == 0 || type == 1) {
                    return this.MUD_TILES_CRACKED;
                }
                if (type == 2) {
                    return this.MUD_TILES_DECAY;
                }
                return this.MUD_TILES;
            }
            case 2: {
                if (type == 0 || type == 1) {
                    return this.MUD_TILES_DECAY;
                }
                if (type == 2) {
                    return this.MUD_TILES_CRACKED_DECAY;
                }
                return this.MUD_TILES;
            }
            case 3: {
                if (type == 0 || type == 1) {
                    return this.MUD_TILES_DECAY;
                }
                if (type == 2 || type == 3) {
                    return this.MUD_TILES_CRACKED_DECAY;
                }
                if (type == 4) {
                    return this.MUD_TILES_CRACKED;
                }
                return this.MUD_TILES;
            }
            case 4: {
                if (type == 0 || type == 1 || type == 2) {
                    return this.MUD_TILES_DECAY;
                }
                if (type == 3 || type == 4) {
                    return this.MUD_TILES_CRACKED;
                }
                if (type == 5) {
                    return this.MUD_TILES_CRACKED_DECAY;
                }
                return this.MUD_TILES;
            }
            case 5: {
                if (type == 0 || type == 1 || type == 2) {
                    return this.MUD_TILES_DECAY;
                }
                if (type == 3 || type == 4) {
                    return this.MUD_TILES_CRACKED_DECAY;
                }
                if (type == 5) {
                    return this.MUD_TILES_CRACKED;
                }
                return this.MUD_TILES;
            }
            case 6: {
                if (type == 0 || type == 1) {
                    return this.MUD_TILES_CRACKED_DECAY;
                }
                if (type == 3) {
                    return this.MUD_TILES_CRACKED;
                }
                return this.MUD_TILES_DECAY;
            }
            case 7: {
                return this.MUD_BRICKS;
            }
        }
        return this.MUD_BRICKS;
    }

    @Nullable
    public IBlockState getStairsForLevel(Random rand, int level, EnumFacing facing, BlockStairs.EnumHalf half) {
        IBlockState state = this.MUD_BRICK_STAIRS;
        int type = rand.nextInt(3);
        switch (level) {
            case 0: {
                state = this.MUD_BRICK_STAIRS;
                break;
            }
            case 1: {
                if (type == 0 || type == 1) {
                    state = this.MUD_BRICK_STAIRS;
                }
                if (type != 2) break;
                state = this.MUD_BRICK_STAIRS_DECAY_1;
                break;
            }
            case 2: {
                if (type == 0) {
                    state = this.MUD_BRICK_STAIRS;
                }
                if (type == 1) {
                    state = this.MUD_BRICK_STAIRS_DECAY_1;
                }
                if (type != 2) break;
                state = this.MUD_BRICK_STAIRS_DECAY_2;
                break;
            }
            case 3: {
                if (type == 0 || type == 1) {
                    state = this.MUD_BRICK_STAIRS_DECAY_1;
                }
                if (type != 2) break;
                state = this.MUD_BRICK_STAIRS_DECAY_2;
                break;
            }
            case 4: {
                if (type == 0) {
                    state = this.MUD_BRICK_STAIRS_DECAY_1;
                }
                if (type == 1) {
                    state = this.MUD_BRICK_STAIRS_DECAY_2;
                }
                if (type != 2) break;
                state = this.MUD_BRICK_STAIRS_DECAY_3;
                break;
            }
            case 5: {
                if (type == 0 || type == 1) {
                    state = this.MUD_BRICK_STAIRS_DECAY_2;
                }
                if (type != 2) break;
                state = this.MUD_BRICK_STAIRS_DECAY_3;
                break;
            }
            case 6: 
            case 7: {
                state = this.MUD_BRICK_STAIRS_DECAY_3;
            }
        }
        return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)half);
    }

    public IBlockState getRandomBeam(EnumFacing facing, Random rand, int level, int count, boolean randomiseLine) {
        IBlockState state = this.LOG_ROTTEN_BARK_CARVED_1;
        if (randomiseLine) {
            count = rand.nextInt(6);
        }
        if (count == 1 || count == 3) {
            int endType = rand.nextInt(6);
            switch (endType) {
                case 0: {
                    state = this.LOG_ROTTEN_BARK_CARVED_11;
                    break;
                }
                case 1: {
                    state = this.LOG_ROTTEN_BARK_CARVED_12;
                    break;
                }
                case 2: {
                    state = this.LOG_ROTTEN_BARK_CARVED_13;
                    break;
                }
                case 3: {
                    state = this.LOG_ROTTEN_BARK_CARVED_14;
                    break;
                }
                case 4: {
                    state = this.LOG_ROTTEN_BARK_CARVED_15;
                    break;
                }
                case 5: {
                    state = this.LOG_ROTTEN_BARK_CARVED_16;
                }
            }
        } else {
            int midType = rand.nextInt(10);
            switch (midType) {
                case 0: {
                    state = this.LOG_ROTTEN_BARK_CARVED_1;
                    break;
                }
                case 1: {
                    state = this.LOG_ROTTEN_BARK_CARVED_2;
                    break;
                }
                case 2: {
                    state = this.LOG_ROTTEN_BARK_CARVED_3;
                    break;
                }
                case 3: {
                    state = this.LOG_ROTTEN_BARK_CARVED_4;
                    break;
                }
                case 4: {
                    state = this.LOG_ROTTEN_BARK_CARVED_5;
                    break;
                }
                case 5: {
                    state = this.LOG_ROTTEN_BARK_CARVED_6;
                    break;
                }
                case 6: {
                    state = this.LOG_ROTTEN_BARK_CARVED_7;
                    break;
                }
                case 7: {
                    state = this.LOG_ROTTEN_BARK_CARVED_8;
                    break;
                }
                case 8: {
                    state = this.LOG_ROTTEN_BARK_CARVED_9;
                    break;
                }
                case 9: {
                    state = this.LOG_ROTTEN_BARK_CARVED_10;
                }
            }
        }
        return state.func_177226_a((IProperty)BlockRottenBarkCarved.FACING, (Comparable)facing);
    }

    public IBlockState getRandomSupportBeam(EnumFacing facing, boolean isTop, Random rand) {
        IBlockState state = this.WOODEN_SUPPORT_BEAM_ROTTEN_1;
        int type = rand.nextInt(3);
        if (type == 0) {
            state = this.WOODEN_SUPPORT_BEAM_ROTTEN_1;
        }
        if (type == 1) {
            state = this.WOODEN_SUPPORT_BEAM_ROTTEN_2;
        }
        if (type == 2) {
            state = this.WOODEN_SUPPORT_BEAM_ROTTEN_3;
        }
        return state.func_177226_a((IProperty)BlockWoodenSupportBeam.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockWoodenSupportBeam.TOP, (Comparable)Boolean.valueOf(isTop));
    }

    public IBlockState getRandomLitCandle(Random rand) {
        return this.MUD_FLOWER_POT_CANDLE_UNLIT;
    }

    public IBlockState getRandomMushroom(Random rand) {
        int type = rand.nextInt(30);
        if (type < 10) {
            return this.FLAT_HEAD_MUSHROOM;
        }
        if (type < 20) {
            return this.BLACK_HAT_MUSHROOM;
        }
        return this.ROTBULB;
    }

    public IBlockState getRandomFloorPlant(Random rand) {
        return rand.nextBoolean() ? this.TALL_SLUDGECREEP : this.PALE_GRASS;
    }

    public IBlockState getRandomHangingPlant(Random rand) {
        return rand.nextBoolean() ? this.CRYPTWEED : this.STRING_ROOTS;
    }

    public IBlockState getRandomEdgePlant(Random rand, EnumFacing facing) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.EDGE_SHROOM.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
            case 1: {
                return this.EDGE_MOSS.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
            case 2: {
                return this.EDGE_LEAF.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
        }
        return this.EDGE_SHROOM.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
    }

    public IBlockState getMudTilesWater(Random rand) {
        int randDirection = rand.nextInt(4);
        IBlockState state = this.MUD_TILES_WATER;
        switch (randDirection) {
            case 0: {
                state = this.MUD_TILES_WATER.func_177226_a((IProperty)BlockMudTilesWater.FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 1: {
                state = this.MUD_TILES_WATER.func_177226_a((IProperty)BlockMudTilesWater.FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 2: {
                state = this.MUD_TILES_WATER.func_177226_a((IProperty)BlockMudTilesWater.FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                state = this.MUD_TILES_WATER.func_177226_a((IProperty)BlockMudTilesWater.FACING, (Comparable)EnumFacing.EAST);
            }
        }
        return state;
    }

    public void setRandomRoot(World world, BlockPos pos, Random rand) {
        if (!this.isSolidStructureBlock(world.func_180495_p(pos)) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockMudTiles) {
            int rnd = rand.nextInt(32);
            if (rnd < 8) {
                this.dungeon.func_175903_a(world, pos, this.ROOT);
            } else if (rnd < 16) {
                this.dungeon.func_175903_a(world, pos, this.ROOT);
                if (world.func_175623_d(pos.func_177981_b(1))) {
                    this.dungeon.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
                }
            } else if (rnd < 24) {
                this.dungeon.func_175903_a(world, pos, this.ROOT);
                if (world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2))) {
                    this.dungeon.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
                    this.dungeon.func_175903_a(world, pos.func_177981_b(2), this.ROOT);
                }
            } else {
                this.dungeon.func_175903_a(world, pos, this.ROOT);
                if (world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3))) {
                    this.dungeon.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
                    this.dungeon.func_175903_a(world, pos.func_177981_b(2), this.ROOT);
                    this.dungeon.func_175903_a(world, pos.func_177981_b(3), this.ROOT);
                }
            }
        }
    }

    public IBlockState getRandomLootUrn(Random rand, EnumFacing facing) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.LOOT_URN_1.func_177226_a((IProperty)BlockLootUrn.FACING, (Comparable)facing);
            }
            case 1: {
                return this.LOOT_URN_2.func_177226_a((IProperty)BlockLootUrn.FACING, (Comparable)facing);
            }
            case 2: {
                return this.LOOT_URN_3.func_177226_a((IProperty)BlockLootUrn.FACING, (Comparable)facing);
            }
        }
        return this.LOOT_URN_1.func_177226_a((IProperty)BlockLootUrn.FACING, (Comparable)facing);
    }

    public void setGreatSword(World world, Random rand, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGroundItem) {
            ((TileEntityGroundItem)tile).setStack(new ItemStack(ItemRegistry.ANCIENT_GREATSWORD));
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        }
    }

    public void setBattleAxe(World world, Random rand, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGroundItem) {
            ((TileEntityGroundItem)tile).setStack(new ItemStack(ItemRegistry.ANCIENT_BATTLE_AXE));
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        }
    }

    public void placeArmourStandLoot(World world, BlockPos pos, EnumFacing facing, Random rand) {
        ItemStack helm = new ItemStack(ItemRegistry.ANCIENT_HELMET);
        ItemStack chest = new ItemStack(ItemRegistry.ANCIENT_CHESTPLATE);
        ItemStack legs = new ItemStack(ItemRegistry.ANCIENT_LEGGINGS);
        ItemStack boots = new ItemStack(ItemRegistry.ANCIENT_BOOTS);
        EntityArmorStand stand = new EntityArmorStand(world);
        stand.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, facing.func_185119_l(), 0.0f);
        stand.func_184201_a(EntityEquipmentSlot.HEAD, helm);
        stand.func_184201_a(EntityEquipmentSlot.CHEST, chest);
        stand.func_184201_a(EntityEquipmentSlot.LEGS, legs);
        stand.func_184201_a(EntityEquipmentSlot.FEET, boots);
        world.func_72838_d((Entity)stand);
    }

    @Nullable
    public IBlockState getStairsForTowerLevel(Random rand, int level, EnumFacing facing, BlockStairs.EnumHalf half, boolean bricks) {
        IBlockState state = this.SMOOTH_PITSTONE_STAIRS;
        if (bricks) {
            state = this.PITSTONE_BRICK_STAIRS;
        }
        return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)facing).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)half);
    }

    @Nullable
    public IBlockState getEnergyBarrier(boolean flipped) {
        return this.DIAGONAL_ENERGY_BARRIER.func_177226_a((IProperty)BlockDiagonalEnergyBarrier.FLIPPED, (Comparable)Boolean.valueOf(flipped));
    }

    public boolean isSolidStructureBlock(IBlockState state) {
        return this.STRUCTURE_BLOCKS.get(state) != null;
    }

    private void initStuctureBlockMap() {
        if (this.STRUCTURE_BLOCKS.isEmpty()) {
            this.STRUCTURE_BLOCKS.put(this.COMPACTED_MUD, true);
            this.STRUCTURE_BLOCKS.put(this.ROTTEN_BARK, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_SLAB, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_SLAB_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_SLAB_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_SLAB_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.COMPACTED_MUD, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_DECAY_4, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_DECAY_4, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_EDGE, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_EDGE_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_EDGE_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_EDGE_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CARVED_EDGE_DECAY_4, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_STAIRS, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_STAIRS_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_STAIRS_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_STAIRS_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP_DECAY_4, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_TOP_DECAY_FULL, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_DECAY_1, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_DECAY_2, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_DECAY_3, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_DECAY_4, true);
            this.STRUCTURE_BLOCKS.put(this.WORM_DUNGEON_PILLAR_DECAY_FULL, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_TILES, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_TILES_DECAY, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_TILES_CRACKED, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_TILES_CRACKED_DECAY, true);
            this.STRUCTURE_BLOCKS.put(this.ROOT, true);
            this.STRUCTURE_BLOCKS.put(this.DUNGEON_DOOR_COMBINATION_EAST, true);
            this.STRUCTURE_BLOCKS.put(this.DUNGEON_DOOR_COMBINATION_WEST, true);
            this.STRUCTURE_BLOCKS.put(this.DUNGEON_DOOR_EAST, true);
            this.STRUCTURE_BLOCKS.put(this.DUNGEON_DOOR_WEST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_ALCOVE_NORTH, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_ALCOVE_EAST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_ALCOVE_SOUTH, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_ALCOVE_WEST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CLIMBABLE_NORTH, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CLIMBABLE_EAST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CLIMBABLE_SOUTH, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_CLIMBABLE_WEST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_FLOWER_POT_CANDLE_LIT, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_FLOWER_POT_CANDLE_UNLIT, true);
            this.STRUCTURE_BLOCKS.put(this.LOOT_URN_1, true);
            this.STRUCTURE_BLOCKS.put(this.LOOT_URN_2, true);
            this.STRUCTURE_BLOCKS.put(this.LOOT_URN_3, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICK_WALL, true);
            this.STRUCTURE_BLOCKS.put(this.ITEM_SHELF, true);
            this.STRUCTURE_BLOCKS.put(this.WOODEN_SUPPORT_BEAM_ROTTEN_1, true);
            this.STRUCTURE_BLOCKS.put(this.WOODEN_SUPPORT_BEAM_ROTTEN_2, true);
            this.STRUCTURE_BLOCKS.put(this.WOODEN_SUPPORT_BEAM_ROTTEN_3, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_1, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_2, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_3, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_4, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_5, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_6, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_7, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_8, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_9, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_10, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_11, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_12, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_13, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_14, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_15, true);
            this.STRUCTURE_BLOCKS.put(this.LOG_ROTTEN_BARK_CARVED_16, true);
            this.STRUCTURE_BLOCKS.put(this.CHEST, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_BRICKS_SPIKE_TRAP, true);
            this.STRUCTURE_BLOCKS.put(this.MUD_TILES_SPIKE_TRAP, true);
        }
    }
}

