/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.hwyla;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidRegistry;
import thebetweenlands.common.block.plant.BlockStackablePlantUnderwater;
import thebetweenlands.common.registries.ItemRegistry;

public class UnderwaterPlantProvider
implements IWailaDataProvider {
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (block instanceof BlockStackablePlantUnderwater) {
            List<ItemStack> stacks = ((BlockStackablePlantUnderwater)block).onSheared(new ItemStack(ItemRegistry.SYRMORITE_SHEARS), (IBlockAccess)accessor.getWorld(), accessor.getPosition(), 0);
            if (!stacks.isEmpty()) {
                return stacks.get(0);
            }
            ItemStack pickBlock = block.getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
            if (!pickBlock.func_190926_b()) {
                return pickBlock;
            }
            Item item = block.func_180660_a(accessor.getBlockState(), accessor.getWorld().field_73012_v, 0);
            if (item != null) {
                return new ItemStack(item);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        tooltip.clear();
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            String name = null;
            String displayName = DisplayUtil.itemDisplayNameShort((ItemStack)itemStack);
            if (displayName != null && !displayName.endsWith("Unnamed")) {
                name = displayName;
            }
            if (name != null) {
                tooltip.add(name);
            }
            if (ConfigHandler.instance().getConfig("general", "waila.cfg.metadata", true) && !Strings.isNullOrEmpty((String)FormattingConfig.metaFormat)) {
                tooltip.add("\u00a7r" + String.format(FormattingConfig.metaFormat, accessor.getBlock().getRegistryName().toString(), accessor.getMetadata()));
            }
        }
        return tooltip;
    }
}

