/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.RenderWallHole;
import thebetweenlands.client.render.model.entity.ModelBlank;
import thebetweenlands.common.entity.mobs.EntityWallLivingRoot;

@SideOnly(value=Side.CLIENT)
public class RenderWallLivingRoot
extends RenderWallHole<EntityWallLivingRoot> {
    private static final ResourceLocation ROOT_TEXTURE = new ResourceLocation("thebetweenlands", "textures/blocks/root_middle.png");
    protected static final ModelBase BLANK_MODEL = new ModelBlank();

    public RenderWallLivingRoot(RenderManager renderManager) {
        super(renderManager, BLANK_MODEL, ROOT_TEXTURE);
    }

    protected RenderWallLivingRoot(RenderManager renderManager, ResourceLocation armTexture) {
        super(renderManager, BLANK_MODEL, armTexture);
    }

    @Override
    protected void preRenderCallback(EntityWallLivingRoot entity, float partialTickTime) {
        super.preRenderCallback(entity, partialTickTime);
    }

    @Override
    protected void renderEntityModel(EntityWallLivingRoot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float partialTicks) {
        if (this.field_77045_g == BLANK_MODEL) {
            this.renderRootModel(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, partialTicks);
        } else {
            super.renderEntityModel(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, partialTicks);
        }
    }

    protected void renderRootModel(EntityWallLivingRoot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, float partialTicks) {
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.501f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-entity.field_70130_N / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)(-(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.field_70130_N / 2.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(-(180.0f - entity.field_70761_aq)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBodyHull(entity, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected float getUvScale(EntityWallLivingRoot entity, float partialTicks) {
        return 2.0f;
    }

    protected float calculateHullContraction(EntityWallLivingRoot entity, int i, float armSize, float partialTicks) {
        return (1.0f - (float)i / (float)(entity.armSegments.size() - 1)) * armSize;
    }

    protected void renderBodyHull(EntityWallLivingRoot entity, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181703_c);
        float uOffset = 0.0f;
        int i = 0;
        float armSize = entity.getArmSize(partialTicks);
        float uvScale = this.getUvScale(entity, partialTicks) / Math.max(0.001f, armSize);
        double pos1X = 0.0;
        double pos1Y = 0.0;
        double pos1Z = 0.0;
        EntityWallLivingRoot.ArmSegment segment1 = null;
        for (EntityWallLivingRoot.ArmSegment segment2 : entity.armSegments) {
            Vec3d pos = segment2.pos;
            Vec3d prevPos = segment2.prevPos;
            double pos2X = RenderWallLivingRoot.lerp(prevPos.field_72450_a, pos.field_72450_a, partialTicks);
            double pos2Y = RenderWallLivingRoot.lerp(prevPos.field_72448_b, pos.field_72448_b, partialTicks);
            double pos2Z = RenderWallLivingRoot.lerp(prevPos.field_72449_c, pos.field_72449_c, partialTicks);
            if (segment1 != null) {
                float maxUW = 0.0f;
                int hullVerts = Math.min(segment1.offsetX.length, segment2.offsetX.length);
                for (int vertIndex = 0; vertIndex < hullVerts; ++vertIndex) {
                    int nextVertIndex = (vertIndex + 1) % hullVerts;
                    float contraction1 = this.calculateHullContraction(entity, i - 1, armSize, partialTicks);
                    float contraction2 = this.calculateHullContraction(entity, i, armSize, partialTicks);
                    double v11x = pos1X + (double)(segment1.offsetX[vertIndex] * contraction1);
                    double v11y = pos1Y + (double)(segment1.offsetY[vertIndex] * contraction1);
                    double v11z = pos1Z + (double)(segment1.offsetZ[vertIndex] * contraction1);
                    double v12x = pos1X + (double)(segment1.offsetX[nextVertIndex] * contraction1);
                    double v12y = pos1Y + (double)(segment1.offsetY[nextVertIndex] * contraction1);
                    double v12z = pos1Z + (double)(segment1.offsetZ[nextVertIndex] * contraction1);
                    double v21x = pos2X + (double)(segment2.offsetX[vertIndex] * contraction2);
                    double v21y = pos2Y + (double)(segment2.offsetY[vertIndex] * contraction2);
                    double v21z = pos2Z + (double)(segment2.offsetZ[vertIndex] * contraction2);
                    double v22x = pos2X + (double)(segment2.offsetX[nextVertIndex] * contraction2);
                    double v22y = pos2Y + (double)(segment2.offsetY[nextVertIndex] * contraction2);
                    double v22z = pos2Z + (double)(segment2.offsetZ[nextVertIndex] * contraction2);
                    float uw1 = RenderWallLivingRoot.dist(v12x, v12y, v12z, v11x, v11y, v11z) * 0.5f * uvScale;
                    float vw1 = RenderWallLivingRoot.dist(v21x, v21y, v21z, v11x, v11y, v11z) * uvScale;
                    float uw2 = RenderWallLivingRoot.dist(v22x, v22y, v22z, v21x, v21y, v21z) * 0.5f * uvScale;
                    float vw2 = RenderWallLivingRoot.dist(v22x, v22y, v22z, v12x, v12y, v12z) * uvScale;
                    float uw = Math.max(uw1, uw2);
                    float vw = Math.max(vw1, vw2);
                    float d1x = (float)(v21x - v12x);
                    float d1y = (float)(v21y - v12y);
                    float d1z = (float)(v21z - v12z);
                    float d2x = (float)(v22x - v11x);
                    float d2y = (float)(v22y - v11y);
                    float d2z = (float)(v22z - v11z);
                    float nx = d1y * d2z - d1z * d2y;
                    float ny = d1z * d2x - d1x * d2z;
                    float nz = d1x * d2y - d1y * d2x;
                    float len = RenderWallLivingRoot.len(nx, ny, nz);
                    float us = uOffset;
                    float vs = 0.0f;
                    bufferBuilder.func_181662_b(v11x, v11y, v11z).func_187315_a((double)us, (double)vs).func_181663_c(nx /= len, ny /= len, nz /= len).func_181675_d();
                    bufferBuilder.func_181662_b(v21x, v21y, v21z).func_187315_a((double)us, (double)(vs + vw)).func_181663_c(nx, ny, nz).func_181675_d();
                    bufferBuilder.func_181662_b(v22x, v22y, v22z).func_187315_a((double)(us + uw), (double)(vs + vw)).func_181663_c(nx, ny, nz).func_181675_d();
                    bufferBuilder.func_181662_b(v12x, v12y, v12z).func_187315_a((double)(us + uw), (double)vs).func_181663_c(nx, ny, nz).func_181675_d();
                    maxUW = Math.max(maxUW, uw);
                }
                uOffset += maxUW;
            }
            segment1 = segment2;
            pos1X = pos2X;
            pos1Y = pos2Y;
            pos1Z = pos2Z;
            ++i;
        }
        tessellator.func_78381_a();
    }

    protected static float dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return RenderWallLivingRoot.len(x2 - x1, y2 - y1, z2 - z1);
    }

    protected static float len(double x, double y, double z) {
        return MathHelper.func_76133_a((double)(x * x + y * y + z * z));
    }

    protected static double lerp(double start, double end, float delta) {
        return start + (end - start) * (double)delta;
    }

    @Override
    protected TextureAtlasSprite getWallSprite(EntityWallLivingRoot entity) {
        return entity.getWallSprite();
    }

    @Override
    protected float getHoleDepthPercent(EntityWallLivingRoot entity, float partialTicks) {
        return entity.getHoleDepthPercent(partialTicks);
    }

    @Override
    protected float getMainModelVisibilityPercent(EntityWallLivingRoot entity, float partialTicks) {
        return entity.getHoleDepthPercent(partialTicks);
    }
}

