/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity.layer;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class LayerOverlay<T extends EntityLivingBase>
implements LayerRenderer<T> {
    public final RenderLivingBase<T> renderer;
    public final ResourceLocation texture;
    private boolean glow;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float alpha = 1.0f;

    public LayerOverlay(RenderLivingBase<T> renderer) {
        this(renderer, null);
    }

    public LayerOverlay(RenderLivingBase<T> renderer, ResourceLocation texture) {
        this.renderer = renderer;
        this.texture = texture;
    }

    public void func_177141_a(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        int index = 0;
        for (ModelBase model : this.getModels(entity)) {
            ResourceLocation texture = this.getTexture(entity, index);
            if (texture != null) {
                this.renderer.func_110776_a(texture);
                float alpha = this.getAlpha();
                float red = this.getRed();
                float green = this.getGreen();
                float blue = this.getBlue();
                LayerOverlay.renderOverlay(entity, () -> this.renderOverlay(entity, model, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale), this.getGlow(), red, green, blue, alpha);
            }
            ++index;
        }
    }

    public static void renderOverlay(@Nullable Entity entity, Runnable renderer, boolean glow, float red, float green, float blue, float alpha) {
        GlStateManager.func_179136_a((float)-0.01f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        if (glow) {
            int i = 61680;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179140_f();
        }
        renderer.run();
        if (glow) {
            GlStateManager.func_179132_a((entity == null || !entity.func_82150_aj() ? 1 : 0) != 0);
            GlStateManager.func_179131_c((float)(red * alpha), (float)(green * alpha), (float)(blue * alpha), (float)alpha);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            renderer.run();
            if (entity != null) {
                LayerOverlay.setLightmap(entity);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
    }

    protected void renderOverlay(T entity, ModelBase model, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
        model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        model.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    @Nullable
    protected ResourceLocation getTexture(T entity, int model) {
        return this.texture;
    }

    protected ModelBase[] getModels(T entity) {
        return new ModelBase[]{this.renderer.func_177087_b()};
    }

    public boolean func_177142_b() {
        return false;
    }

    protected static void setLightmap(Entity entity) {
        int i = entity.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    public LayerOverlay<T> setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public LayerOverlay<T> setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    public LayerOverlay<T> setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b);
        this.setAlpha(a);
        return this;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public LayerOverlay<T> setGlow(boolean glow) {
        this.glow = glow;
        return this;
    }

    public boolean getGlow() {
        return this.glow;
    }
}

