/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import thebetweenlands.common.block.terrain.BlockStalactite;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StalactiteHelper;
import thebetweenlands.util.StatePropertyHelper;

public class ModelStalactite
implements IModel {
    public static final ResourceLocation TEXTURE_TOP = new ResourceLocation("thebetweenlands", "blocks/stalactite_top");
    public static final ResourceLocation TEXTURE_MIDDLE = new ResourceLocation("thebetweenlands", "blocks/stalactite_middle");
    public static final ResourceLocation TEXTURE_BOTTOM = new ResourceLocation("thebetweenlands", "blocks/stalactite_bottom");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.unmodifiableCollection(Arrays.asList(TEXTURE_TOP, TEXTURE_MIDDLE, TEXTURE_BOTTOM));
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new ModelBakedStalactite(format, bakedTextureGetter.apply(TEXTURE_TOP), bakedTextureGetter.apply(TEXTURE_MIDDLE), bakedTextureGetter.apply(TEXTURE_BOTTOM));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class ModelBakedStalactite
    implements IBakedModel {
        private final VertexFormat format;
        private final TextureAtlasSprite textureTop;
        private final TextureAtlasSprite textureMiddle;
        private final TextureAtlasSprite textureBottom;

        private ModelBakedStalactite(VertexFormat format, TextureAtlasSprite textureTop, TextureAtlasSprite textureMiddle, TextureAtlasSprite textureBottom) {
            this.format = format;
            this.textureTop = textureTop;
            this.textureMiddle = textureMiddle;
            this.textureBottom = textureBottom;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (side == null) {
                boolean hasBottom;
                float distToMidTop;
                float distToMidBottom;
                double halfTotalHeightSQ;
                int distUp = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.DIST_UP).orElse(0);
                int distDown = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.DIST_DOWN).orElse(0);
                boolean noTop = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.NO_TOP).orElse(true);
                boolean noBottom = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.NO_BOTTOM).orElse(true);
                int posX = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.POS_X).orElse(0);
                int posY = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.POS_Y).orElse(0);
                int posZ = StatePropertyHelper.getPropertyOptional(state, BlockStalactite.POS_Z).orElse(0);
                float height = 1.0f;
                int totalHeight = 1 + distDown + distUp;
                double squareAmount = 1.2;
                if (noTop) {
                    halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                    distToMidBottom = Math.abs(distUp + 1);
                    distToMidTop = Math.abs(distUp);
                } else if (noBottom) {
                    halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                    distToMidBottom = Math.abs(distDown);
                    distToMidTop = Math.abs(distDown + 1);
                } else {
                    float halfTotalHeight = (float)totalHeight * 0.5f;
                    halfTotalHeightSQ = Math.pow(halfTotalHeight, squareAmount);
                    distToMidBottom = Math.abs(halfTotalHeight - (float)distUp - 1.0f);
                    distToMidTop = Math.abs(halfTotalHeight - (float)distUp);
                }
                int minValBottom = noBottom && distDown == 0 ? 0 : 1;
                int minValTop = noTop && distUp == 0 ? 0 : 1;
                int scaledValBottom = (int)(Math.pow(distToMidBottom, squareAmount) / halfTotalHeightSQ * (double)(8 - minValBottom)) + minValBottom;
                int scaledValTop = (int)(Math.pow(distToMidTop, squareAmount) / halfTotalHeightSQ * (double)(8 - minValTop)) + minValTop;
                float umin = 0.0f;
                float umax = 16.0f;
                float vmin = 0.0f;
                float vmax = 16.0f;
                float bottomLightingFix = distDown == 0 && noBottom ? 1.0E-4f : 0.0f;
                float topLightingFix = distUp == 0 && noTop ? 1.0E-4f : 0.0f;
                float halfSize = (float)scaledValBottom / 16.0f + bottomLightingFix;
                float halfSizeTexW = halfSize * (umax - umin);
                float halfSize1 = (float)scaledValTop / 16.0f + topLightingFix;
                float halfSizeTex1 = halfSize1 * (umax - umin);
                StalactiteHelper core = StalactiteHelper.getValsFor(posX, posY, posZ);
                QuadBuilder builder = new QuadBuilder(this.format);
                boolean hasTop = distUp == 0 && !noTop;
                boolean bl = hasBottom = distDown == 0 && !noBottom;
                builder.setSprite(hasTop ? this.textureTop : (hasBottom ? this.textureBottom : this.textureMiddle));
                if (distDown == 0 && !noBottom) {
                    core.bX = 0.5;
                    core.bZ = 0.5;
                }
                if (distUp == 0 && !noTop) {
                    core.tX = 0.5;
                    core.tZ = 0.5;
                }
                builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin, vmax);
                builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin, vmin);
                builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmax);
                builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmax);
                builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
                builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin, vmax);
                builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin, vmin);
                builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                if (distUp == 0) {
                    builder.addVertex(core.tX - (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin);
                    builder.addVertex(core.tX - (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                    builder.addVertex(core.tX + (double)halfSize1, height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin + halfSizeTex1 * 2.0f);
                    builder.addVertex(core.tX + (double)halfSize1, height, core.tZ - (double)halfSize1, umin, vmin + halfSizeTex1 * 2.0f);
                }
                if (distDown == 0) {
                    builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin);
                    builder.addVertex(core.bX - (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmin);
                    builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ - (double)halfSize, umin, vmin + halfSizeTexW * 2.0f);
                    builder.addVertex(core.bX + (double)halfSize, 0.0, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin + halfSizeTexW * 2.0f);
                }
                quads = builder.build().nonCulledQuads;
            }
            return quads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureTop;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

