/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.Stencil;

@SideOnly(value=Side.CLIENT)
public class ModelDungeonDoorRunesLayer
extends ModelBase {
    public ModelRenderer top_overlay;
    public ModelRenderer mid_overlay;
    public ModelRenderer bottom_overlay;

    public ModelDungeonDoorRunesLayer() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.top_overlay = new ModelRenderer((ModelBase)this, 0, 0);
        this.top_overlay.func_78793_a(0.0f, -4.5f, -5.5f);
        this.top_overlay.func_78790_a(-7.0f, -2.5f, -2.5f, 14, 5, 5, 0.0f);
        this.mid_overlay = new ModelRenderer((ModelBase)this, 1, 11);
        this.mid_overlay.func_78793_a(0.0f, 0.0f, -6.0f);
        this.mid_overlay.func_78790_a(-7.0f, -2.0f, -2.0f, 14, 4, 4, 0.0f);
        this.bottom_overlay = new ModelRenderer((ModelBase)this, 0, 20);
        this.bottom_overlay.func_78793_a(0.0f, 4.5f, -5.5f);
        this.bottom_overlay.func_78790_a(-7.0f, -2.5f, -2.5f, 14, 5, 5, 0.0f);
    }

    public void renderTopOverlay(TileEntity tile, ResourceLocation glow, int ticks, float scale, float partialTicks) {
        if (tile instanceof TileEntityDungeonDoorRunes) {
            TileEntityDungeonDoorRunes tileDoor = (TileEntityDungeonDoorRunes)tile;
            this.top_overlay.field_78795_f = 0.0f + ((float)tileDoor.lastTickTopRotate + (float)(tileDoor.top_rotate - tileDoor.lastTickTopRotate) * partialTicks) / 57.295776f;
            if (tileDoor.hide_lock) {
                return;
            }
        } else {
            this.top_overlay.field_78795_f = 0.0f;
        }
        this.renderRune(this.top_overlay, glow, ticks, scale, partialTicks);
    }

    public void renderMidOverlay(TileEntity tile, ResourceLocation glow, int ticks, float scale, float partialTicks) {
        if (tile instanceof TileEntityDungeonDoorRunes) {
            TileEntityDungeonDoorRunes tileDoor = (TileEntityDungeonDoorRunes)tile;
            if (tileDoor.hide_lock) {
                return;
            }
            this.mid_overlay.field_78795_f = 0.0f + ((float)tileDoor.lastTickMidRotate + (float)(tileDoor.mid_rotate - tileDoor.lastTickMidRotate) * partialTicks) / 57.295776f;
        } else {
            this.mid_overlay.field_78795_f = 0.0f;
        }
        this.renderRune(this.mid_overlay, glow, ticks, scale, partialTicks);
    }

    public void renderBottomOverlay(TileEntity tile, ResourceLocation glow, int ticks, float scale, float partialTicks) {
        if (tile instanceof TileEntityDungeonDoorRunes) {
            TileEntityDungeonDoorRunes tileDoor = (TileEntityDungeonDoorRunes)tile;
            if (tileDoor.hide_lock) {
                return;
            }
            this.bottom_overlay.field_78795_f = 0.0f + ((float)tileDoor.lastTickBottomRotate + (float)(tileDoor.bottom_rotate - tileDoor.lastTickBottomRotate) * partialTicks) / 57.295776f;
        } else {
            this.bottom_overlay.field_78795_f = 0.0f;
        }
        this.renderRune(this.bottom_overlay, glow, ticks, scale, partialTicks);
    }

    private void renderRune(ModelRenderer box, ResourceLocation glow, int ticks, float scale, float partialTicks) {
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-0.01f, (float)-3.0f);
        Framebuffer fbo = Minecraft.func_71410_x().func_147110_a();
        try (Stencil stencil = Stencil.reserve(fbo);){
            if (stencil.valid()) {
                GL11.glEnable((int)2960);
                stencil.clear(false);
                stencil.func(519, true);
                stencil.op(7681);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                box.func_78785_a(scale);
                GlStateManager.func_179132_a((boolean)true);
                stencil.func(514, true);
                stencil.op(7680);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(glow);
                this.renderRuneGlow(box, ticks, scale, partialTicks);
                GL11.glDisable((int)2960);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
            } else {
                box.func_78785_a(scale);
            }
        }
        GlStateManager.func_179113_r();
    }

    private void renderRuneGlow(ModelRenderer box, int ticks, float scale, float partialTicks) {
        LightingUtil.INSTANCE.setLighting(255);
        float renderTicks = (float)ticks + partialTicks;
        float texOffset = renderTicks * 0.0015f;
        int passes = 3;
        for (int i = 0; i < passes; ++i) {
            GlStateManager.func_179132_a((i == passes - 1 ? 1 : 0) != 0);
            if (i == passes - 1) {
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f + (float)(Math.sin((double)(renderTicks / 10.0f) + (double)i * Math.PI * 2.0 / (double)passes) + 1.0) / 2.0f * 0.3f));
            float dirU = (float)Math.cos((double)i * Math.PI * 2.0 / (double)passes);
            float dirV = (float)Math.sin((double)i * Math.PI * 2.0 / (double)passes);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)(dirU * texOffset), (float)(dirV * texOffset), (float)0.0f);
            GlStateManager.func_179139_a((double)1.0, (double)2.0, (double)1.0);
            GlStateManager.func_179152_a((float)(passes - i), (float)(passes - i), (float)1.0f);
            GlStateManager.func_179114_b((float)(renderTicks / 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5888);
            box.func_78785_a(scale);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        LightingUtil.INSTANCE.revert();
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

