/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleAnimated;

public class ParticleSwarm
extends ParticleAnimated
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected EnumFacing face;
    protected float rotateBias;
    protected Vec3d start;
    protected Supplier<Vec3d> end;
    protected int lightmapX;
    protected int lightmapY;
    public static final ParticleTextureStitcher<ParticleSwarm> SPRITES = ParticleTextureStitcher.create(ParticleSwarm.class, new ResourceLocationWithScale("thebetweenlands:particle/swarm_1", 1.0f), new ResourceLocationWithScale("thebetweenlands:particle/swarm_2", 1.0f), new ResourceLocationWithScale("thebetweenlands:particle/swarm_3", 1.0f), new ResourceLocationWithScale("thebetweenlands:particle/swarm_4", 2.0f)).setSplitAnimations(true);

    protected ParticleSwarm(World world, double x, double y, double z, double mx, double my, double mz, EnumFacing face, float scale, int maxAge, Vec3d start, Supplier<Vec3d> end) {
        super(world, x, y, z, 0.0, 0.0, 0.0, maxAge, scale, false);
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_187126_f = this.field_187123_c = x;
        this.field_187127_g = this.field_187124_d = y;
        this.field_187128_h = this.field_187125_e = z;
        this.face = face;
        this.field_190017_n = false;
        this.start = start;
        this.end = end;
        this.field_82339_as = 0.0f;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null && frames != null) {
            int variant = this.field_187136_p.nextInt(frames.length);
            this.animation.setFrames(frames[variant]);
            ResourceLocation location = frames[variant][0].getLocation();
            if (location instanceof ResourceLocationWithScale) {
                this.field_70544_f *= ((ResourceLocationWithScale)location).scale;
            }
            if (this.field_70547_e < 0) {
                this.field_70547_e = this.animation.getTotalDuration() - 1;
            }
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[variant][0].getSprite());
            }
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public void func_189213_a() {
        Vec3d perpendicular;
        super.func_189213_a();
        int brightness = this.func_189214_a(1.0f);
        this.lightmapX = brightness >> 16 & 0xFFFF;
        this.lightmapY = brightness & 0xFFFF;
        if (this.field_187132_l) {
            this.field_187129_i /= (double)0.7f;
            this.field_187131_k /= (double)0.7f;
        }
        double speed = MathHelper.func_76133_a((double)(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k));
        Vec3d dir = this.end.get().func_178788_d(this.start);
        dir = dir.func_189985_c() > (double)0.1f ? dir.func_72432_b() : Vec3d.field_186680_a;
        Vec3d normal = new Vec3d(this.face.func_176730_m());
        Vec3d motion = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        Vec3d side = motion.func_72432_b().func_72431_c(normal);
        if (this.field_187136_p.nextInt(20) == 0) {
            this.rotateBias = (this.field_187136_p.nextFloat() - 0.5f) * 0.5f;
        }
        Vec3d newMotion = motion.func_178787_e(side.func_186678_a(speed * (double)((this.field_187136_p.nextFloat() - 0.5f) * 0.5f + this.rotateBias))).func_178787_e(dir.func_186678_a(speed * (double)this.field_187136_p.nextFloat() * (double)0.85f)).func_72432_b().func_186678_a(speed);
        this.field_187129_i = newMotion.field_72450_a;
        this.field_187130_j = newMotion.field_72448_b;
        this.field_187131_k = newMotion.field_72449_c;
        double dirX = this.field_187129_i / speed;
        double dirY = this.field_187130_j / speed;
        double dirZ = this.field_187131_k / speed;
        double ahead = this.field_70544_f * 0.2f * 0.125f * 8.0f;
        BlockPos pos = new BlockPos(this.field_187126_f + dirX * ahead - (double)((float)this.face.func_82601_c() * 0.1f), this.field_187127_g + dirY * ahead - (double)((float)this.face.func_96559_d() * 0.1f), this.field_187128_h + dirZ * ahead - (double)((float)this.face.func_82599_e() * 0.1f));
        IBlockState state = this.field_187122_b.func_180495_p(pos);
        if (!state.func_185917_h()) {
            this.field_70546_d = this.field_70547_e;
        }
        switch (this.face) {
            case UP: {
                perpendicular = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case DOWN: {
                perpendicular = new Vec3d(-1.0, 0.0, 0.0);
                break;
            }
            default: {
                perpendicular = new Vec3d(0.0, 1.0, 0.0);
            }
        }
        Vec3d perpendicular2 = perpendicular.func_72431_c(normal);
        double y = perpendicular.func_72430_b(motion);
        double x = perpendicular2.func_72430_b(motion);
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F = (float)MathHelper.func_181159_b((double)y, (double)x) + 1.5707964f;
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        float minU = (float)this.field_94054_b / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.field_94055_c / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.field_70544_f * 2.0f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        Vec3i normal = this.face.func_176730_m();
        float pp1x = 0.0f;
        float pp1y = 0.0f;
        float pp1z = 0.0f;
        switch (this.face) {
            case UP: {
                pp1x = 1.0f;
                break;
            }
            case DOWN: {
                pp1x = -1.0f;
                break;
            }
            default: {
                pp1y = 1.0f;
            }
        }
        float pp2x = ParticleSwarm.crossX(pp1x, pp1y, pp1z, normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p());
        float pp2y = ParticleSwarm.crossY(pp1x, pp1y, pp1z, normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p());
        float pp2z = ParticleSwarm.crossZ(pp1x, pp1y, pp1z, normal.func_177958_n(), normal.func_177956_o(), normal.func_177952_p());
        float yOffset = 0.125f;
        float v1x = (pp1x - pp2x + pp1x * yOffset) * scale;
        float v1y = (pp1y - pp2y + pp1y * yOffset) * scale;
        float v1z = (pp1z - pp2z + pp1z * yOffset) * scale;
        float v2x = (-pp1x - pp2x + pp1x * yOffset) * scale;
        float v2y = (-pp1y - pp2y + pp1y * yOffset) * scale;
        float v2z = (-pp1z - pp2z + pp1z * yOffset) * scale;
        float v3x = (-pp1x + pp2x + pp1x * yOffset) * scale;
        float v3y = (-pp1y + pp2y + pp1y * yOffset) * scale;
        float v3z = (-pp1z + pp2z + pp1z * yOffset) * scale;
        float v4x = (pp1x + pp2x + pp1x * yOffset) * scale;
        float v4y = (pp1y + pp2y + pp1y * yOffset) * scale;
        float v4z = (pp1z + pp2z + pp1z * yOffset) * scale;
        if (this.field_190014_F != 0.0f) {
            float angle = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float cos = MathHelper.func_76134_b((float)(angle * 0.5f));
            float rdx = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)this.face.func_82601_c();
            float rdy = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)this.face.func_96559_d();
            float rdz = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)this.face.func_82599_e();
            float dotrdrd = cos * cos - ParticleSwarm.dot(rdx, rdy, rdz, rdx, rdy, rdz);
            float dotvrd = 2.0f * ParticleSwarm.dot(v1x, v1y, v1z, rdx, rdy, rdz);
            float nx = rdx * dotvrd + v1x * dotrdrd + ParticleSwarm.crossX(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float ny = rdy * dotvrd + v1y * dotrdrd + ParticleSwarm.crossY(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float nz = rdz * dotvrd + v1z * dotrdrd + ParticleSwarm.crossZ(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            v1x = nx;
            v1y = ny;
            v1z = nz;
            dotvrd = 2.0f * ParticleSwarm.dot(v2x, v2y, v2z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v2x * dotrdrd + ParticleSwarm.crossX(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            ny = rdy * dotvrd + v2y * dotrdrd + ParticleSwarm.crossY(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            nz = rdz * dotvrd + v2z * dotrdrd + ParticleSwarm.crossZ(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            v2x = nx;
            v2y = ny;
            v2z = nz;
            dotvrd = 2.0f * ParticleSwarm.dot(v3x, v3y, v3z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v3x * dotrdrd + ParticleSwarm.crossX(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            ny = rdy * dotvrd + v3y * dotrdrd + ParticleSwarm.crossY(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            nz = rdz * dotvrd + v3z * dotrdrd + ParticleSwarm.crossZ(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            v3x = nx;
            v3y = ny;
            v3z = nz;
            dotvrd = 2.0f * ParticleSwarm.dot(v4x, v4y, v4z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v4x * dotrdrd + ParticleSwarm.crossX(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            ny = rdy * dotvrd + v4y * dotrdrd + ParticleSwarm.crossY(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            nz = rdz * dotvrd + v4z * dotrdrd + ParticleSwarm.crossZ(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            v4x = nx;
            v4y = ny;
            v4z = nz;
        }
        float alpha = this.field_70546_d >= this.field_70547_e - 5 ? this.field_82339_as * (float)(this.field_70547_e - this.field_70546_d) / 5.0f : (this.field_70546_d <= 5 ? this.field_82339_as * (float)this.field_70546_d / 5.0f : this.field_82339_as);
        buff.func_181662_b((double)rpx + (double)v1x, (double)rpy + (double)v1y, (double)rpz + (double)v1z).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(this.lightmapX, this.lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v2x, (double)rpy + (double)v2y, (double)rpz + (double)v2z).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(this.lightmapX, this.lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v3x, (double)rpy + (double)v3y, (double)rpz + (double)v3z).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(this.lightmapX, this.lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v4x, (double)rpy + (double)v4y, (double)rpz + (double)v4z).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(this.lightmapX, this.lightmapY).func_181675_d();
    }

    private static float crossX(float x1, float y1, float z1, float x2, float y2, float z2) {
        return y1 * z2 - z1 * y2;
    }

    private static float crossY(float x1, float y1, float z1, float x2, float y2, float z2) {
        return z1 * x2 - x1 * z2;
    }

    private static float crossZ(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * y2 - y1 * x2;
    }

    private static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleSwarm> {
        public Factory() {
            super(ParticleSwarm.class, SPRITES);
        }

        @Override
        public ParticleSwarm createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleSwarm(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getObject(EnumFacing.class, 0), args.scale, args.data.getInt(1), args.data.getObject(Vec3d.class, 2), args.data.getObject(Supplier.class, 3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(EnumFacing.UP, 40, Vec3d.field_186680_a, () -> Vec3d.field_186680_a);
        }
    }

    public static class ResourceLocationWithScale
    extends ResourceLocation {
        public final float scale;

        public ResourceLocationWithScale(String resourceName, float scale) {
            super(resourceName);
            this.scale = scale;
        }
    }
}

