/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.ParticleBatchTypeBuilder;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleAnimated;
import thebetweenlands.client.render.particle.entity.ParticleSwarm;

public class ParticleVisionOrb
extends ParticleAnimated
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    public static final VertexFormat FORMAT = new VertexFormat();
    public static final VertexFormatElement TEX_2_2F = new VertexFormatElement(2, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    protected double cx;
    protected double cy;
    protected double cz;
    protected int lightmapX;
    protected int lightmapY;
    protected float prevDistortion1X;
    protected float prevDistortion1Y;
    protected float distortion1X;
    protected float distortion1Y;
    protected float prevDistortion2X;
    protected float prevDistortion2Y;
    protected float distortion2X;
    protected float distortion2Y;
    protected float prevDistortion3X;
    protected float prevDistortion3Y;
    protected float distortion3X;
    protected float distortion3Y;
    protected float prevDistortion4X;
    protected float prevDistortion4Y;
    protected float distortion4X;
    protected float distortion4Y;
    protected Supplier<Float> alphaSupplier = null;

    protected ParticleVisionOrb(World world, double x, double y, double z, double mx, double my, double mz, double cx, double cy, double cz, float scale, int maxAge) {
        super(world, x, y, z, 0.0, 0.0, 0.0, maxAge, scale, false);
        this.field_187126_f = this.field_187123_c = x;
        this.field_187127_g = this.field_187124_d = y;
        this.field_187128_h = this.field_187125_e = z;
        this.field_187129_i = mx;
        this.field_187130_j = my;
        this.field_187131_k = mz;
        this.field_70544_f = scale;
        this.field_190017_n = false;
        this.field_82339_as = 0.0f;
        this.field_70547_e = maxAge;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.field_190015_G = this.field_190014_F = world.field_73012_v.nextFloat() * 360.0f;
    }

    public ParticleVisionOrb setAlphaFunction(Supplier<Float> alpha) {
        this.alphaSupplier = alpha;
        return this;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        if (this.animation != null && frames != null) {
            int variant = this.field_187136_p.nextInt(frames.length);
            this.animation.setFrames(frames[variant]);
            ResourceLocation location = frames[variant][0].getLocation();
            if (location instanceof ParticleSwarm.ResourceLocationWithScale) {
                this.field_70544_f *= ((ParticleSwarm.ResourceLocationWithScale)location).scale;
            }
            if (this.field_70547_e < 0) {
                this.field_70547_e = this.animation.getTotalDuration() - 1;
            }
            if (this.field_187119_C == null) {
                this.func_187117_a(frames[variant][0].getSprite());
            }
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        if (this.alphaSupplier != null) {
            this.field_82339_as = this.alphaSupplier.get().floatValue();
        }
        int brightness = this.func_189214_a(1.0f);
        this.lightmapX = brightness >> 16 & 0xFFFF;
        this.lightmapY = brightness & 0xFFFF;
        float distortion = 0.02f + MathHelper.func_76126_a((float)((float)this.field_70546_d * 0.01f)) * MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.03f)) * MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.1f)) * 0.05f;
        this.prevDistortion1X = this.distortion1X;
        this.prevDistortion1Y = this.distortion1Y;
        this.distortion1X = MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.1f)) * distortion;
        this.distortion1Y = MathHelper.func_76126_a((float)((float)this.field_70546_d * 0.1f)) * distortion;
        this.prevDistortion2X = this.distortion2X;
        this.prevDistortion2Y = this.distortion2Y;
        this.distortion2X = MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.12f)) * distortion;
        this.distortion2Y = MathHelper.func_76126_a((float)((float)this.field_70546_d * 0.12f)) * distortion;
        this.prevDistortion3X = this.distortion3X;
        this.prevDistortion3Y = this.distortion3Y;
        this.distortion3X = MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.14f)) * distortion;
        this.distortion3Y = MathHelper.func_76126_a((float)((float)this.field_70546_d * 0.14f)) * distortion;
        this.prevDistortion4X = this.distortion4X;
        this.prevDistortion4Y = this.distortion4Y;
        this.distortion4X = MathHelper.func_76134_b((float)((float)this.field_70546_d * 0.16f)) * distortion;
        this.distortion4Y = MathHelper.func_76126_a((float)((float)this.field_70546_d * 0.16f)) * distortion;
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rx, float rz, float ryz, float rxy, float rxz) {
        float minU = (float)this.field_94054_b / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.field_94055_c / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.field_70544_f * 2.0f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float borderU = (maxU - minU) / (float)this.field_187119_C.func_94211_a();
        float borderV = (maxV - minV) / (float)this.field_187119_C.func_94216_b();
        minU += borderU;
        maxU -= borderU;
        minV += borderV;
        maxV -= borderV;
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        double lcx = this.cx - field_70556_an;
        double lcy = this.cy - field_70554_ao;
        double lcz = this.cz - field_70555_ap;
        float normalX = (float)((double)rpx - lcx);
        float normalY = (float)((double)rpy - lcy);
        float normalZ = (float)((double)rpz - lcz);
        float invLen = (float)MathHelper.func_181161_i((double)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        float pp1x = 0.0f;
        float pp1y = 0.0f;
        float pp1z = 0.0f;
        switch (EnumFacing.func_176737_a((float)(normalX *= invLen), (float)(normalY *= invLen), (float)(normalZ *= invLen))) {
            case UP: {
                pp1x = 1.0f;
                break;
            }
            case DOWN: {
                pp1x = -1.0f;
                break;
            }
            default: {
                pp1y = 1.0f;
            }
        }
        float pp2x = ParticleVisionOrb.crossX(pp1x, pp1y, pp1z, normalX, normalY, normalZ);
        float pp2y = ParticleVisionOrb.crossY(pp1x, pp1y, pp1z, normalX, normalY, normalZ);
        float pp2z = ParticleVisionOrb.crossZ(pp1x, pp1y, pp1z, normalX, normalY, normalZ);
        pp1x = -ParticleVisionOrb.crossX(pp2x, pp2y, pp2z, normalX, normalY, normalZ);
        pp1y = -ParticleVisionOrb.crossY(pp2x, pp2y, pp2z, normalX, normalY, normalZ);
        pp1z = -ParticleVisionOrb.crossZ(pp2x, pp2y, pp2z, normalX, normalY, normalZ);
        float v1x = (pp1x - pp2x) * scale;
        float v1y = (pp1y - pp2y) * scale;
        float v1z = (pp1z - pp2z) * scale;
        float v2x = (-pp1x - pp2x) * scale;
        float v2y = (-pp1y - pp2y) * scale;
        float v2z = (-pp1z - pp2z) * scale;
        float v3x = (-pp1x + pp2x) * scale;
        float v3y = (-pp1y + pp2y) * scale;
        float v3z = (-pp1z + pp2z) * scale;
        float v4x = (pp1x + pp2x) * scale;
        float v4y = (pp1y + pp2y) * scale;
        float v4z = (pp1z + pp2z) * scale;
        if (this.field_190014_F != 0.0f) {
            float angle = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float cos = MathHelper.func_76134_b((float)(angle * 0.5f));
            float rdx = MathHelper.func_76126_a((float)(angle * 0.5f)) * normalX;
            float rdy = MathHelper.func_76126_a((float)(angle * 0.5f)) * normalY;
            float rdz = MathHelper.func_76126_a((float)(angle * 0.5f)) * normalZ;
            float dotrdrd = cos * cos - ParticleVisionOrb.dot(rdx, rdy, rdz, rdx, rdy, rdz);
            float dotvrd = 2.0f * ParticleVisionOrb.dot(v1x, v1y, v1z, rdx, rdy, rdz);
            float nx = rdx * dotvrd + v1x * dotrdrd + ParticleVisionOrb.crossX(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float ny = rdy * dotvrd + v1y * dotrdrd + ParticleVisionOrb.crossY(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float nz = rdz * dotvrd + v1z * dotrdrd + ParticleVisionOrb.crossZ(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            v1x = nx;
            v1y = ny;
            v1z = nz;
            dotvrd = 2.0f * ParticleVisionOrb.dot(v2x, v2y, v2z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v2x * dotrdrd + ParticleVisionOrb.crossX(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            ny = rdy * dotvrd + v2y * dotrdrd + ParticleVisionOrb.crossY(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            nz = rdz * dotvrd + v2z * dotrdrd + ParticleVisionOrb.crossZ(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            v2x = nx;
            v2y = ny;
            v2z = nz;
            dotvrd = 2.0f * ParticleVisionOrb.dot(v3x, v3y, v3z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v3x * dotrdrd + ParticleVisionOrb.crossX(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            ny = rdy * dotvrd + v3y * dotrdrd + ParticleVisionOrb.crossY(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            nz = rdz * dotvrd + v3z * dotrdrd + ParticleVisionOrb.crossZ(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            v3x = nx;
            v3y = ny;
            v3z = nz;
            dotvrd = 2.0f * ParticleVisionOrb.dot(v4x, v4y, v4z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v4x * dotrdrd + ParticleVisionOrb.crossX(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            ny = rdy * dotvrd + v4y * dotrdrd + ParticleVisionOrb.crossY(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            nz = rdz * dotvrd + v4z * dotrdrd + ParticleVisionOrb.crossZ(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            v4x = nx;
            v4y = ny;
            v4z = nz;
        }
        float n1x = -((float)((double)(rpx + v1x) - lcx));
        float n1y = -((float)((double)(rpy + v1y) - lcy));
        float n1z = -((float)((double)(rpz + v1z) - lcz));
        float n2x = -((float)((double)(rpx + v2x) - lcx));
        float n2y = -((float)((double)(rpy + v2y) - lcy));
        float n2z = -((float)((double)(rpz + v2z) - lcz));
        float n3x = -((float)((double)(rpx + v3x) - lcx));
        float n3y = -((float)((double)(rpy + v3y) - lcy));
        float n3z = -((float)((double)(rpz + v3z) - lcz));
        float n4x = -((float)((double)(rpx + v4x) - lcx));
        float n4y = -((float)((double)(rpy + v4y) - lcy));
        float n4z = -((float)((double)(rpz + v4z) - lcz));
        float dx = this.prevDistortion1X + (this.distortion1X - this.prevDistortion1X) * partialTicks;
        float dy = this.prevDistortion1Y + (this.distortion1Y - this.prevDistortion1Y) * partialTicks;
        v1x += v1x * dx + v2x * dy;
        v1y += v1y * dx + v2y * dy;
        v1z += v1z * dx + v2z * dy;
        dx = this.prevDistortion2X + (this.distortion2X - this.prevDistortion2X) * partialTicks;
        dy = this.prevDistortion2Y + (this.distortion2Y - this.prevDistortion2Y) * partialTicks;
        v2x += v1x * dx + v2x * dy;
        v2y += v1y * dx + v2y * dy;
        v2z += v1z * dx + v2z * dy;
        dx = this.prevDistortion3X + (this.distortion3X - this.prevDistortion3X) * partialTicks;
        dy = this.prevDistortion3Y + (this.distortion3Y - this.prevDistortion3Y) * partialTicks;
        v3x += v1x * dx + v2x * dy;
        v3y += v1y * dx + v2y * dy;
        v3z += v1z * dx + v2z * dy;
        dx = this.prevDistortion4X + (this.distortion4X - this.prevDistortion4X) * partialTicks;
        dy = this.prevDistortion4Y + (this.distortion4Y - this.prevDistortion4Y) * partialTicks;
        v4x += v1x * dx + v2x * dy;
        float alpha = this.field_70546_d >= this.field_70547_e - 40 ? this.field_82339_as * (float)(this.field_70547_e - this.field_70546_d) / 40.0f : (this.field_70546_d <= 40 ? this.field_82339_as * (float)this.field_70546_d / 40.0f : this.field_82339_as);
        ParticleVisionOrb.emit(buff, rpx + v1x, rpy + v1y, rpz + v1z, this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, maxU, maxV, this.lightmapX, this.lightmapY, n1x, n1y, n1z);
        ParticleVisionOrb.emit(buff, rpx + v2x, rpy + v2y, rpz + v2z, this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, maxU, minV, this.lightmapX, this.lightmapY, n2x, n2y, n2z);
        ParticleVisionOrb.emit(buff, rpx + v3x, rpy + v3y, rpz + v3z, this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, minU, minV, this.lightmapX, this.lightmapY, n3x, n3y, n3z);
        ParticleVisionOrb.emit(buff, rpx + v4x, rpy + (v4y += v1y * dx + v2y * dy), rpz + (v4z += v1z * dx + v2z * dy), this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, minU, maxV, this.lightmapX, this.lightmapY, n4x, n4y, n4z);
    }

    private static void emit(BufferBuilder buff, double x, double y, double z, float r, float g, float b, float a, float u, float v, int lmx, int lmy, float nx, float ny, float nz) {
        float scale = (float)MathHelper.func_181161_i((double)(nx * nx + ny * ny + nz * nz));
        buff.func_181662_b(x, y, z).func_181666_a(r, g, b, a).func_187315_a((double)u, (double)v).func_187314_a(lmx, lmy).func_187315_a(0.0, 0.0).func_181663_c(scale * nx, scale * ny, scale * nz).func_181675_d();
    }

    private static float crossX(float x1, float y1, float z1, float x2, float y2, float z2) {
        return y1 * z2 - z1 * y2;
    }

    private static float crossY(float x1, float y1, float z1, float x2, float y2, float z2) {
        return z1 * x2 - x1 * z2;
    }

    private static float crossZ(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * y2 - y1 * x2;
    }

    private static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    public static BatchedParticleRenderer.ParticleBatch createParticleBatch(Supplier<ResourceLocation> texture) {
        return ParticleVisionOrb.createParticleBatch(() -> Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)texture.get()));
    }

    public static BatchedParticleRenderer.ParticleBatch createParticleBatch(Runnable textureBinder) {
        return BatchedParticleRenderer.INSTANCE.createBatchType(new ParticleBatchTypeBuilder().pass().format(FORMAT).depthMask(false).blur(true).setBlend(true).blend(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA).preRenderPassCallback(() -> {
            GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
            GlStateManager.func_179098_w();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            textureBinder.run();
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9218);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9218);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        }).postRenderPassCallback(() -> {
            GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        }).end().build());
    }

    static {
        FORMAT.func_181721_a(DefaultVertexFormats.field_181713_m);
        FORMAT.func_181721_a(DefaultVertexFormats.field_181714_n);
        FORMAT.func_181721_a(DefaultVertexFormats.field_181715_o);
        FORMAT.func_181721_a(DefaultVertexFormats.field_181716_p);
        FORMAT.func_181721_a(TEX_2_2F);
        FORMAT.func_181721_a(DefaultVertexFormats.field_181717_q);
        FORMAT.func_181721_a(DefaultVertexFormats.field_181718_r);
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleVisionOrb> {
        public Factory(ResourceLocation ... textures) {
            this(ParticleTextureStitcher.create(ParticleVisionOrb.class, textures));
        }

        public Factory(ParticleTextureStitcher<ParticleVisionOrb> stitcher) {
            super(ParticleVisionOrb.class, stitcher);
        }

        @Override
        public ParticleVisionOrb createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleVisionOrb(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getDouble(0), args.data.getDouble(1), args.data.getDouble(2), args.scale, args.data.getInt(3));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(0, 0, 0, 40);
        }
    }
}

