/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelWindChime;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.common.tile.TileEntityWindChime;

@SideOnly(value=Side.CLIENT)
public class RenderWindChime
extends TileEntitySpecialRenderer<TileEntityWindChime> {
    private static final ModelWindChime MODEL = new ModelWindChime();
    private static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/wind_chime.png");

    public void render(TileEntityWindChime te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BatchedParticleRenderer.ParticleBatch batch;
        boolean isBreakingAnimation;
        GlStateManager.func_179094_E();
        GlStateManager.func_179098_w();
        GlStateManager.func_179091_B();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        boolean bl = isBreakingAnimation = te != null && destroyStage >= 0;
        if (isBreakingAnimation) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(TEXTURE);
        }
        if (te != null) {
            MODEL.render((float)te.renderTicks + partialTicks, Math.min(((float)te.prevChimeTicks + (float)(te.chimeTicks - te.prevChimeTicks) * partialTicks) / 100.0f, 1.25f));
        } else {
            MODEL.render(0.0f, 0.0f);
        }
        if (isBreakingAnimation) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        if (!isBreakingAnimation && te != null && (batch = te.getParticleBatch()) != null) {
            RenderHelper.func_74518_a();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            BatchedParticleRenderer.INSTANCE.renderBatch(batch, Minecraft.func_71410_x().func_175606_aa(), partialTicks);
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
    }
}

