/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;

public class BlockDungeonWallCandle
extends BlockHorizontal {
    protected static final AxisAlignedBB CANDLE_WEST_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 0.875, 0.75);
    protected static final AxisAlignedBB CANDLE_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 0.875, 0.75);
    protected static final AxisAlignedBB CANDLE_SOUTH_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.875, 0.75);
    protected static final AxisAlignedBB CANDLE_NORTH_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.875, 1.0);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockDungeonWallCandle() {
        this(Material.field_151576_e);
    }

    public BlockDungeonWallCandle(Material material) {
        super(material);
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return CANDLE_EAST_AABB;
            }
            case WEST: {
                return CANDLE_WEST_AABB;
            }
            case SOUTH: {
                return CANDLE_SOUTH_AABB;
            }
            case NORTH: 
        }
        return CANDLE_NORTH_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return CANDLE_EAST_AABB.func_186670_a(pos);
            }
            case WEST: {
                return CANDLE_WEST_AABB.func_186670_a(pos);
            }
            case SOUTH: {
                return CANDLE_SOUTH_AABB.func_186670_a(pos);
            }
            case NORTH: 
        }
        return CANDLE_NORTH_AABB.func_186670_a(pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)LIT);
        world.func_180501_a(pos, state, 3);
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 0.05f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        } else {
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 2.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        return true;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 13 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double offSetX = 0.0;
            double offSetZ = 0.0;
            double offSetWaxX = 0.0 + rand.nextDouble() * 0.125 - rand.nextDouble() * 0.125;
            double offSetWaxZ = 0.0 + rand.nextDouble() * 0.125 - rand.nextDouble() * 0.125;
            if (state.func_177229_b((IProperty)field_185512_D) == EnumFacing.WEST) {
                offSetX = 0.09375;
            }
            if (state.func_177229_b((IProperty)field_185512_D) == EnumFacing.EAST) {
                offSetX = -0.09375;
            }
            if (state.func_177229_b((IProperty)field_185512_D) == EnumFacing.NORTH) {
                offSetZ = 0.09375;
            }
            if (state.func_177229_b((IProperty)field_185512_D) == EnumFacing.SOUTH) {
                offSetZ = -0.09375;
            }
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.9375;
            double z = (double)pos.func_177952_p() + 0.5;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + offSetX, y, z + offSetZ, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x + offSetX, y, z + offSetZ, 0.0, 0.0, 0.0, new int[0]);
            if (rand.nextInt(10) == 0) {
                BLParticles.TAR_BEAST_DRIP.spawn(world, x + offSetX + offSetWaxX, y - 0.938, z + offSetZ + offSetWaxZ).func_70538_b(1.0f, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : field_185512_D.func_177700_c()) {
            if (!this.canPlaceAt(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean isSide = facing.func_176740_k().func_176722_c();
        return isSide && world.func_180495_p(blockpos).isSideSolid((IBlockAccess)world, blockpos, facing);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_185512_D);
        if (!this.canPlaceAt(world, pos, facing)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, LIT});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }
}

