/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntitySimulacrum;
import thebetweenlands.common.tile.TileEntityWisp;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationCragrockTower;
import thebetweenlands.common.world.storage.location.LocationSpiritTree;
import thebetweenlands.util.AdvancedStateMap;

public class BlockWisp
extends BlockContainer
implements BlockRegistry.IStateMappedBlock {
    protected static final AxisAlignedBB WISP_AABB = new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    public static final PropertyInteger COLOR = PropertyInteger.func_177719_a((String)"color", (int)0, (int)3);
    public static final PropertyBool VISIBLE = PropertyBool.func_177716_a((String)"visible");
    public static final int[] COLORS = new int[]{-8448423, -1, -16316472, -3668101, -15847925, -3668101, -6657784, -11599101};

    public BlockWisp() {
        super(BLMaterialRegistry.WISP);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149711_c(0.0f);
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR, VISIBLE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WISP_AABB;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        if (((Boolean)blockState.func_177229_b((IProperty)VISIBLE)).booleanValue()) {
            return super.func_180636_a(blockState, world, pos, start, end);
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)VISIBLE)).booleanValue()) {
            EntityItem wispItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(Item.func_150898_a((Block)this), 1));
            world.func_72838_d((Entity)wispItem);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWisp();
    }

    public EnumBlockRenderType func_149645_b(IBlockState s) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        state = this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(COLORS.length / 2)));
        world.func_180501_a(pos, state, 2);
        this.updateVisibility(world, pos, state);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public void generateBlock(World world, BlockPos pos) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(COLORS.length / 2))), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)Integer.valueOf(meta >> 1 & 7)).func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)COLOR) << 1 & 7 | ((Boolean)state.func_177229_b((IProperty)VISIBLE) != false ? 1 : 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{COLOR}).ignore(new IProperty[]{VISIBLE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149738_a(World worldIn) {
        return 40;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.updateVisibility(worldIn, pos, state);
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    protected boolean checkVisibility(World world, BlockPos pos) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        if (worldStorage.getEnvironmentEventRegistry().auroras.isActive()) {
            return true;
        }
        if (!worldStorage.getLocalStorageHandler().getLocalStorages(LocationCragrockTower.class, pos.func_177958_n(), pos.func_177952_p(), location -> location.isInside((Vec3i)pos)).isEmpty()) {
            return true;
        }
        if (!worldStorage.getLocalStorageHandler().getLocalStorages(LocationSpiritTree.class, pos.func_177958_n(), pos.func_177952_p(), location -> location.isInside((Vec3i)pos)).isEmpty()) {
            return true;
        }
        return TileEntitySimulacrum.getClosestActiveTile(TileEntitySimulacrum.class, null, world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 16.0, TileEntitySimulacrum.Effect.WISP, null) != null;
    }

    protected void updateVisibility(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)VISIBLE, (Comparable)Boolean.valueOf(this.checkVisibility(world, pos))));
    }
}

