/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.collision;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.IEntityCustomCollisionsCapability;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.item.equipment.ItemRingOfDispersion;
import thebetweenlands.common.registries.CapabilityRegistry;

public class RingOfDispersionEntityCapability
extends EntityCapability<RingOfDispersionEntityCapability, IEntityCustomCollisionsCapability, EntityPlayer>
implements IEntityCustomCollisionsCapability {
    private boolean isPhasing;
    private double viewObstructionDistance;
    private double obstructionDistance;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "ring_of_dispersion");
    }

    @Override
    protected Capability<IEntityCustomCollisionsCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS;
    }

    @Override
    protected Class<IEntityCustomCollisionsCapability> getCapabilityClass() {
        return IEntityCustomCollisionsCapability.class;
    }

    @Override
    protected RingOfDispersionEntityCapability getDefaultCapabilityImplementation() {
        return new RingOfDispersionEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public boolean isPhasing() {
        return this.isPhasing;
    }

    @Override
    public double getViewObstructionDistance() {
        return this.viewObstructionDistance;
    }

    @Override
    public double getViewObstructionCheckDistance() {
        return 0.25;
    }

    @Override
    public double getObstructionDistance() {
        return this.obstructionDistance;
    }

    @Override
    public double getObstructionCheckDistance() {
        return 0.25;
    }

    public static ItemStack getRing(EntityPlayer player) {
        IEquipmentCapability cap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            IInventory inv = cap.getInventory(EnumEquipmentInventory.RING);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemRingOfDispersion)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static double calculateAABBDistance(AxisAlignedBB aabb1, AxisAlignedBB aabb2) {
        double dist;
        if (aabb1.func_72326_a(aabb2)) {
            double dx = Math.max(aabb1.field_72340_a - aabb2.field_72336_d, aabb2.field_72340_a - aabb1.field_72336_d);
            double dy = Math.max(aabb1.field_72338_b - aabb2.field_72337_e, aabb2.field_72338_b - aabb1.field_72337_e);
            double dz = Math.max(aabb1.field_72339_c - aabb2.field_72334_f, aabb2.field_72339_c - aabb1.field_72334_f);
            dist = Math.max(dx, Math.max(dy, dz));
        } else {
            double dx = Math.max(0.0, Math.max(aabb1.field_72340_a - aabb2.field_72336_d, aabb2.field_72340_a - aabb1.field_72336_d));
            double dy = Math.max(0.0, Math.max(aabb1.field_72338_b - aabb2.field_72337_e, aabb2.field_72338_b - aabb1.field_72337_e));
            double dz = Math.max(0.0, Math.max(aabb1.field_72339_c - aabb2.field_72334_f, aabb2.field_72339_c - aabb1.field_72334_f));
            dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        return dist;
    }

    @Override
    public void getCustomCollisionBoxes(IEntityCustomCollisionsCapability.CollisionBoxHelper collisionBoxHelper, AxisAlignedBB aabb, List<AxisAlignedBB> collisionBoxes) {
        this.isPhasing = false;
        this.viewObstructionDistance = Double.MAX_VALUE;
        this.obstructionDistance = Double.MAX_VALUE;
        final EntityPlayer player = (EntityPlayer)this.getEntity();
        ItemStack stack = RingOfDispersionEntityCapability.getRing(player);
        if (!stack.func_190926_b()) {
            ItemRingOfDispersion item = (ItemRingOfDispersion)stack.func_77973_b();
            final AtomicBoolean ringActiveState = new AtomicBoolean(false);
            if (item.canPhase(player, stack)) {
                collisionBoxes.clear();
                final double floor = player.field_70163_u + 0.01;
                final AxisAlignedBB originalAabb = aabb;
                final AxisAlignedBB viewAabb = new AxisAlignedBB(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v).func_186662_g(0.25);
                double checkReach = Math.max(this.getViewObstructionCheckDistance(), this.getObstructionCheckDistance());
                collisionBoxHelper.getCollisionBoxes((Entity)player, aabb.func_72314_b(checkReach, 0.0, checkReach).func_72321_a(0.0, checkReach, 0.0), IEntityCustomCollisionsCapability.EntityCollisionPredicate.ALL, new IEntityCustomCollisionsCapability.BlockCollisionPredicate(){

                    @Override
                    public boolean isColliding(Entity entity, AxisAlignedBB aabb, BlockPos.MutableBlockPos pos, IBlockState state, @Nullable AxisAlignedBB blockAabb) {
                        if (blockAabb == null) {
                            return true;
                        }
                        boolean isCollisionForced = false;
                        if (blockAabb.field_72337_e < floor) {
                            isCollisionForced = true;
                        }
                        if (!isCollisionForced && state.func_185903_a(player, player.field_70170_p, (BlockPos)pos) < 1.0E-4f) {
                            isCollisionForced = true;
                        }
                        if (!isCollisionForced) {
                            double viewDist;
                            double playerDist = RingOfDispersionEntityCapability.calculateAABBDistance(blockAabb, originalAabb);
                            if (playerDist < RingOfDispersionEntityCapability.this.getObstructionCheckDistance() && playerDist < RingOfDispersionEntityCapability.this.obstructionDistance) {
                                RingOfDispersionEntityCapability.this.obstructionDistance = playerDist;
                            }
                            if ((viewDist = RingOfDispersionEntityCapability.calculateAABBDistance(blockAabb, viewAabb)) < RingOfDispersionEntityCapability.this.getViewObstructionCheckDistance() && viewDist < RingOfDispersionEntityCapability.this.viewObstructionDistance) {
                                RingOfDispersionEntityCapability.this.viewObstructionDistance = viewDist;
                            }
                        }
                        if (originalAabb.func_72326_a(blockAabb)) {
                            if (isCollisionForced) {
                                return true;
                            }
                            ringActiveState.set(true);
                            RingOfDispersionEntityCapability.this.isPhasing = true;
                            return false;
                        }
                        return false;
                    }
                }, collisionBoxes);
            }
            boolean newRingActiveState = ringActiveState.get();
            if (item.isActive(stack) != newRingActiveState) {
                item.setActive(stack, newRingActiveState);
            }
        }
    }

    @SubscribeEvent
    public static void onSPPlayerPushOut(PlayerSPPushOutOfBlocksEvent event) {
        ItemRingOfDispersion item;
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        IEntityCustomCollisionsCapability cap = (IEntityCustomCollisionsCapability)player.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS, null);
        if (cap != null && cap.isPhasing() && !(stack = RingOfDispersionEntityCapability.getRing(player)).func_190926_b() && (item = (ItemRingOfDispersion)stack.func_77973_b()).canPhase(player, stack)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        IEntityCustomCollisionsCapability cap;
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) != TheBetweenlands.proxy.getClientPlayer() && (cap = (IEntityCustomCollisionsCapability)player.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS, null)) != null) {
            player.field_70170_p.func_184144_a((Entity)player, player.func_174813_aQ());
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        ItemRingOfDispersion item;
        ItemStack stack;
        EntityPlayer player;
        IEntityCustomCollisionsCapability cap;
        if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76355_l().equals(DamageSource.field_76368_d.func_76355_l()) && (cap = (IEntityCustomCollisionsCapability)(player = (EntityPlayer)event.getEntity()).getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CUSTOM_BLOCK_COLLISIONS, null)) != null && cap.isPhasing() && !(stack = RingOfDispersionEntityCapability.getRing(player)).func_190926_b() && (item = (ItemRingOfDispersion)stack.func_77973_b()).canPhase(player, stack)) {
            event.setCanceled(true);
        }
    }
}

