/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.lastkilled;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.capability.ILastKilledCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class LastKilledCapability
extends EntityCapability<LastKilledCapability, ILastKilledCapability, EntityPlayer>
implements ILastKilledCapability,
ISerializableCapability {
    private ResourceLocation lastKilled;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "last_killed");
    }

    @Override
    protected Capability<ILastKilledCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_LAST_KILLED;
    }

    @Override
    protected Class<ILastKilledCapability> getCapabilityClass() {
        return ILastKilledCapability.class;
    }

    @Override
    protected LastKilledCapability getDefaultCapabilityImplementation() {
        return new LastKilledCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public ResourceLocation getLastKilled() {
        return this.lastKilled;
    }

    @Override
    public void setLastKilled(ResourceLocation key) {
        this.lastKilled = key;
        this.markDirty();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.lastKilled != null) {
            nbt.func_74778_a("lastKilled", this.lastKilled.toString());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.lastKilled = nbt.func_150297_b("lastKilled", 8) ? new ResourceLocation(nbt.func_74779_i("lastKilled")) : null;
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 20;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ILastKilledCapability cap;
        Entity attacker;
        DamageSource source = event.getSource();
        if (source instanceof EntityDamageSource && (attacker = ((EntityDamageSource)source).func_76346_g()) != null && (cap = (ILastKilledCapability)attacker.getCapability(CapabilityRegistry.CAPABILITY_LAST_KILLED, null)) != null) {
            cap.setLastKilled(EntityList.func_191301_a((Entity)event.getEntityLiving()));
        }
    }
}

