/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityCameraOffset;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.mobs.EntityMummyArm;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.movement.IPathObstructionAwareEntity;
import thebetweenlands.common.entity.movement.ObstructionAwarePathNavigateGround;
import thebetweenlands.common.entity.projectiles.EntitySludgeBall;
import thebetweenlands.common.network.clientbound.MessageSummonPeatMummyParticles;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;

public class EntityDreadfulMummy
extends EntityMob
implements IEntityBL,
IBLBoss,
IEntityScreenShake,
IEntityCameraOffset,
IEntityMusic,
IPathObstructionAwareEntity {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public static final IAttribute SPAWN_LENGTH_ATTRIB = new RangedAttribute(null, "bl.spawnLength", 180.0, 0.0, 2.147483647E9).func_111117_a("Spawning Length");
    public static final IAttribute SPAWN_OFFSET_ATTRIB = new RangedAttribute(null, "bl.spawnOffset", 3.0, -2.147483647E9, 2.147483647E9).func_111117_a("Spawning Y Offset");
    private static final DataParameter<Integer> SPAWNING_STATE_DW = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SPEW = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PREY = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> Y_OFFSET = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityDreadfulMummy.class, (DataSerializer)DataSerializers.field_187203_m);
    private int prevSpawningState;
    private int spewTicks = 0;
    private static final int BREAK_COUNT = 20;
    private static final int SPAWN_MUMMY_COOLDOWN = 350;
    private int untilSpawnMummy = 0;
    private static final int SPAWN_SLUDGE_COOLDOWN = 150;
    private int untilSpawnSludge = 0;
    private float prevYOffset;
    private int eatPreyTimer = 60;
    public EntityLivingBase currentEatPrey;
    public int deathTicks = 0;
    private int outOfRangeCounter = 0;
    private int outOfRangeCycleCounter = 0;
    private int obstructedCounter = 0;
    private boolean breakBlocksBelow = false;
    private int blockBreakCounter = 0;

    public EntityDreadfulMummy(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.1f, 2.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWNING_STATE_DW, (Object)0);
        this.field_70180_af.func_187214_a(SPEW, (Object)false);
        this.field_70180_af.func_187214_a(PREY, (Object)-1);
        this.field_70180_af.func_187214_a(Y_OFFSET, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(550.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SPAWN_LENGTH_ATTRIB);
        this.func_110140_aT().func_111150_b(SPAWN_OFFSET_ATTRIB);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        ObstructionAwarePathNavigateGround<EntityDreadfulMummy> navigate = new ObstructionAwarePathNavigateGround<EntityDreadfulMummy>(this, worldIn);
        navigate.func_179693_d(true);
        return navigate;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_DEATH;
    }

    public double func_70033_W() {
        return ((Float)this.field_70180_af.func_187225_a(Y_OFFSET)).floatValue();
    }

    public void setYOffset(float yOffset) {
        this.field_70180_af.func_187227_b(Y_OFFSET, (Object)Float.valueOf(yOffset));
    }

    public float getCurrentOffset() {
        return (float)(-this.getSpawnOffset() + (double)this.getSpawningProgress() * this.getSpawnOffset());
    }

    public double getSpawnOffset() {
        return this.func_110148_a(SPAWN_OFFSET_ATTRIB).func_111126_e();
    }

    public int getSpawningState() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWNING_STATE_DW);
    }

    public int getSpawningLength() {
        return (int)this.func_110148_a(SPAWN_LENGTH_ATTRIB).func_111126_e();
    }

    public float getSpawningProgress() {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * (float)this.getSpawningState();
    }

    public float getSpawningProgress(float delta) {
        if (this.getSpawningLength() == 0) {
            return 1.0f;
        }
        return 1.0f / (float)this.getSpawningLength() * ((float)this.prevSpawningState + (float)(this.getSpawningState() - this.prevSpawningState) * delta);
    }

    public float getInterpolatedYOffsetProgress(float partialTicks) {
        return this.prevYOffset + ((float)this.func_70033_W() - this.prevYOffset) * partialTicks;
    }

    public void updateSpawningState() {
        int spawningState;
        this.prevSpawningState = spawningState = this.getSpawningState();
        if (((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue()) {
            int targetState = MathHelper.func_76123_f((float)((float)this.getSpawningLength() * 0.6f));
            if (spawningState > targetState) {
                this.field_70180_af.func_187227_b(SPAWNING_STATE_DW, (Object)(spawningState - 1));
            }
        } else if (spawningState < this.getSpawningLength()) {
            this.field_70180_af.func_187227_b(SPAWNING_STATE_DW, (Object)(spawningState + 1));
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        float swimSpeedBoost = 10.0f;
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (this.func_70090_H() || this.func_180799_ab()) {
                strafe = strafe * (float)this.func_110148_a(SWIM_SPEED).func_111126_e() * 10.0f;
                up *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
                forward = forward * (float)this.func_110148_a(SWIM_SPEED).func_111126_e() * 10.0f;
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.field_70159_w += (double)(strafe * f2 - forward * f1);
            this.field_70181_x += (double)up;
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
        }
    }

    protected boolean isTargetOutOfAttackRange(EntityLivingBase target) {
        if (target.field_70163_u > this.func_174813_aQ().field_72337_e - 0.25) {
            PathPoint finalPoint;
            Path path = this.func_70661_as().func_75505_d();
            if (path != null && (finalPoint = path.func_75870_c()) != null) {
                PathNodeType type = this.func_70661_as().func_189566_q().func_186330_a((IBlockAccess)this.field_70170_p, finalPoint.field_75839_a, finalPoint.field_75837_b - 1, finalPoint.field_75838_c);
                boolean isEndpointInAir = type != PathNodeType.BLOCKED;
                return isEndpointInAir || (double)((float)finalPoint.field_75837_b + this.field_70131_O) - 0.25 < target.field_70163_u;
            }
            return true;
        }
        return this.func_70032_d((Entity)target) > 24.0f;
    }

    protected boolean isTargetInCloseRange(EntityLivingBase target) {
        return !this.isTargetOutOfAttackRange(target) && target.func_70032_d((Entity)this) < 4.0f;
    }

    protected boolean isTargetObstructed(EntityLivingBase target) {
        PathNodeType type;
        PathPoint finalPoint;
        Path path = this.func_70661_as().func_75505_d();
        if (path != null && path.func_75870_c() != null && (finalPoint = path.func_75870_c()) != null && target.func_70011_f((double)finalPoint.field_75839_a, (double)finalPoint.field_75837_b, (double)finalPoint.field_75838_c) < (double)0.9f && ((type = this.func_70661_as().func_189566_q().func_186330_a((IBlockAccess)this.field_70170_p, finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c)) == PathNodeType.OPEN || type == PathNodeType.WALKABLE)) {
            return false;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        BlockPos center = new BlockPos((Entity)target);
        for (int yo = MathHelper.func_76141_d((float)target.field_70131_O); yo < 3; ++yo) {
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    checkPos.func_181079_c(center.func_177958_n() + xo, center.func_177956_o() + yo, center.func_177952_p() + zo);
                    if (this.field_70170_p.func_184144_a(null, new AxisAlignedBB((BlockPos)checkPos)).isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isBridgableSpot(BlockPos pos) {
        if (this.field_70170_p.func_175623_d(pos)) {
            return true;
        }
        PathNodeType nodeType = this.func_70661_as().func_189566_q().func_186330_a((IBlockAccess)this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return nodeType != PathNodeType.BLOCKED && nodeType != PathNodeType.WATER;
    }

    protected void placeBridge() {
        Path path = this.func_70661_as().func_75505_d();
        if (path != null && path.func_75873_e() < path.func_75874_d()) {
            PathPoint nextPoint = path.func_75877_a(path.func_75873_e());
            if (nextPoint.field_75837_b == MathHelper.func_76128_c((double)(this.field_70163_u + 0.5))) {
                BlockPos pos = new BlockPos((Entity)this);
                if (this.func_174818_b(pos = pos.func_177982_a(0, nextPoint.field_75837_b - pos.func_177956_o() - 1, 0)) <= 2.0 && this.isBridgableSpot(pos) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    int nx = -2;
                    int nz = -2;
                    if (path.func_75873_e() < path.func_75874_d() - 1) {
                        PathPoint secondNextPoint = path.func_75877_a(path.func_75873_e() + 1);
                        nx = MathHelper.func_76125_a((int)(secondNextPoint.field_75839_a - nextPoint.field_75839_a), (int)-1, (int)1);
                        nz = MathHelper.func_76125_a((int)(secondNextPoint.field_75838_c - nextPoint.field_75838_c), (int)-1, (int)1);
                        if (nx == 0) {
                            nx = -2;
                        }
                        if (nz == 0) {
                            nz = -2;
                        }
                    }
                    for (int xo = -1; xo <= 1; ++xo) {
                        for (int zo = -1; zo <= 1; ++zo) {
                            BlockPos offsetPos;
                            if (xo == nx || zo == nz || !this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(offsetPos = pos.func_177982_a(xo, 0, zo)), e -> e != this).isEmpty() || !this.isBridgableSpot(offsetPos)) continue;
                            boolean canReplace = false;
                            if (this.field_70170_p.func_180495_p(offsetPos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, offsetPos)) {
                                canReplace = true;
                            } else {
                                IBlockState hitState = this.field_70170_p.func_180495_p(offsetPos);
                                float hardness = hitState.func_185887_b(this.field_70170_p, offsetPos);
                                if (hardness >= 0.0f && hitState.func_177230_c().canEntityDestroy(hitState, (IBlockAccess)this.field_70170_p, offsetPos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)offsetPos, (IBlockState)hitState)) {
                                    canReplace = true;
                                    if (!hitState.func_185904_a().func_76224_d() && hitState.func_185890_d((IBlockAccess)this.field_70170_p, pos) != null) {
                                        this.field_70170_p.func_175718_b(2001, offsetPos, Block.func_176210_f((IBlockState)hitState));
                                    }
                                    this.field_70170_p.func_175698_g(offsetPos);
                                }
                            }
                            if (!canReplace) continue;
                            this.field_70170_p.func_175656_a(offsetPos, BlockRegistry.PEAT.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    @Override
    public float getBridgePathingMalus(EntityLiving entity, BlockPos pos, PathPoint fallPathPoint) {
        return fallPathPoint == null || fallPathPoint.field_75837_b < pos.func_177956_o() ? 2.0f : -1.0f;
    }

    @Override
    public float getPathingMalus(EntityLiving entity, PathNodeType nodeType, BlockPos pos) {
        if (nodeType == PathNodeType.BLOCKED) {
            return 10.0f;
        }
        return super.func_184643_a(nodeType);
    }

    @Override
    public void onPathingObstructed(EnumFacing facing) {
        if (this.func_70638_az() != null) {
            this.breakBlocksBelow = facing == EnumFacing.DOWN;
            this.blockBreakCounter = 40;
        }
    }

    public int func_82143_as() {
        return 128;
    }

    public void func_70071_h_() {
        EntityLivingBase prey;
        super.func_70071_h_();
        this.prevYOffset = (float)this.func_70033_W();
        if (this.getPrey() != null && ((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue() || !this.func_70089_S()) {
            this.setPrey(null);
        }
        if ((prey = this.getPrey()) instanceof EntityLivingBase) {
            this.currentEatPrey = prey;
            if (this.currentEatPrey != null) {
                this.updateEatPrey();
            }
        } else {
            this.currentEatPrey = null;
        }
        this.updateSpawningState();
        if (this.func_130014_f_().field_72995_K) {
            if (this.getSpawningProgress() < 1.0f) {
                this.setYOffset(this.getCurrentOffset());
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                int breakPoint = this.getSpawningLength() / 20;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState state = this.func_130014_f_().func_180495_p(pos);
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            } else if (this.deathTicks == 0) {
                this.setYOffset(0.0f);
            } else if (this.deathTicks > 60) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.deathTicks % 5 == 0) {
                    BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState state = this.func_130014_f_().func_180495_p(pos);
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    int amount = this.field_70146_Z.nextInt(20) + 15;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        } else {
            EntityLivingBase target = this.func_70638_az();
            if (!(target == null || this.blockBreakCounter != 0 && this.breakBlocksBelow || this.field_70703_bu)) {
                this.placeBridge();
            }
            float targetMotionX = 0.0f;
            float targetMotionY = 0.0f;
            float targetMotionZ = 0.0f;
            if (target instanceof EntityPlayer) {
                NBTTagCompound nbt = target.getEntityData();
                targetMotionX = (float)target.field_70165_t - nbt.func_74760_g("thebetweenlands.dpm.lastX");
                targetMotionY = (float)target.field_70163_u - nbt.func_74760_g("thebetweenlands.dpm.lastY");
                targetMotionZ = (float)target.field_70161_v - nbt.func_74760_g("thebetweenlands.dpm.lastZ");
                nbt.func_74776_a("thebetweenlands.dpm.lastX", (float)target.field_70165_t);
                nbt.func_74776_a("thebetweenlands.dpm.lastY", (float)target.field_70163_u);
                nbt.func_74776_a("thebetweenlands.dpm.lastZ", (float)target.field_70161_v);
            } else if (target != null) {
                targetMotionX = (float)target.field_70159_w;
                targetMotionY = (float)target.field_70181_x;
                targetMotionZ = (float)target.field_70179_y;
            }
            if (target != null && this.isTargetOutOfAttackRange(target)) {
                if (this.obstructedCounter > 0 && ((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue()) {
                    ++this.outOfRangeCycleCounter;
                    if (this.outOfRangeCycleCounter > 200) {
                        this.outOfRangeCycleCounter = 0;
                        this.outOfRangeCounter = 0;
                        this.field_70180_af.func_187227_b(SPEW, (Object)false);
                    }
                } else {
                    this.outOfRangeCounter += 2;
                }
            } else {
                this.outOfRangeCounter = target != null && this.isTargetInCloseRange(target) ? Math.max(0, this.outOfRangeCounter - 2) : Math.max(0, this.outOfRangeCounter - 1);
            }
            if (this.field_70173_aa % 10 == 0) {
                this.obstructedCounter = target != null && this.isTargetObstructed(target) ? (this.obstructedCounter += 2) : Math.max(0, this.obstructedCounter - 1);
            }
            if (this.obstructedCounter <= 0) {
                this.outOfRangeCycleCounter = Math.max(0, this.outOfRangeCycleCounter - 1);
            }
            if (this.obstructedCounter > 10) {
                this.obstructedCounter = 0;
                if (target != null) {
                    BlockPos pos = new BlockPos((Entity)target);
                    if (!this.field_70170_p.func_175623_d(pos.func_177977_b()) && this.field_70170_p.func_72872_a(EntityMummyArm.class, new AxisAlignedBB(pos)).isEmpty()) {
                        EntityMummyArm arm = new EntityMummyArm(this.field_70170_p);
                        arm.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)arm);
                    }
                    this.breakBlocksBelow = false;
                    this.blockBreakCounter = 40;
                }
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    boolean broken = false;
                    for (int xo = -2; xo <= 2; ++xo) {
                        int yo;
                        int n = yo = this.breakBlocksBelow ? -2 : 0;
                        while (yo <= 2) {
                            for (int zo = -2; zo <= 2; ++zo) {
                                if (this.field_70170_p.field_73012_v.nextInt(6) != 0) continue;
                                Vec3d center = new Vec3d(this.field_70165_t + (double)xo, this.field_70163_u + (double)yo, this.field_70161_v + (double)zo);
                                Vec3d vec3d = center.func_178788_d(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
                                Vec3d vec3d2 = this.breakBlocksBelow ? new Vec3d(0.0, -1.0, 0.0) : this.func_70040_Z();
                                if (!(vec3d.func_72430_b(vec3d2) > 0.3)) continue;
                                BlockPos pos = new BlockPos(center);
                                IBlockState hitState = this.field_70170_p.func_180495_p(pos);
                                float hardness = hitState.func_185887_b(this.field_70170_p, pos);
                                if (hitState.func_177230_c().isAir(hitState, (IBlockAccess)this.field_70170_p, pos) || !(hardness >= 0.0f) || !hitState.func_177230_c().canEntityDestroy(hitState, (IBlockAccess)this.field_70170_p, pos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)hitState)) continue;
                                if (!hitState.func_185904_a().func_76224_d() && hitState.func_185890_d((IBlockAccess)this.field_70170_p, pos) != null) {
                                    this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)hitState));
                                }
                                this.field_70170_p.func_175698_g(pos);
                                broken = true;
                            }
                            ++yo;
                        }
                    }
                    if (broken) {
                        this.func_184185_a(SoundRegistry.DREADFUL_PEAT_MUMMY_SWIPE, 1.0f, 1.0f);
                        this.func_184185_a(SoundRegistry.DREADFUL_PEAT_MUMMY_BITE, 1.0f, 1.0f);
                    }
                }
            }
            if (this.outOfRangeCounter > 300) {
                this.outOfRangeCounter = 300;
                this.field_70180_af.func_187227_b(SPEW, (Object)true);
            } else if (this.outOfRangeCounter <= 0) {
                this.field_70180_af.func_187227_b(SPEW, (Object)false);
            }
            if (((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue()) {
                ++this.spewTicks;
                if (this.spewTicks > 60 && this.spewTicks / 5 % 5 == 0 && target != null) {
                    int numBalls = 1 + this.field_70146_Z.nextInt(3);
                    for (int i = 1; i < numBalls; ++i) {
                        float tmax;
                        float g = -0.03f;
                        float h = (float)(target.field_70163_u - this.field_70163_u);
                        float vy0 = 0.5f + this.field_70146_Z.nextFloat() * 1.3f;
                        float s = vy0 * (tmax = -vy0 / g) + 0.5f * g * tmax * tmax;
                        float fall = h - s;
                        if (!(fall < 0.0f)) continue;
                        float tmin = MathHelper.func_76129_c((float)(fall * 2.0f / g));
                        float t = tmax + tmin;
                        float dx = (float)(target.field_70165_t - this.field_70165_t) + targetMotionX * t / 3.0f + (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
                        float dz = (float)(target.field_70161_v - this.field_70161_v) + targetMotionZ * t / 3.0f + (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
                        float len = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
                        float speed = Math.min(len / t * 3.0f, 1.5f);
                        this.spawnRangedSludge((dx /= len) * speed, vy0, (dz /= len) * speed);
                    }
                    if (this.spewTicks % 5 == 0) {
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_RETCH, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_LICK, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    }
                }
            } else {
                this.spewTicks = 0;
            }
            if (this.deathTicks > 60) {
                this.setYOffset((float)(-(this.deathTicks - 60)) * 0.05f);
            }
            if (this.getSpawningProgress() < 1.0f) {
                if (this.getSpawningState() == 0) {
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_EMERGE, SoundCategory.HOSTILE, 1.2f, 1.0f);
                }
                this.setYOffset(this.getCurrentOffset());
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70133_I = true;
                int breakPoint = this.getSpawningLength() / 20;
                if ((this.getSpawningState() - breakPoint / 2 - 1) % breakPoint == 0) {
                    BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
                    IBlockState blockState = this.field_70170_p.func_180495_p(pos);
                    this.func_184185_a(blockState.func_177230_c().getSoundType(blockState, this.field_70170_p, pos, (Entity)this).func_185845_c(), this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
                }
                if (this.getSpawningState() == this.getSpawningLength() - 1) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            } else if (this.deathTicks < 60) {
                this.setYOffset(0.0f);
                this.prevYOffset = 0.0f;
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70089_S() && this.getSpawningProgress() >= 1.0f) {
            if (this.field_70173_aa % 12 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.field_70170_p.func_72890_a((Entity)this, 32.0) == null) {
                this.func_70691_i(1.0f);
            }
            if (this.func_70638_az() != null) {
                AxisAlignedBB checkAABB = this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0);
                List peatMummies = this.func_130014_f_().func_72872_a(EntityPeatMummy.class, checkAABB);
                int mummies = 0;
                for (EntityPeatMummy mummy : peatMummies) {
                    if (!((double)mummy.func_70032_d((Entity)this) <= 64.0) || !mummy.isSpawningFinished()) continue;
                    ++mummies;
                }
                if (mummies < 4 && this.untilSpawnMummy <= 0) {
                    this.spawnMummy();
                }
                if (this.untilSpawnSludge <= 0) {
                    this.spawnSludge();
                }
            }
            if (this.untilSpawnMummy > 0) {
                --this.untilSpawnMummy;
            }
            if (this.untilSpawnSludge > 0) {
                --this.untilSpawnSludge;
            }
            if (this.eatPreyTimer > 0 && this.currentEatPrey != null) {
                --this.eatPreyTimer;
            }
            if (this.eatPreyTimer <= 0) {
                this.setPrey(null);
                this.eatPreyTimer = 60;
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private void spawnMummy() {
        EntityPeatMummy mummy = new EntityPeatMummy(this.func_130014_f_());
        mummy.func_70107_b(this.field_70165_t + (double)(this.field_70146_Z.nextInt(6) - 3), this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextInt(6) - 3));
        if (mummy.func_130014_f_().func_72855_b(mummy.func_174813_aQ()) && mummy.func_130014_f_().func_184144_a((Entity)mummy, mummy.func_174813_aQ()).isEmpty()) {
            this.untilSpawnMummy = 350;
            mummy.func_70624_b(this.func_70638_az());
            mummy.func_70606_j(30.0f);
            this.func_130014_f_().func_72838_d((Entity)mummy);
            mummy.setCarryShimmerstone(false);
            mummy.setBossMummy(true);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_SCREAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageSummonPeatMummyParticles((Entity)mummy), new NetworkRegistry.TargetPoint(this.field_71093_bK, mummy.field_70165_t, mummy.field_70163_u, mummy.field_70161_v, 64.0));
        } else {
            this.untilSpawnMummy = 1;
        }
    }

    private void spawnSludge() {
        this.untilSpawnSludge = 150;
        if (this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
        }
        Vec3d look = this.func_70040_Z();
        double direction = Math.toRadians(this.field_70761_aq);
        EntitySludgeBall sludge = new EntitySludgeBall(this.func_130014_f_(), (EntityLivingBase)this, false);
        sludge.func_70107_b(this.field_70165_t - Math.sin(direction) * 3.5, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + Math.cos(direction) * 3.5);
        sludge.field_70159_w = look.field_72450_a * 0.5;
        sludge.field_70181_x = look.field_72448_b;
        sludge.field_70179_y = look.field_72449_c * 0.5;
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_RETCH, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        this.func_130014_f_().func_72838_d((Entity)sludge);
    }

    private void spawnRangedSludge(float dx, float dy, float dz) {
        double direction = Math.toRadians(this.field_70761_aq);
        EntitySludgeBall sludge = new EntitySludgeBall(this.func_130014_f_(), (EntityLivingBase)this, true);
        sludge.func_70107_b(this.field_70165_t - Math.sin(direction) * 0.75, this.field_70163_u + (double)0.3f, this.field_70161_v + Math.cos(direction) * 0.75);
        sludge.field_70159_w = dx;
        sludge.field_70181_x = dy;
        sludge.field_70179_y = dz;
        this.func_130014_f_().func_72838_d((Entity)sludge);
    }

    public boolean func_70652_k(Entity target) {
        if (this.getSpawningProgress() < 0.95f && (Boolean)this.field_70180_af.func_187225_a(SPEW) == false || this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        boolean attacked = super.func_70652_k(target);
        if (!(!attacked || !this.func_70089_S() || this.field_70146_Z.nextInt(6) != 0 || target == this.currentEatPrey || !(target instanceof EntityLivingBase) || target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75098_d || this.func_130014_f_().field_72995_K || ((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue())) {
            this.setPrey((EntityLivingBase)target);
        }
        if (attacked) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_SWIPE, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
        }
        return attacked;
    }

    private void updateEatPrey() {
        double direction = Math.toRadians(this.field_70761_aq);
        this.currentEatPrey.func_70080_a(this.field_70165_t - Math.sin(direction) * 1.7, this.field_70163_u + 0.25, this.field_70161_v + Math.cos(direction) * 1.7, (float)(Math.toDegrees(direction) + 180.0), 0.0f);
        this.currentEatPrey.field_70177_z = this.currentEatPrey.field_70126_B = (float)(Math.toDegrees(direction) + 180.0);
        this.currentEatPrey.field_70758_at = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70759_as = this.currentEatPrey.field_70126_B;
        this.currentEatPrey.field_70143_R = 0.0f;
        if (this.field_70173_aa % 10 == 0 && !this.func_130014_f_().field_72995_K) {
            this.currentEatPrey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_BITE, SoundCategory.HOSTILE, 1.0f, 0.7f + this.field_70146_Z.nextFloat() * 0.6f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_LICK, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (!this.currentEatPrey.func_70089_S() && !this.func_130014_f_().field_72995_K) {
            this.setPrey(null);
        }
    }

    private void setPrey(EntityLivingBase prey) {
        if (prey == null) {
            this.field_70180_af.func_187227_b(PREY, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(PREY, (Object)prey.func_145782_y());
        }
    }

    private EntityLivingBase getPrey() {
        Entity prey;
        int id = (Integer)this.field_70180_af.func_187225_a(PREY);
        Entity entity = prey = id >= 0 ? this.func_130014_f_().func_73045_a(id) : null;
        if (prey instanceof EntityLivingBase) {
            return (EntityLivingBase)prey;
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, damage);
        }
        if (source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76369_e || source == DamageSource.field_190095_e || source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            return false;
        }
        if (this.currentEatPrey != null && source.func_76346_g() == this.currentEatPrey) {
            return false;
        }
        if (this.getSpawningProgress() < 0.95f && !((Boolean)this.field_70180_af.func_187225_a(SPEW)).booleanValue()) {
            return false;
        }
        if (super.func_70097_a(source, (Boolean)this.field_70180_af.func_187225_a(SPEW) != false ? damage * 0.25f : damage)) {
            Entity sourceEntity;
            if (!this.field_70170_p.field_72995_K && source instanceof EntityDamageSource && (sourceEntity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityLivingBase) {
                if (this.isTargetOutOfAttackRange((EntityLivingBase)sourceEntity)) {
                    this.outOfRangeCounter += 60;
                } else if (this.isTargetInCloseRange((EntityLivingBase)sourceEntity)) {
                    this.outOfRangeCounter = Math.max(0, this.outOfRangeCounter - 40);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70609_aI() {
        this.bossInfo.func_186735_a(0.0f);
        if (this.deathTicks == 0 && !this.func_130014_f_().field_72995_K) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.DREADFUL_PEAT_MUMMY_DEATH, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        ++this.deathTicks;
        if (!this.func_130014_f_().field_72995_K) {
            int xp;
            int dropXP;
            this.field_70165_t = this.field_70142_S;
            this.field_70163_u = this.field_70137_T;
            this.field_70161_v = this.field_70136_U;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.deathTicks > 40 && this.deathTicks % 5 == 0) {
                for (xp = 100; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks == 80) {
                for (xp = 1200; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 120) {
                this.func_70106_y();
            }
        }
        if (this.deathTicks > 80 && this.func_130014_f_().field_72995_K && this.deathTicks % 5 == 0) {
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int x = MathHelper.func_76128_c((double)this.field_70165_t) + xo;
                    int y = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() - 0.1));
                    int z = MathHelper.func_76128_c((double)this.field_70161_v) + zo;
                    IBlockState state = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a) continue;
                    double px = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                    double py = this.field_70163_u - this.func_70033_W() + this.field_70146_Z.nextDouble() * 0.2 + 0.075;
                    double pz = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), block.getSoundType(state, this.func_130014_f_(), this.func_180425_c().func_177977_b(), null).func_185845_c(), SoundCategory.BLOCKS, this.field_70146_Z.nextFloat() * 0.3f + 0.3f, this.field_70146_Z.nextFloat() * 0.15f + 0.7f);
                    int amount = this.field_70146_Z.nextInt(20) + 10;
                    for (int i = 0; i < amount; ++i) {
                        double ox = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double oz = this.field_70146_Z.nextDouble() * (double)0.1f - (double)0.05f;
                        double motionX = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        double motionY = this.field_70146_Z.nextDouble() * 0.25 + 0.1;
                        double motionZ = this.field_70146_Z.nextDouble() * 0.2 - 0.1;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_DUST, px + ox + (double)xo, py, pz + oz + (double)zo, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.func_70089_S()) {
            super.func_70100_b_(player);
        }
    }

    public boolean func_70104_M() {
        return this.func_70089_S() && this.getSpawningProgress() >= 1.0f && super.func_70104_M();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_70610_aX() {
        return this.func_70089_S() && super.func_70610_aX();
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.deathTicks > 0) {
            double dist = this.func_70032_d(viewer);
            float screamMult = (float)(1.0 - dist / 30.0);
            if (dist >= 30.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.deathTicks / 120.0 * Math.PI) + (double)0.1f) * (double)0.15f * (double)screamMult);
        }
        return 0.0f;
    }

    @Override
    public boolean applyOffset(Entity view, float partialTicks) {
        if (this.currentEatPrey == view) {
            double direction = Math.toRadians(this.field_70760_ar + (this.field_70761_aq - this.field_70760_ar) * partialTicks);
            view.field_70126_B = view.field_70177_z = (float)(Math.toDegrees(direction) + 180.0);
            view.field_70125_A = 0.0f;
            view.field_70127_C = 0.0f;
            view.func_70034_d((float)(Math.toDegrees(direction) + 180.0));
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawningState", this.getSpawningState());
        nbt.func_74768_a("deathTicks", this.deathTicks);
        nbt.func_74780_a("initialPosY", this.field_70163_u);
        nbt.func_74776_a("previousYOffset", this.prevYOffset);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.deathTicks = nbt.func_74762_e("deathTicks");
        this.field_70163_u = nbt.func_74769_h("initialPosY");
        this.setYOffset(nbt.func_74760_g("previousYOffset"));
        this.field_70180_af.func_187227_b(SPAWNING_STATE_DW, (Object)nbt.func_74762_e("spawningState"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.DREADFUL_PEAT_MUMMY;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public BLSoundEvent getMusicFile(EntityPlayer listener) {
        return SoundRegistry.DREADFUL_PEAT_MUMMY_LOOP;
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 32.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }

    @Override
    public int getMusicLayer(EntityPlayer listener) {
        return 1;
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }
}

