/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleBatchTypeBuilder;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.common.entity.ai.EntityAIFlyRandomly;
import thebetweenlands.common.entity.mobs.EntityFlyingMob;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityGasCloud
extends EntityFlyingMob
implements IEntityBL {
    public static final IAttribute GAS_CLOUD_COLOR_R = new RangedAttribute(null, "bl.gasCloudColorRed", 104.0, 0.0, 255.0).func_111117_a("Gas cloud color red component").func_111112_a(true);
    public static final IAttribute GAS_CLOUD_COLOR_G = new RangedAttribute(null, "bl.gasCloudColorGreen", 196.0, 0.0, 255.0).func_111117_a("Gas cloud color green component").func_111112_a(true);
    public static final IAttribute GAS_CLOUD_COLOR_B = new RangedAttribute(null, "bl.gasCloudColorBlue", 179.0, 0.0, 255.0).func_111117_a("Gas cloud color blue component").func_111112_a(true);
    public static final IAttribute GAS_CLOUD_COLOR_A = new RangedAttribute(null, "bl.gasCloudColorAlpha", 170.0, 0.0, 255.0).func_111117_a("Gas cloud color alpha component").func_111112_a(true);
    protected double aboveLayer = 6.0;
    protected int targetBlockedTicks = 0;
    public static final DamageSource damageSourceSuffocation = new DamageSource("suffocation").func_76348_h();
    @SideOnly(value=Side.CLIENT)
    private BatchedParticleRenderer.ParticleBatch particleBatch;

    public EntityGasCloud(World world) {
        super(world);
        this.func_70105_a(1.75f, 1.75f);
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.field_70765_h = new FlightMoveHelper((EntityLiving)this){

            @Override
            protected boolean isNotColliding(double x, double y, double z, double step) {
                double stepX = (x - this.field_75648_a.field_70165_t) / step;
                double stepY = (y - this.field_75648_a.field_70163_u) / step;
                double stepZ = (z - this.field_75648_a.field_70161_v) / step;
                double cx = this.field_75648_a.field_70165_t;
                double cy = this.field_75648_a.field_70163_u;
                double cz = this.field_75648_a.field_70161_v;
                boolean canPassSolidBlocks = ((EntityGasCloud)this.field_75648_a).func_70638_az() != null;
                BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                int i = 1;
                while ((double)i < step) {
                    checkPos.func_189532_c(cx += stepX, cy += stepY, cz += stepZ);
                    if (this.field_75648_a.func_130014_f_().func_175667_e((BlockPos)checkPos)) {
                        IBlockState state = this.field_75648_a.func_130014_f_().func_180495_p((BlockPos)checkPos);
                        if (!canPassSolidBlocks && state.func_185914_p() || state.func_185904_a().func_76224_d()) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++i;
                }
                checkPos.func_185344_t();
                return true;
            }
        };
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        if (this.field_70170_p.field_72995_K) {
            this.initParticleBatch();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initParticleBatch() {
        this.particleBatch = BatchedParticleRenderer.INSTANCE.createBatchType(new ParticleBatchTypeBuilder().pass().depthMaskPass(true).lit(true).texture((ResourceLocation)null).setFog(false).end().build());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFlyRandomly<EntityGasCloud>(this){

            @Override
            protected double getTargetY(Random rand, double distanceMultiplier) {
                if (((EntityGasCloud)this.entity).field_70163_u <= 0.0) {
                    return ((EntityGasCloud)this.entity).field_70163_u + 16.0;
                }
                int worldHeight = 0;
                BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (int yo = 0; yo < MathHelper.func_76143_f((double)EntityGasCloud.this.aboveLayer); ++yo) {
                    checkPos.func_189532_c(((EntityGasCloud)this.entity).field_70165_t, ((EntityGasCloud)this.entity).field_70163_u - (double)yo, ((EntityGasCloud)this.entity).field_70161_v);
                    if (!((EntityGasCloud)this.entity).func_130014_f_().func_175667_e((BlockPos)checkPos)) {
                        return ((EntityGasCloud)this.entity).field_70163_u;
                    }
                    if (((EntityGasCloud)this.entity).func_130014_f_().func_175623_d((BlockPos)checkPos)) continue;
                    worldHeight = checkPos.func_177956_o();
                    break;
                }
                checkPos.func_185344_t();
                if (((EntityGasCloud)this.entity).field_70163_u > (double)worldHeight + EntityGasCloud.this.aboveLayer) {
                    return ((EntityGasCloud)this.entity).field_70163_u + (double)(-rand.nextFloat() * 2.0f * 16.0f) * distanceMultiplier;
                }
                float rndFloat = rand.nextFloat() * 2.0f - 1.0f;
                if ((double)rndFloat > 0.0) {
                    double maxRange = (double)worldHeight + EntityGasCloud.this.aboveLayer - ((EntityGasCloud)this.entity).field_70163_u;
                    return ((EntityGasCloud)this.entity).field_70163_u + (double)(-rand.nextFloat() * 2.0f) * maxRange * distanceMultiplier;
                }
                return ((EntityGasCloud)this.entity).field_70163_u + (double)((rand.nextFloat() * 2.0f - 1.0f) * 16.0f) * distanceMultiplier;
            }

            @Override
            protected double getFlightSpeed() {
                return 0.3;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.065);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(GAS_CLOUD_COLOR_R);
        this.func_110140_aT().func_111150_b(GAS_CLOUD_COLOR_G);
        this.func_110140_aT().func_111150_b(GAS_CLOUD_COLOR_B);
        this.func_110140_aT().func_111150_b(GAS_CLOUD_COLOR_A);
    }

    public void setGasColor(int r, int g, int b, int a) {
        this.func_110148_a(GAS_CLOUD_COLOR_R).func_111128_a((double)r);
        this.func_110148_a(GAS_CLOUD_COLOR_G).func_111128_a((double)g);
        this.func_110148_a(GAS_CLOUD_COLOR_B).func_111128_a((double)b);
        this.func_110148_a(GAS_CLOUD_COLOR_A).func_111128_a((double)a);
    }

    public int[] getGasColor() {
        return new int[]{(int)this.func_110148_a(GAS_CLOUD_COLOR_R).func_111126_e(), (int)this.func_110148_a(GAS_CLOUD_COLOR_G).func_111126_e(), (int)this.func_110148_a(GAS_CLOUD_COLOR_B).func_111126_e(), (int)this.func_110148_a(GAS_CLOUD_COLOR_A).func_111126_e()};
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnCloudParticle(false);
            this.updateParticleBatch();
        }
        if (this.func_70090_H()) {
            this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
        } else if (this.func_70638_az() != null) {
            this.field_70765_h.func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().field_70161_v, 1.0);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5));
            for (EntityLivingBase target : targets) {
                if (target instanceof EntityGasCloud || target instanceof IEntityBL) continue;
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 0));
                if (target.field_70173_aa % 10 != 0) continue;
                target.func_70097_a(damageSourceSuffocation, (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateParticleBatch() {
        BatchedParticleRenderer.INSTANCE.updateBatch(this.particleBatch);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCloudParticle(boolean strongMotion) {
        if (strongMotion) {
            double x = this.field_70165_t + this.field_70159_w + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            double y = this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70181_x + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            double z = this.field_70161_v + this.field_70179_y + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            int[] color = this.getGasColor();
            ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this)).withMotion((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat() * 0.25f, (this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat() * 0.25f, (this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat() * 0.25f)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f));
            BatchedParticleRenderer.INSTANCE.addParticle(this.particleBatch, particle);
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, particle);
        } else {
            double x = this.field_70165_t + this.field_70159_w + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            double y = this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70181_x + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            double z = this.field_70161_v + this.field_70179_y + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
            double mx = this.field_70159_w + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f);
            double my = this.field_70181_x + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f);
            double mz = this.field_70179_y + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f);
            int[] color = this.getGasColor();
            ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f));
            BatchedParticleRenderer.INSTANCE.addParticle(this.particleBatch, particle);
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BatchedParticleRenderer.ParticleBatch getParticleBatch() {
        return this.particleBatch;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source != DamageSource.field_76368_d) {
            EntityPlayer player;
            ItemStack held;
            Entity direct;
            if (source instanceof EntityDamageSource && (direct = ((EntityDamageSource)source).func_76364_f()) instanceof EntityPlayer && !(held = (player = (EntityPlayer)direct).func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && held.func_77973_b() == ItemRegistry.DENTROTHYST_VIAL && held.func_77952_i() != 1) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 10; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x + (double)(this.field_70131_O * 0.5f), this.field_70161_v + this.field_70179_y, -this.field_70159_w + (double)(this.field_70146_Z.nextFloat() - 0.5f), -this.field_70181_x + 0.2 + (double)(this.field_70146_Z.nextFloat() - 0.5f), -this.field_70179_y + (double)(this.field_70146_Z.nextFloat() - 0.5f), new int[0]);
                    }
                }
                if (super.func_70097_a(source, damage * 3.0f)) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (!this.func_70089_S()) {
                            held.func_190918_g(1);
                            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemRegistry.DENTROTHYST_FLUID_VIAL.withFluid(held.func_77952_i() == 2 ? 1 : 0, FluidRegistry.SHALLOWBREATH));
                        }
                        this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, FluidRegistry.SHALLOWBREATH.getFillSound(new FluidStack(FluidRegistry.SHALLOWBREATH, 1000)), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
                return false;
            }
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.GAS_CLOUD_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.GAS_CLOUD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.GAS_CLOUD_DEATH;
    }

    protected void func_70609_aI() {
        int i;
        ++this.field_70725_aQ;
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < 6; ++i) {
                this.spawnCloudParticle(true);
            }
        }
        if (this.field_70725_aQ >= 80) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.GAS_CLOUD;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

