/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityTinySludgeWorm
extends EntitySludgeWorm {
    public static final byte EVENT_SQUASHED = 80;
    public static final byte EVENT_LEAP = 81;
    protected boolean isSquashed = false;

    public EntityTinySludgeWorm(World world) {
        this(world, true);
    }

    public EntityTinySludgeWorm(World world, boolean doSpawningAnimation) {
        super(world, doSpawningAnimation);
        this.func_70105_a(0.3125f, 0.3125f);
        this.field_70178_ae = true;
        this.field_70728_aV = 1;
        this.parts = new MultiPartEntityPart[]{new MultiPartEntityPart((IEntityMultiPart)this, "part1", 0.1875f, 0.1875f), new MultiPartEntityPart((IEntityMultiPart)this, "part2", 0.1875f, 0.1875f), new MultiPartEntityPart((IEntityMultiPart)this, "part3", 0.1875f, 0.1875f), new MultiPartEntityPart((IEntityMultiPart)this, "part4", 0.1875f, 0.1875f), new MultiPartEntityPart((IEntityMultiPart)this, "part5", 0.1875f, 0.1875f), new MultiPartEntityPart((IEntityMultiPart)this, "part6", 0.1875f, 0.1875f)};
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f){

            public void func_75249_e() {
                super.func_75249_e();
                EntityTinySludgeWorm.this.func_82194_d().func_72960_a((Entity)EntityTinySludgeWorm.this, (byte)81);
            }
        });
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 1));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.21);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.5);
    }

    @Override
    protected double getMaxPieceDistance() {
        return 0.2;
    }

    public boolean func_70652_k(Entity entity) {
        return this.func_70685_l(entity) && entity.field_70122_E && super.func_70652_k(entity);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            for (MultiPartEntityPart part : this.parts) {
                if (!(player.func_174813_aQ().field_72337_e >= part.func_174813_aQ().field_72338_b) || !(player.func_174813_aQ().field_72338_b <= part.func_174813_aQ().field_72337_e) || !(player.func_174813_aQ().field_72336_d >= part.func_174813_aQ().field_72340_a) || !(player.func_174813_aQ().field_72340_a <= part.func_174813_aQ().field_72336_d) || !(player.func_174813_aQ().field_72334_f >= part.func_174813_aQ().field_72339_c) || !(player.func_174813_aQ().field_72339_c <= part.func_174813_aQ().field_72334_f) || !(player.field_70167_r > player.field_70163_u)) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 80, 0));
                if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                    player.func_70690_d(ElixirEffectRegistry.EFFECT_DECAY.createEffect(80, 1));
                } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                    player.func_70690_d(ElixirEffectRegistry.EFFECT_DECAY.createEffect(160, 1));
                }
                this.isSquashed = true;
            }
            if (this.isSquashed) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)80);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getJumpedOnSound(), SoundCategory.NEUTRAL, 1.0f, 0.5f);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184615_bR(), SoundCategory.NEUTRAL, 1.0f, 0.5f);
                this.damageWorm(DamageSource.func_76365_a((EntityPlayer)player), this.func_110143_aJ());
            }
        }
    }

    public boolean isSquashed() {
        return this.isSquashed;
    }

    public void func_70609_aI() {
        if (this.isSquashed) {
            this.field_70725_aQ = 19;
        }
        super.func_70609_aI();
    }

    public void func_70103_a(byte id) {
        block3: {
            block2: {
                super.func_70103_a(id);
                if (id != 80) break block2;
                for (int i = 0; i < 100; ++i) {
                    Random rnd = this.field_70170_p.field_73012_v;
                    float rx = rnd.nextFloat() * 1.0f - 0.5f;
                    float ry = rnd.nextFloat() * 1.0f - 0.5f;
                    float rz = rnd.nextFloat() * 1.0f - 0.5f;
                    Vec3d vec = new Vec3d((double)rx, (double)ry, (double)rz);
                    vec = vec.func_72432_b();
                    BLParticles.SPLASH_TAR.spawn(this.func_130014_f_(), this.field_70165_t + (double)rx + (double)0.1f, this.field_70163_u + (double)ry + (double)0.1f, this.field_70161_v + (double)rz + (double)0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.4f, vec.field_72448_b * (double)0.4f, vec.field_72449_c * (double)0.4f)).func_70538_b(0.4118f, 0.2745f, 0.1568f);
                }
                break block3;
            }
            if (id != 81) break block3;
            for (Entity part : this.func_70021_al()) {
                part.field_70181_x += (double)0.3f;
            }
        }
    }

    protected SoundEvent getJumpedOnSound() {
        return SoundRegistry.WORM_SPLAT;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 1.5f;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.TINY_SLUDGE_WORM;
    }
}

