/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;
import thebetweenlands.util.AspectIconRenderer;

@SideOnly(value=Side.CLIENT)
public class AspectWidget
extends ManualWidgetBase {
    public IAspectType aspect;
    public float scale = 1.0f;

    public AspectWidget(int xStart, int yStart, IAspectType aspect, float scale) {
        super(xStart, yStart);
        this.aspect = aspect;
        this.scale = scale;
    }

    @Override
    public void drawForeGround() {
        super.drawForeGround();
        AspectIconRenderer.renderIcon(this.xStart, this.yStart, (int)(16.0f * this.scale), (int)(16.0f * this.scale), this.aspect.getIcon());
    }

    @Override
    public void drawToolTip() {
        super.drawToolTip();
        if (this.mouseX >= this.xStart && (float)this.mouseX <= (float)this.xStart + 16.0f * this.scale && this.mouseY >= this.yStart && (float)this.mouseY <= (float)this.yStart + 16.0f * this.scale) {
            ArrayList<String> tooltipData = new ArrayList<String>();
            tooltipData.add(this.aspect.getName());
            tooltipData.add(TextFormatting.GRAY + this.aspect.getType());
            AspectWidget.renderTooltip(this.mouseX, this.mouseY, tooltipData, 0xFFFFFF, -267386864);
        }
    }
}

