/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.util.TranslationHelper;

public class ItemLifeCrystal
extends Item {
    private boolean isRechargeable;

    public ItemLifeCrystal(int maxLife, boolean isRechargeable) {
        this.func_77656_e(maxLife);
        this.field_77777_bU = 1;
        this.isRechargeable = isRechargeable;
        this.func_185043_a(new ResourceLocation("remaining"), (stack, worldIn, entityIn) -> {
            int damage = stack.func_77952_i();
            if (damage >= stack.func_77958_k()) {
                return 4.0f;
            }
            if ((float)damage > (float)stack.func_77958_k() * 0.75f) {
                return 3.0f;
            }
            if ((float)damage > (float)stack.func_77958_k() * 0.5f) {
                return 2.0f;
            }
            if ((float)damage > (float)stack.func_77958_k() * 0.25f) {
                return 1.0f;
            }
            return 0.0f;
        });
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    public boolean isRechargeable(ItemStack stack) {
        return this.isRechargeable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.life_crystal.remaining", Math.round(100.0f - 100.0f / (float)stack.func_77958_k() * (float)this.getDamage(stack)) + "%"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage && this.isRechargeable(stack)) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }
}

