/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.IGenericItem;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.feature.structure.WorldGenWeedwoodPortalTree;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationPortal;

public class ItemSwampTalisman
extends Item
implements ItemRegistry.IBlockStateItemModelDefinition {
    public ItemSwampTalisman() {
        this.func_77656_e(0);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EnumTalisman type : EnumTalisman.values()) {
                if (type == EnumTalisman.SWAMP_TALISMAN_5) continue;
                items.add((Object)type.create(1));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + IGenericItem.getFromStack(EnumTalisman.class, stack).getTranslationKey();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknown_talisman";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (EnumTalisman.SWAMP_TALISMAN_5.isItemOf(stack) && stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 4)) {
            BlockPos otherPortalPos = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("link"));
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl.swamp_talisman_linked", (Object[])new Object[]{otherPortalPos.func_177958_n(), otherPortalPos.func_177956_o(), otherPortalPos.func_177952_p()}), 0));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        if (this.isPortalWood(state)) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            for (int yo = 3; yo > 0; --yo) {
                BlockPos portalPos = offsetPos.func_177979_c(yo);
                EnumFacing.Axis frameAxis = this.getPortalWoodFrameAxis(worldIn, portalPos);
                if (frameAxis == null) continue;
                if (!worldIn.field_72995_K) {
                    EnumFacing closestDir = null;
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        if (dir.func_176740_k() != frameAxis || closestDir != null && !(pos.func_177972_a(dir).func_177954_c(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v) <= pos.func_177972_a(closestDir).func_177954_c(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v))) continue;
                        closestDir = dir;
                    }
                    if (frameAxis == EnumFacing.Axis.X) {
                        BlockTreePortal.makePortalX(worldIn, portalPos.func_177984_a());
                    } else if (frameAxis == EnumFacing.Axis.Z) {
                        BlockTreePortal.makePortalZ(worldIn, portalPos.func_177984_a());
                    }
                    if (frameAxis == EnumFacing.Axis.X && BlockTreePortal.isPatternValidX((IBlockAccess)worldIn, portalPos.func_177984_a()) || frameAxis == EnumFacing.Axis.Z && BlockTreePortal.isPatternValidZ((IBlockAccess)worldIn, portalPos.func_177984_a())) {
                        if (this.getPortalAt(worldIn, portalPos.func_177984_a()) == null) {
                            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(worldIn);
                            LocationPortal location = new LocationPortal(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), portalPos.func_177972_a(closestDir).func_177977_b());
                            location.addBounds(new AxisAlignedBB(portalPos.func_177984_a()).func_72314_b(1.0, 2.0, 1.0).func_72321_a(0.0, -0.5, 0.0));
                            location.setSeed(worldIn.field_73012_v.nextLong());
                            location.setDirty(true);
                            location.setVisible(false);
                            worldStorage.getLocalStorageHandler().addLocalStorage(location);
                        }
                        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.PLAYERS, 0.5f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        boolean isCustomListed = BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionTargetsList.isListed(state);
        boolean sapling = this.isBlockSapling(worldIn, playerIn, state, pos, facing, hitX, hitY, hitZ);
        if ((sapling || isCustomListed) && (EnumTalisman.SWAMP_TALISMAN_0.isItemOf(stack) || EnumTalisman.SWAMP_TALISMAN_5.isItemOf(stack))) {
            if (!worldIn.field_72995_K) {
                if (!BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionWhitelistSet.isListed(playerIn.field_70170_p.field_73011_w.getDimension())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.wrongdimension", new Object[0]), true);
                } else {
                    int targetDim;
                    WorldGenWeedwoodPortalTree gen = isCustomListed ? ((targetDim = BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionTargetsList.getDimension(state)) == playerIn.field_70170_p.field_73011_w.getDimension() ? new WorldGenWeedwoodPortalTree() : new WorldGenWeedwoodPortalTree(BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionTargetsList.getDimension(state))) : new WorldGenWeedwoodPortalTree();
                    if (gen.func_180709_b(worldIn, field_77697_d, pos)) {
                        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.PLAYERS, 0.5f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                        playerIn.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, playerIn.field_70177_z, playerIn.field_70125_A);
                        if (playerIn instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)playerIn).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, playerIn.field_70177_z, playerIn.field_70125_A);
                        }
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.noplace", new Object[0]), true);
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (EnumTalisman.SWAMP_TALISMAN_0.isItemOf(stack) && !(playerIn instanceof FakePlayer)) {
            LocationPortal portal = this.getPortalAt(worldIn, pos);
            if (portal != null) {
                if (!worldIn.field_72995_K) {
                    stack = stack.func_77946_l();
                    stack.func_77964_b(EnumTalisman.SWAMP_TALISMAN_5.getID());
                    playerIn.func_184611_a(hand, stack);
                    stack.func_77983_a("link", (NBTBase)new NBTTagLong(portal.getPortalPosition().func_177986_g()));
                    stack.func_77983_a("linkDim", (NBTBase)new NBTTagInt(worldIn.field_73011_w.getDimension()));
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.linked", new Object[0]), true);
                    worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.8f, 0.7f);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (EnumTalisman.SWAMP_TALISMAN_5.isItemOf(stack) && !(playerIn instanceof FakePlayer)) {
            if (!worldIn.field_72995_K) {
                stack = stack.func_77946_l();
                stack.func_77964_b(EnumTalisman.SWAMP_TALISMAN_0.getID());
                playerIn.func_184611_a(hand, stack);
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.8f, 0.7f);
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 4) && stack.func_77978_p().func_150297_b("linkDim", 3)) {
                BlockPos otherPortalPos = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("link"));
                LocationPortal portal = this.getPortalAt(worldIn, pos);
                if (portal != null && worldIn instanceof WorldServer) {
                    int linkDim = stack.func_77978_p().func_74762_e("linkDim");
                    if (linkDim != worldIn.field_73011_w.getDimension() && (linkDim == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId || worldIn.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId)) {
                        WorldServer otherWorld = ((WorldServer)worldIn).func_73046_m().func_71218_a(linkDim);
                        if (otherWorld != null) {
                            double moveFactor = otherWorld.field_73011_w.getMovementFactor() / worldIn.field_73011_w.getMovementFactor();
                            Vec3d vec3d = new Vec3d((Vec3i)portal.getPortalPosition());
                            Vec3d vec3d2 = new Vec3d((double)otherPortalPos.func_177958_n() * moveFactor, (double)portal.getPortalPosition().func_177956_o(), (double)otherPortalPos.func_177952_p() * moveFactor);
                            if (vec3d.func_72438_d(vec3d2) <= (double)BetweenlandsConfig.WORLD_AND_DIMENSION.portalMaxLinkDist) {
                                LocationPortal linkPortal = this.getLinkPortal(otherWorld, otherPortalPos);
                                if (linkPortal != null) {
                                    linkPortal.setOtherPortalPosition(worldIn.field_73011_w.getDimension(), portal.getPortalPosition());
                                    portal.setOtherPortalPosition(linkDim, linkPortal.getPortalPosition());
                                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.portal_linked", new Object[0]), true);
                                } else {
                                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.cant_link", new Object[0]), true);
                                }
                            } else {
                                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.too_far", new Object[]{new TextComponentString(String.valueOf(BetweenlandsConfig.WORLD_AND_DIMENSION.portalMaxLinkDist))}), true);
                            }
                        }
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("chat.talisman.cant_link", new Object[0]), true);
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected LocationPortal getPortalAt(World world, BlockPos pos) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, (double)pos.func_177958_n() + 0.5, (double)pos.func_177952_p() + 0.5, location -> location.isInside(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5)));
        if (!portals.isEmpty()) {
            return portals.get(0);
        }
        return null;
    }

    protected LocationPortal getLinkPortal(WorldServer world, BlockPos portal2Pos) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld((World)world);
        List<LocationPortal> portals = worldStorage.getLocalStorageHandler().getLocalStorages(LocationPortal.class, (double)portal2Pos.func_177958_n() + 0.5, (double)portal2Pos.func_177952_p() + 0.5, location -> location.isInside(new Vec3d((Vec3i)portal2Pos).func_72441_c(0.5, 0.5, 0.5)) && portal2Pos.equals((Object)location.getPortalPosition()));
        if (!portals.isEmpty()) {
            return portals.get(0);
        }
        return null;
    }

    protected boolean isBlockSapling(World worldIn, EntityPlayer playerIn, IBlockState state, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack2;
        Block block = state.func_177230_c();
        if (block instanceof BlockSapling) {
            return true;
        }
        NonNullList dict = OreDictionary.getOres((String)"treeSapling");
        for (ItemStack stack2 : dict) {
            if (!(stack2.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack2.func_77973_b()).func_179223_d() != block) continue;
            return true;
        }
        RayTraceResult result = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos);
        stack2 = block.getPickBlock(state, result, worldIn, pos, playerIn);
        if (!stack2.func_190926_b()) {
            int[] ids;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack2)) {
                if (!"treeSapling".equals(OreDictionary.getOreName((int)id))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected EnumFacing.Axis getPortalWoodFrameAxis(World world, BlockPos pos) {
        EnumFacing north = EnumFacing.NORTH;
        EnumFacing south = EnumFacing.SOUTH;
        if (this.isPortalWood(world.func_180495_p(pos)) && this.isPortalWood(world.func_180495_p(pos.func_177972_a(north))) && this.isPortalWood(world.func_180495_p(pos.func_177972_a(south))) && this.isPortalWood(world.func_180495_p(pos.func_177984_a().func_177972_a(north))) && this.isPortalWood(world.func_180495_p(pos.func_177984_a().func_177972_a(south))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(2).func_177972_a(north))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(2).func_177972_a(south))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3).func_177972_a(north))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3).func_177972_a(south)))) {
            return EnumFacing.Axis.X;
        }
        EnumFacing east = EnumFacing.EAST;
        EnumFacing west = EnumFacing.WEST;
        if (this.isPortalWood(world.func_180495_p(pos)) && this.isPortalWood(world.func_180495_p(pos.func_177972_a(east))) && this.isPortalWood(world.func_180495_p(pos.func_177972_a(west))) && this.isPortalWood(world.func_180495_p(pos.func_177984_a().func_177972_a(east))) && this.isPortalWood(world.func_180495_p(pos.func_177984_a().func_177972_a(west))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(2).func_177972_a(east))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(2).func_177972_a(west))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3).func_177972_a(east))) && this.isPortalWood(world.func_180495_p(pos.func_177981_b(3).func_177972_a(west)))) {
            return EnumFacing.Axis.Z;
        }
        return null;
    }

    protected boolean isPortalWood(IBlockState state) {
        Block block = state.func_177230_c();
        return block == BlockRegistry.PORTAL_FRAME || block == BlockRegistry.LOG_PORTAL;
    }

    @Override
    public Map<Integer, String> getVariants() {
        HashMap<Integer, String> variants = new HashMap<Integer, String>();
        for (EnumTalisman type : EnumTalisman.values()) {
            variants.put(type.ordinal(), type.getTranslationKey());
        }
        return variants;
    }

    public static enum EnumTalisman implements IGenericItem
    {
        SWAMP_TALISMAN_0,
        SWAMP_TALISMAN_1,
        SWAMP_TALISMAN_2,
        SWAMP_TALISMAN_3,
        SWAMP_TALISMAN_4,
        SWAMP_TALISMAN_5;

        private final String unlocalizedName;
        private final String modelName;

        private EnumTalisman() {
            this.unlocalizedName = this.modelName = this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String getTranslationKey() {
            return this.unlocalizedName;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        @Override
        public int getID() {
            return this.ordinal();
        }

        @Override
        public Item getItem() {
            return ItemRegistry.SWAMP_TALISMAN;
        }
    }
}

